/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics.serialization;

import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.TopTenCounter;
import com.cognos.cm.diagnostics.serialization.CounterPrinter;
import com.cognos.cm.diagnostics.serialization.CounterSerializer;

public class TopTenCounterSerializer
implements CounterSerializer {
    public static final String[] FIELDS = new String[]{"value", "data"};

    @Override
    public String[] getFields() {
        return FIELDS;
    }

    @Override
    public boolean hasEntries() {
        return true;
    }

    @Override
    public void serialize(Counter counter, CounterPrinter printer) {
        if (!(counter instanceof TopTenCounter)) {
            throw new IllegalArgumentException("Counter must be of class " + TopTenCounter.class.getName());
        }
        TopTenCounter topTenCounter = (TopTenCounter)counter;
        printer.beginEntries();
        for (int i = 0; i < topTenCounter.maxEntries(); ++i) {
            TopTenCounter.Entry entry = topTenCounter.getEntry(i);
            if (entry.data == null) break;
            printer.beginEntry();
            printer.printField("value", entry.value);
            printer.printField("data", entry.data.toString());
            printer.endEntry();
        }
        printer.endEntries();
    }
}

