/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.externalRepository;

import com.cognos.cm.externalRepository.ExternalObjectStoreConnectionProvider;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.indications.LoggingSystem;
import com.cognos.cm.notification.Notification;
import com.cognos.cm.notification.NotificationObserver;
import com.cognos.cm.notification.Subscription;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.server.CMException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EOSNotificationObserver
implements NotificationObserver {
    private static Log log = LogFactory.getLog(EOSNotificationObserver.class);
    private ExternalObjectStoreConnectionProvider provider;
    private LoggingSystem auditLog;

    public EOSNotificationObserver() {
        this(ExternalObjectStoreConnectionProvider.getInstance(), CMIndications.getLoggingSystem());
    }

    public EOSNotificationObserver(ExternalObjectStoreConnectionProvider provider, LoggingSystem auditLog) {
        this.provider = provider;
        this.auditLog = auditLog;
        log.info((Object)"EOSNotificationObserver created");
    }

    @Override
    public void initialize(Subscription subscription) {
    }

    @Override
    public void addNotification(Notification notification) {
        this.processDeleteNotification(notification);
    }

    @Override
    public void addNotifications(ArrayList<Notification> notifications) {
        for (Notification notification : notifications) {
            this.processDeleteNotification(notification);
        }
    }

    private void processDeleteNotification(Notification notification) {
        String storeID = notification.getStoreID();
        if (log.isDebugEnabled()) {
            log.debug((Object)("processDeleteNotification('" + storeID + "')"));
        }
        try {
            RepositoryConnection conn = this.provider.getRepositoryConnection();
            conn.deleteData(storeID);
        }
        catch (RepositoryException e) {
            CMException cmex = new CMException((Exception)((Object)e), "cmEOSDeleteFailure", "STOREID", storeID);
            this.auditLog.log(cmex);
        }
    }

    @Override
    public void enable(boolean enable) {
    }
}

