/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.externalRepository;

import com.cognos.cm.externalRepository.CMPluginResourceLoader;
import com.cognos.cm.externalRepository.ExternalObjectStoreRegistration;
import com.cognos.cm.externalRepository.RepositoryHttpClientFactory;
import com.cognos.cm.repositoryPluginAPI.IRepositoryUserAgentFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cm.repositoryPluginFramework.IRepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.IRepositoryPluginManager;
import com.cognos.cm.repositoryPluginFramework.RepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.IExternalObjectStore;
import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class ExternalObjectStoreConnectionProvider {
    private static final String CONNECTION_STRING_PREFIX = "^User ID:^?Password:;LOCAL;RP-CMIS-CM;URL=";
    private static final String CONNECTION_STRING_SUFFIX = "/cm/1.0/objects/;DRIVER_NAME=com.ibm.cognos.cm.cmrepository.CMRepositoryPlugin";
    static final String FILE_SCHEME = "file";
    static final String FILESTORE_URI_PARAMETER_NAME = "fileStoreURI";
    private static ExternalObjectStoreConnectionProvider INSTANCE = new ExternalObjectStoreConnectionProvider();
    private final IRepositoryUserAgentFactory userAgentFactory;
    private final IPluginResourceLoader resourceLoader;
    private final IRepositoryPluginManager pluginManager;
    private String connectionString;
    private RepositoryConnection connection;

    ExternalObjectStoreConnectionProvider() {
        this((IRepositoryUserAgentFactory)RepositoryHttpClientFactory.getInstance(), new CMPluginResourceLoader(), RepositoryPluginManager.getManager());
    }

    ExternalObjectStoreConnectionProvider(IRepositoryUserAgentFactory userAgentFactory, IPluginResourceLoader resourceLoader, IRepositoryPluginManager pluginManager) {
        this.userAgentFactory = userAgentFactory;
        this.resourceLoader = resourceLoader;
        this.pluginManager = pluginManager;
    }

    public synchronized void initialize(String dispatcherURL) throws CMException {
        if (dispatcherURL == null || dispatcherURL.isEmpty()) {
            IllegalArgumentException ex = new IllegalArgumentException("Invalid dispatcher URL: " + dispatcherURL);
            throw new CMException(ex, "cmLoadEOSPluginFailure");
        }
        this.connectionString = CONNECTION_STRING_PREFIX + dispatcherURL + CONNECTION_STRING_SUFFIX;
        this.initializeConnection();
    }

    public RepositoryConnection getRepositoryConnection() {
        return this.connection;
    }

    public String getRepositoryConnectionString() {
        return this.connectionString;
    }

    private void initializeConnection() throws CMException {
        if (this.connection == null) {
            try {
                Properties connectionProperties = this.getConnectionProperties();
                IRepositoryConnectionString repositoryConnectionString = this.getRepositoryConnectionString(this.connectionString);
                this.connection = this.pluginManager.getConnection(this.userAgentFactory, repositoryConnectionString, connectionProperties, this.resourceLoader);
            }
            catch (Exception ex) {
                throw new CMException(ex, "cmLoadEOSPluginFailure");
            }
        }
    }

    private Properties getConnectionProperties() {
        Properties connectionProperties = new Properties();
        connectionProperties.put("CONSUMER_NAME", "CM");
        return connectionProperties;
    }

    private IRepositoryConnectionString getRepositoryConnectionString(String datasourceConnectionString) throws RepositoryException {
        return new RepositoryConnectionString(datasourceConnectionString);
    }

    public static ExternalObjectStoreConnectionProvider getInstance() {
        return INSTANCE;
    }

    public long getFreeSpace() {
        long bytes = 0L;
        IConfiguration config = ConfigurationFactory.getConfig();
        if (!config.isExternalObjectStoreEnabled()) {
            return bytes;
        }
        IExternalObjectStore repositoryConfig = config.getExternalObjectStore();
        File f = new File(this.getEOSPath(repositoryConfig));
        bytes = f.getFreeSpace();
        return bytes;
    }

    public long getUsedSpace() {
        long bytes = 0L;
        IConfiguration config = ConfigurationFactory.getConfig();
        if (!config.isExternalObjectStoreEnabled()) {
            return bytes;
        }
        IExternalObjectStore repositoryConfig = config.getExternalObjectStore();
        File f = new File(this.getEOSPath(repositoryConfig));
        bytes = FileUtils.sizeOfDirectory((File)f);
        return bytes;
    }

    protected String getEOSPath(IExternalObjectStore repositoryConfig) {
        return repositoryConfig.getOSFileStorePath();
    }

    public void register(IConfiguration config) throws CMException {
        ExternalObjectStoreRegistration registration = new ExternalObjectStoreRegistration(config);
        registration.register();
    }
}

