/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.externalRepository;

import com.cognos.cm.cmInfo;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.IExternalObjectStore;
import com.cognos.cm.util.UrlUtils;
import com.cognos.cmutils.hash.HashProviders;
import com.cognos.cmutils.hash.HashUtil;
import com.cognos.cmutils.url.FileURIUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class ExternalObjectStoreRegistration {
    private static final String REGISTRY_DIR_NAME = ".registry";
    private static final String SYSTEM_PREFIX = "system.";
    private static final String CM_PREFIX = "cm.";
    private static final String CONFIG_PREFIX = "config.";
    private IConfiguration config;

    ExternalObjectStoreRegistration(IConfiguration config) {
        this.config = config;
    }

    public void register() throws CMException {
        IExternalObjectStore eos = this.config.getExternalObjectStore();
        if (eos == null || !eos.isEnabled()) {
            return;
        }
        String storeLocation = this.getEOSPath();
        this.createRegistryDirectory(storeLocation);
        this.writeRegistrationFile(storeLocation);
    }

    Properties getRegistrationFileProperties() {
        Properties props = new Properties();
        this.addProperty(props, SYSTEM_PREFIX, "osName", System.getProperty("os.name"));
        this.addProperty(props, SYSTEM_PREFIX, "osVersion", System.getProperty("os.version"));
        this.addProperty(props, SYSTEM_PREFIX, "userName", System.getProperty("user.name"));
        this.addProperty(props, CM_PREFIX, "buildVersion", cmInfo.getVersion());
        this.addProperty(props, CM_PREFIX, "storeVersion", cmInfo.getStoreVersion().toString());
        this.addProperty(props, CONFIG_PREFIX, "directory", this.config.getConfigurationDirectory().getAbsolutePath());
        this.addProperty(props, CONFIG_PREFIX, "databaseType", this.config.getDatabaseType());
        this.addProperty(props, CONFIG_PREFIX, "databaseConnect", this.config.getDatabaseConnect());
        this.addProperty(props, CONFIG_PREFIX, "externalDispatcher", this.config.getCognosProp("externalDispatcher"));
        this.addProperty(props, CONFIG_PREFIX, "internalDispatcher", this.config.getCognosProp("internalDispatcher"));
        this.addProperty(props, CONFIG_PREFIX, "localCMURL", this.config.getCognosProp("localCMURL"));
        this.addProperty(props, CONFIG_PREFIX, "contentManagers", this.config.getCognosProp("contentManagers"));
        IExternalObjectStore repositoryConfig = this.config.getExternalObjectStore();
        this.addProperty(props, CONFIG_PREFIX, "unixRepositoryURI", repositoryConfig.getUnixFileStoreURI());
        this.addProperty(props, CONFIG_PREFIX, "windowsRepositoryURI", repositoryConfig.getWinFileStoreURI());
        return props;
    }

    private String getEOSPath() {
        IExternalObjectStore repositoryConfig = this.config.getExternalObjectStore();
        return FileURIUtils.getPathFromURI((String)repositoryConfig.getOSFileStoreURI());
    }

    private void createRegistryDirectory(String repositoryLocation) throws CMException {
        String registryDirectoryPath = this.getRegistryDirectoryPath(repositoryLocation);
        this.createDirectory(registryDirectoryPath);
    }

    private String getRegistryDirectoryPath(String repositoryLocation) {
        StringBuilder sb = new StringBuilder(repositoryLocation);
        sb.append(File.separatorChar);
        sb.append(REGISTRY_DIR_NAME);
        return sb.toString();
    }

    private void createDirectory(String path) throws CMException {
        File directory = new File(path);
        if (!directory.exists()) {
            try {
                FileUtils.forceMkdir((File)directory);
            }
            catch (IOException e) {
                throw new CMException(e);
            }
        }
    }

    private void writeRegistrationFile(String repositoryLocation) throws CMException {
        Properties properties = this.getRegistrationFileProperties();
        String registrationFilePath = this.getRegistrationFilePath(repositoryLocation, properties);
        if (registrationFilePath != null) {
            this.writeRegistrationFile(registrationFilePath, properties);
        }
    }

    private void addProperty(Properties properties, String prefix, String name, String value) {
        if (name != null && value != null) {
            properties.setProperty(prefix + name, value);
        }
    }

    private String getRegistrationFilePath(String repositoryLocation, Properties properties) throws CMException {
        String registrationFilePath = null;
        String registrationFilename = this.getRegistrationFilename(properties);
        if (registrationFilename != null) {
            StringBuilder sb = new StringBuilder(repositoryLocation);
            sb.append(File.separatorChar);
            sb.append(REGISTRY_DIR_NAME);
            sb.append(File.separatorChar);
            sb.append(registrationFilename);
            registrationFilePath = sb.toString();
        }
        return registrationFilePath;
    }

    private String getRegistrationFilename(Properties properties) throws CMException {
        String localCMURL = properties.getProperty("config.localCMURL");
        localCMURL = this.convertURItoDispatcherPath(localCMURL);
        HashUtil hasher = new HashUtil(HashProviders.MD5);
        String registrationFilename = hasher.hash(localCMURL);
        return registrationFilename;
    }

    private void writeRegistrationFile(String registrationFilePath, Properties properties) throws CMException {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(registrationFilePath));
            ArrayList<String> keys = new ArrayList<String>();
            for (Object o : properties.keySet()) {
                keys.add((String)o);
            }
            Collections.sort(keys);
            for (String key : keys) {
                String value = properties.getProperty(key);
                writer.println(key + "=" + value);
            }
            writer.close();
        }
        catch (IOException e) {
            throw new CMException(e);
        }
    }

    protected String convertURItoDispatcherPath(String url) throws CMException {
        return UrlUtils.convertURItoDispatcherPath(url, true, false);
    }
}

