/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.externalRepository;

import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cm.externalRepository.CMPluginResourceLoader;
import com.cognos.cm.multitenancy.ReadTenantFilter;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMString;
import com.cognos.cm.repositoryPluginAPI.IRepositoryUserAgentFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnectionProperties;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cm.repositoryPluginFramework.IRepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.IRepositoryPluginManager;
import com.cognos.cm.repositoryPluginFramework.RepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMEnvironment;
import com.cognos.cm.util.DataEncryptionHelper;
import com.cognos.cmutils.path.SearchPathEncoder;
import com.cognos.cmutils.properties.Credentials;
import com.cognos.cmutils.properties.IDataEncryptionHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class RepositoryConnectionProvider {
    private static final String CONNECTION_SEARCH_PATH = "connectionSearchPath";
    private final Map<String, RepositoryConnection> connectionCache = new HashMap<String, RepositoryConnection>();

    RepositoryConnectionProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getRepositoryConnectionParameters(CMStore store, String repositoryConnectionName, int tenantID) throws CMException {
        boolean asTransaction = !store.inTransaction();
        try {
            if (asTransaction) {
                store.beginTransaction();
            }
            Properties connectionParameters = this.getRepositoryConnectionParametersInTransaction(store, repositoryConnectionName, tenantID);
            if (asTransaction) {
                store.commitTransaction();
            }
            Properties properties = connectionParameters;
            return properties;
        }
        finally {
            if (asTransaction && store.inTransaction()) {
                store.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getRepositoryConnectionParametersInTransaction(CMStore store, String repositoryConnectionName, int tenantID) throws CMStoreParseException, CMException {
        CMProperty[] properties = new CMProperty[]{CMProperty.CONNECTIONSTRING, CMProperty.CREDENTIALS};
        CMStoreXPath dataSourceSignonPath = new CMStoreXPath(this.createDataSourceSignonSearch(repositoryConnectionName));
        CMStoreQueryResults results = null;
        CMExecutionContext context = null;
        ReadTenantFilter previousTenantFilter = null;
        try {
            context = this.getExecutionContext();
            previousTenantFilter = context.getReadTenantFilter();
            context.setReadTenantFilter(new ReadTenantFilter.FixedListTenantFilter(tenantID));
            results = store.executeQuery(dataSourceSignonPath, properties, null, 0, 512, null);
            HashMap<Integer, ConnectionData> connectionDataMap = new HashMap<Integer, ConnectionData>();
            boolean hasObject = results.next();
            if (!hasObject) {
                throw this.createConnectionNotFoundException(dataSourceSignonPath);
            }
            while (hasObject) {
                this.addDataSourceSignonProperties(connectionDataMap, results, tenantID);
                hasObject = results.next();
            }
            if (connectionDataMap.size() > 1) {
                throw new CMException("cmAmbiguousRepositoryConnection", new CMException.Parm("DATASOURCE_NAME", repositoryConnectionName));
            }
            Properties connectionProperties = this.getConnectionParameters(connectionDataMap, tenantID);
            if (connectionProperties == null) {
                String tenantIDString = store.getTenantRegistry().getTenantIdStringFromInt(tenantID);
                CMException cme = this.createConnectionNotFoundForTenantIDException(dataSourceSignonPath, tenantIDString);
                throw cme;
            }
            Properties properties2 = connectionProperties;
            return properties2;
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (context != null) {
                context.setReadTenantFilter(previousTenantFilter);
            }
        }
    }

    private CMException createConnectionNotFoundForTenantIDException(CMStoreXPath dataSourceSignonPath, String tenantIDString) {
        CMException cme = new CMException("cmCannotGetConnectionForTenantID", new CMException.Parm("TENANT_ID", tenantIDString));
        return new CMException((Exception)cme, "cmCannotGetConnectionToRepository", new CMException.Parm("REPOSITORY", dataSourceSignonPath));
    }

    private CMException createConnectionNotFoundException(CMStoreXPath dataSourceSignonPath) {
        CMException cme = new CMException("cmConnectionNotFound");
        return new CMException((Exception)cme, "cmCannotGetConnectionToRepository", new CMException.Parm("REPOSITORY", dataSourceSignonPath));
    }

    private void addDataSourceSignonProperties(Map<Integer, ConnectionData> connectionDataMap, CMStoreQueryResults results, int tenantID) throws CMException {
        Object credentialsValueObject;
        Object connectionStringValue = results.getValue(0);
        if (connectionStringValue != null) {
            String connectionString = ((CMString)connectionStringValue).getValue();
            Properties connectionProps = this.getConnectionProps(connectionDataMap, results.getObjectID(), results.getTenantID());
            connectionProps.put("connectionString", connectionString);
            connectionProps.put(CONNECTION_SEARCH_PATH, results.getSearchPath());
        }
        if ((credentialsValueObject = results.getValue(1)) != null) {
            String credentialsPropertyName = this.getCredentialsPropertyName();
            try {
                Properties connectionProps = this.getConnectionProps(connectionDataMap, results.getParentObjectID(), results.getTenantID());
                if (!connectionProps.containsKey("user") || results.getTenantID() == tenantID) {
                    Properties credentialsProperties = this.createCredentialsProperties(credentialsValueObject);
                    connectionProps.putAll((Map<?, ?>)credentialsProperties);
                }
            }
            catch (Exception ex) {
                throw new CMException(ex, "cmPropReadFail", new CMException.Parm("Prop", credentialsPropertyName));
            }
        }
    }

    private Properties getConnectionProps(Map<Integer, ConnectionData> connectionDataMap, int objectID, int tenantID) {
        ConnectionData connectionData = connectionDataMap.get(objectID);
        if (connectionData == null) {
            connectionData = new ConnectionData(tenantID);
            connectionDataMap.put(objectID, connectionData);
        }
        return connectionData.connectionProperties;
    }

    private Properties getConnectionParameters(Map<Integer, ConnectionData> connectionDataMap, int tenantID) {
        Properties connectionProps = null;
        for (ConnectionData connectionData : connectionDataMap.values()) {
            if (tenantID != connectionData.tenantID) continue;
            connectionProps = connectionData.connectionProperties;
            break;
        }
        return connectionProps;
    }

    protected Properties createCredentialsProperties(Object credentialsValueObject) throws Exception {
        EncryptingSession es = CMServlet.CAMFactory_.createEncryptingSession();
        DataEncryptionHelper encryptionHelper = new DataEncryptionHelper(es);
        String sEncodedEncryptedCredentials = RequestHandler.readAnyTypePropertyValueIntoString(credentialsValueObject);
        String[] usernameAndPassword = new Credentials((IDataEncryptionHelper)encryptionHelper).createCredentialsPropertiesFromPropertyValue(sEncodedEncryptedCredentials);
        Properties credentialsProperties = new Properties();
        credentialsProperties.put("user", usernameAndPassword[0]);
        credentialsProperties.put("password", usernameAndPassword[1]);
        return credentialsProperties;
    }

    protected String getCredentialsPropertyName() {
        return CMProperty.CREDENTIALS.getName();
    }

    private String createDataSourceSignonSearch(String repositoryConnectionNane) {
        return "dataSourceSignon(" + SearchPathEncoder.quoteString((String)repositoryConnectionNane) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnection getRepositoryConnection(CMStore store, String repositoryConnectionName, int tenantID, String consumerName, String testConectionOption, IRepositoryUserAgentFactory userAgentFactory) throws CMException {
        Properties connectionProperties = this.getRepositoryConnectionParameters(store, repositoryConnectionName, tenantID);
        connectionProperties = this.addAdditionalConnectionParameters(connectionProperties, consumerName, testConectionOption);
        String connectionCacheKey = this.getConnectionCacheKey(connectionProperties);
        RepositoryConnection connection = null;
        Map<String, RepositoryConnection> map = this.connectionCache;
        synchronized (map) {
            connection = this.connectionCache.get(connectionCacheKey);
            if (connection == null) {
                CMPluginResourceLoader resourceLoader = new CMPluginResourceLoader();
                try {
                    String datasourceConnectionString = connectionProperties.getProperty("connectionString");
                    IRepositoryConnectionString repositoryConnectionString = this.getRepositoryConnectionString(datasourceConnectionString);
                    IRepositoryPluginManager manager = this.getRepositoryPluginManager();
                    connection = manager.getConnection(userAgentFactory, repositoryConnectionString, connectionProperties, (IPluginResourceLoader)resourceLoader);
                    this.connectionCache.put(connectionCacheKey, connection);
                }
                catch (Exception ex) {
                    throw new CMException(ex, "cmCannotGetConnectionToRepository", new CMException.Parm("REPOSITORY", repositoryConnectionName));
                }
            }
        }
        return connection;
    }

    String getConnectionCacheKey(Properties connectionProperties) {
        String datasourceConnectionString = connectionProperties.getProperty("connectionString");
        String userName = connectionProperties.getProperty("user");
        userName = userName != null ? userName : "";
        return userName + ":" + datasourceConnectionString;
    }

    protected Properties addAdditionalConnectionParameters(Properties connectionProperties, String consumerName, String testConectionOption) {
        connectionProperties.put("CONSUMER_NAME", consumerName);
        connectionProperties.setProperty("reload", "true");
        if (testConectionOption != null) {
            connectionProperties.put(RepositoryConnectionProperties.TEST_REPOSITORY_CONNECTION, testConectionOption);
        }
        return connectionProperties;
    }

    protected IRepositoryConnectionString getRepositoryConnectionString(String datasourceConnectionString) throws RepositoryException {
        return new RepositoryConnectionString(datasourceConnectionString);
    }

    protected File getLogDirectory() {
        return CMEnvironment.getCRNLogsDir();
    }

    protected boolean isCMRunningInTestMode() {
        return ContentManager.isTestMode();
    }

    protected IRepositoryPluginManager getRepositoryPluginManager() {
        return RepositoryPluginManager.getManager();
    }

    CMExecutionContext getExecutionContext() {
        return CMExecutionContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanConnectionCache() {
        Map<String, RepositoryConnection> map = this.connectionCache;
        synchronized (map) {
            for (RepositoryConnection connection : this.connectionCache.values()) {
                connection.close();
            }
            this.connectionCache.clear();
        }
    }

    public static RepositoryConnectionProvider getInstance() {
        return new RepositoryConnectionProvider();
    }

    private static class ConnectionData {
        final int tenantID;
        final Properties connectionProperties = new Properties();

        ConnectionData(int tenantID) {
            this.tenantID = tenantID;
        }
    }
}

