/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.indications;

import com.cognos.cm.indications.AuditAccessFilter;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.server.CMException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AuditAccessFiltersLoader {
    private final HashSet<String> EMPTY_SET = new HashSet();
    private final CMObjectClasses objectClasses;

    public AuditAccessFiltersLoader(CMObjectClasses classes) {
        this.objectClasses = classes;
    }

    public HashMap<String, AuditAccessFilter> load(InputStream is) throws DocumentException, CMException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(is);
        return this.load(doc.getRootElement());
    }

    protected HashMap<String, AuditAccessFilter> load(Element el) throws CMException {
        if (!el.getName().equals("auditFilters")) {
            throw new CMException("cmExpectedElement", new CMException.Parm("Name", "auditFilters"), new CMException.Parm("Found", el.getName()));
        }
        HashMap<String, Set<String>> groups = this.loadGroups(el);
        return this.loadOperations(el, groups);
    }

    private HashMap<String, AuditAccessFilter> loadOperations(Element el2, HashMap<String, Set<String>> groups) throws CMException {
        HashMap<String, AuditAccessFilter> result = new HashMap<String, AuditAccessFilter>();
        for (Element el2 : el2.selectNodes("operations/operation")) {
            String op_name = el2.attributeValue("name");
            if (op_name == null || op_name.length() == 0) {
                throw new CMException("cmExpectedAttributeMissing", new CMException.Parm("Name", "name"), new CMException.Parm("Element", el2.getName()));
            }
            AuditAccessFilter filter = this.createFilter(el2, groups);
            if (filter.isEmpty()) continue;
            result.put(op_name.toUpperCase(), filter);
        }
        return result;
    }

    private AuditAccessFilter createFilter(Element el, HashMap<String, Set<String>> groups) throws CMException {
        String v = el.attributeValue("filterUndefined");
        boolean filterUndefined = v == null ? false : Boolean.parseBoolean(v);
        AuditAccessFilter filter = new AuditAccessFilter(filterUndefined);
        for (Element groupEl : el.elements("group")) {
            v = groupEl.getText();
            Set<String> group = groups.get(v);
            if (group == null) {
                throw new CMException("cmUnresolvedClassGroup", new CMException.Parm("Name", v));
            }
            filter.addGroup(group);
        }
        Iterator it = el.elements("class").iterator();
        Set<String> group = this.loadClasses(it);
        if (group != null) {
            filter.addGroup(group);
        }
        return filter;
    }

    private HashMap<String, Set<String>> loadGroups(Element el2) throws CMException {
        HashMap<String, Set<String>> groups = new HashMap<String, Set<String>>();
        for (Element el2 : el2.selectNodes("groups/group")) {
            String name = el2.attributeValue("name");
            if (name == null || name.length() == 0) {
                throw new CMException("cmExpectedAttributeMissing", new CMException.Parm("Name", "name"), new CMException.Parm("Element", el2.getName()));
            }
            Set<String> classes = this.loadClasses(el2.elements().iterator());
            if (classes == null) continue;
            groups.put(name, classes);
        }
        return groups;
    }

    private Set<String> loadClasses(Iterator it) throws CMException {
        HashSet<String> result = new HashSet<String>();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String name = el.getText();
            if (name.equals("baseClass")) {
                return this.EMPTY_SET;
            }
            this.addObjectClassToSet(name, result);
        }
        return result.size() == 0 ? null : result;
    }

    private void addObjectClassToSet(String name, Set<String> set) throws CMException {
        CMObjectClass cls = this.objectClasses.getClassByName(name);
        if (cls == null) {
            throw new CMException("cmInvalidObjectClass", new CMException.Parm("Class", name));
        }
        ArrayList<CMObjectClass> derived = cls.getDerivedClasses();
        for (int i = 0; i < derived.size(); ++i) {
            cls = derived.get(i);
            set.add(cls.getName().toUpperCase());
        }
    }
}

