/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.indications;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.indications.AuditAccessFilter;
import com.cognos.cm.indications.AuditAccessFiltersLoader;
import com.cognos.cm.indications.IPFLoggingSystem;
import com.cognos.cm.indications.LoggingSystem;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExceptionMessage;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.util.CMIPFData;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cmutils.config.ConfigurationException;
import com.cognos.cmutils.resource.CMResourceLoader;
import com.cognos.cmutils.xml.XMLUtils;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogTypedLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;

public class CMIndications
extends LogAuditAccessIndication {
    private static final long serialVersionUID = 8786021979797915193L;
    public static final boolean IFDEF_DEBUG_BUILD = false;
    protected static LoggingSystem logSys_ = new IPFLoggingSystem();
    public static final int IPF_LEVEL_DEBUG = 10000;
    public static final int IPF_LEVEL_TRACE = 20000;
    public static final int IPF_LEVEL_REQUEST = 30000;
    public static final int IPF_LEVEL_SESSION = 40000;
    public static final int IPF_LEVEL_SERVICE = 50000;
    public static final int IPF_LEVEL_INFO = 20000;
    public static final int IPF_LEVEL_WARN = 30000;
    public static final int IPF_LEVEL_ERROR = 40000;
    public static final int IPF_LEVEL_FATAL = 50000;
    public static final int IPF_LEVEL_OFF = Integer.MAX_VALUE;
    protected static final String SYS = "SYS";
    protected static final String CFG = "CFG";
    protected static final String REQ = "REQ";
    protected static final String TR1 = "TR1";
    protected static final String TRQ = "TRQ";
    protected static final String TIN = "TIN";
    protected static final String SDS = "SDS";
    protected static final String INDEX = "INDEX";
    protected static final String SYNCHROMESH = "SYNCHROMESH";
    protected static final String CRAWLER = "CRAWLER";
    protected static final String SQL = "SQL";
    protected static final String TCH = "TCH";
    protected static final String TLM = "TLM";
    protected static final String SES = "SES";
    protected static final String PRF = "PRF";
    protected static final String DEP = "DEP";
    protected static final String ERR = "ERR";
    protected static final String ELECT = "ELECT";
    protected static final String TASK = "TASK";
    protected static final String REP = "REP";
    protected static final String MIME = "MIME";
    protected static final String CAM = "CAM";
    public static final String AUDIT_LOG = "Audit";
    protected static final String AUDIT_RTUSAGE_PREFIX = "Audit.RTUsage.CM";
    protected static final String AUDIT_ADMIN_PREFIX = "Audit.Admin.CM";
    protected static final String AUDIT_OTHER_PREFIX = "Audit.Other.CM";
    static final String AUDIT_REQUEST_SUFFIX = ".Request";
    public static final String AUDIT_CM_LOG = "Audit.CM";
    public static final String AUDIT_RTUSAGE_LOG = "Audit.RTUsage.CM";
    public static final String AUDIT_ADMIN_LOG = "Audit.Admin.CM";
    public static final String AUDIT_OTHER_LOG = "Audit.Other.CM";
    protected static final String TRACE_PREFIX = "Trace.CM.";
    public static final String TRACE_REQ_LOG = "Trace.CM.REQ";
    public static final String TRACE_SDS_LOG = "Trace.CM.SDS";
    public static final String TRACE_INDEX_LOG = "Trace.CM.INDEX";
    public static final String TRACE_SYNCHROMESH_LOG = "Trace.CM.SYNCHROMESH";
    public static final String TRACE_CRAWLER_LOG = "Trace.CM.CRAWLER";
    public static final String TRACE_SQL_LOG = "Trace.CM.SQL";
    public static final String TRACE_TCH_LOG = "Trace.CM.TCH";
    public static final String TRACE_TIN_LOG = "Trace.CM.TIN";
    public static final String TRACE_TLM_LOG = "Trace.CM.TLM";
    public static final String TRACE_TR1_LOG = "Trace.CM.TR1";
    public static final String TRACE_TRQ_LOG = "Trace.CM.TRQ";
    public static final String TRACE_SYS_LOG = "Trace.CM.SYS";
    public static final String TRACE_CFG_LOG = "Trace.CM.CFG";
    public static final String TRACE_SES_LOG = "Trace.CM.SES";
    public static final String TRACE_PRF_LOG = "Trace.CM.PRF";
    public static final String TRACE_DEP_LOG = "Trace.CM.DEP";
    public static final String TRACE_ERR_LOG = "Trace.CM.ERR";
    public static final String TRACE_FOV_LOG = "Trace.CM.ELECT";
    public static final String TRACE_TASK_LOG = "Trace.CM.TASK";
    public static final String TRACE_REP_LOG = "Trace.CM.REP";
    public static final String TRACE_MIME_LOG = "Trace.CM.MIME";
    public static final String TRACE_CAM_LOG = "Trace.CM.CAM";
    public static final String TRACE_DBG_GNL_LOG = "Trace.CM.DBG.GNL";
    public static final String TRACE_DBG_SAX_LOG = "Trace.CM.DBG.SAX";
    public static final String TRACE_DBG_TMP_LOG = "Trace.CM.DBG.TMP";
    public static final String TRACE_DBG_ECM_LOG = "Trace.CM.DBG.ECM";
    public static final String PERF_PREFIX = "Perf.CM.";
    public static final String STACKTRACE = "stacktrace";
    public static final String STACKTRACE_SUFFIX = ".stacktrace";
    public static final String PERF_DEBUG_LOG = "Perf.CM.debug";
    public static final String PERF_STACKTRACE_LOG = "Perf.CM.stacktrace";
    public static final String TRACE_STACKTRACE_LOG = "Trace.CM.stacktrace";
    public static String g_sDefaultIPFCategory;
    public static String g_sDefaultIPFOperation;
    public static boolean g_bPrintTraceStacktraces;
    public static int g_nBuildNumber_;
    static final boolean USE_AUDIT_INDICATION = false;
    static final boolean USE_AUDITACCESS_INDICATION = true;
    private static HashMap<String, AuditAccessFilter> auditAccessFilters;
    protected static final int CMIND_NOT_A_LEVEL = -111;

    public static LoggingSystem getLoggingSystem() {
        return logSys_;
    }

    public static void setLoggingSystem(LoggingSystem logSys) {
        logSys_ = logSys;
    }

    public static void reconfigure() {
        logSys_.reconfigure();
    }

    public static void initialize() throws CMConfigurationException {
        try {
            logSys_.initialize();
        }
        catch (ConfigurationException e) {
            new CMConfigurationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAuditAccessFilters(CMObjectClasses classes) {
        InputStream is = null;
        try {
            CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
            String fileName = "/WEB-INF/cm/auditAccessFilters.xml";
            is = resourceLoader.getResourceInputStream(fileName);
            if (is == null) {
                return;
            }
            AuditAccessFiltersLoader loader = new AuditAccessFiltersLoader(classes);
            auditAccessFilters = loader.load(is);
            CMIndications.Audit_Message_FreeFormText("cmAuditAccessFiltersLoaded", null, 50000, "StartService", "ContentManagerService", "", "Info", null);
        }
        catch (Exception e) {
            CMException ex = new CMException(e, "cmErrorLoadingAuditAccessFilters");
            ex.setErrorLevel(40000);
            CMIndications.logException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isInitialized() {
        return logSys_.isInitialized();
    }

    public static void shutdown() {
        logSys_.shutdown();
    }

    public static void logThrowable(Throwable ex) {
        logSys_.log(ex);
    }

    public static void logException(Throwable ex) {
        CMIndications.logThrowable(ex);
    }

    public static void logException(String category, int level, Exception e) {
        if (!CMIndications.logEnabled(category, level)) {
            return;
        }
        if (category.startsWith(AUDIT_LOG)) {
            CMIndications.logThrowable(e);
            return;
        }
        String text = e.toString() + CMConstants.NEW_LINE_SEPERATOR + CMIndications.getStacktraceText_Complete(e);
        logSys_.traceText(category, level, text);
    }

    public static void logException(Throwable ex, String request) {
        CMIndications.logException(ex, request, null, null, null);
    }

    public static void logException(Throwable ex, String request, String sOperation, String sObjectType, String sObjectPath) {
        logSys_.logException(ex, request, sOperation, sObjectType, sObjectPath);
    }

    public static void logData(String xmlData) {
        logSys_.logData(xmlData);
    }

    public static int getLogLevel(String sCategory) {
        return logSys_.getLogLevel(sCategory);
    }

    public static boolean logEnabled(String sCategory) {
        return CMIndications.logEnabled(sCategory, 10000);
    }

    public static boolean logEnabled(String sCategory, int nLevel) {
        return logSys_.logEnabled(sCategory, nLevel);
    }

    public static void CMTraceText(String sCategory, int nLevel, String sMsgText) {
        logSys_.traceText(sCategory, nLevel, sMsgText);
    }

    public static void CMDebugTrace(CMExceptionMessage message) {
        String msg = CMError.getMessage(message.getCode(), message.getParms());
        CMIndications.CMDebugTrace(msg);
    }

    public static void CMDebugTrace(String sMsgText) {
        logSys_.traceText(TRACE_DBG_GNL_LOG, 10000, "DEBUG: " + sMsgText);
    }

    public static void CMTempDebugTrace(String sMsgText) {
        logSys_.traceText(TRACE_DBG_TMP_LOG, 10000, "TEMP: " + sMsgText);
    }

    public static void CMTrace(String sMsgCode) {
        logSys_.trace(-111, sMsgCode, null);
    }

    public static void CMTrace(String sMsgCode, CMException.Parm p1) {
        logSys_.trace(-111, sMsgCode, new CMException.Parm[]{p1});
    }

    public static void CMTrace(String sMsgCode, CMException.Parm p1, CMException.Parm p2) {
        logSys_.trace(-111, sMsgCode, new CMException.Parm[]{p1, p2});
    }

    public static void CMTrace(String sMsgCode, CMException.Parm[] listExceptionParms) {
        logSys_.trace(-111, sMsgCode, listExceptionParms);
    }

    public static boolean CMMessageEnabled(String sMsgCode) {
        return logSys_.CMMessageEnabled(sMsgCode);
    }

    public static void appendStacktraceToSB(StringBuffer sb) {
        sb.append("<stacktrace>");
        String sStackTrace = CMIndications.getStacktraceText_Trimmed();
        sStackTrace = XMLUtils.escape((String)sStackTrace);
        sb.append(sStackTrace);
        sb.append("</stacktrace>");
    }

    public static String getStacktraceText_Trimmed() {
        Exception ex = new Exception();
        ex.fillInStackTrace();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        PrintStream ps = new PrintStream(baos);
        ex.printStackTrace(ps);
        String s = baos.toString();
        s = CMIndications.trimStacktrace(s);
        return s;
    }

    public static String trimStacktrace(String s) {
        String sTag = "CMIndications.java";
        s = CMIndications.removeCodeInJavaClass(s, sTag);
        sTag = "IPFLoggingSystem.java";
        s = CMIndications.removeCodeInJavaClass(s, sTag);
        sTag = "TaskLoggingSystemWrapper.java";
        int i = (s = CMIndications.removeCodeInJavaClass(s, sTag)).indexOf("at");
        if (i > -1) {
            s = s.substring(i);
        }
        s = CMIndications.trimStacktraceStart(s, "com.cognos.cm.store.CMCacheImpl.Log(");
        s = CMIndications.trimStacktraceStart(s, "com.cognos.cm.indications.CMStatementProxy.logExecute(");
        s = CMIndications.trimStacktraceStart(s, "$Proxy");
        s = CMIndications.trimStacktraceStart(s, "com.cognos.cm.indications.CMPerfIndications");
        s = CMIndications.trimStacktraceStart(s, "com.cognos.cm.indications.CMPerfIndications");
        s = CMIndications.trimStacktraceEnd(s, "org.apache.catalina");
        String sRet = s = CMIndications.trimStacktraceEnd(s, "javax.servlet");
        return sRet;
    }

    private static String removeCodeInJavaClass(String s, String sTag) {
        int i = s.lastIndexOf(sTag);
        if (i > -1) {
            s = s.substring(i + sTag.length());
        }
        return s;
    }

    protected static String trimStacktraceStart(String sStack, String sToTrim) {
        String s = sStack;
        int i = s.indexOf(sToTrim);
        if (i > -1 && (i = s.indexOf(")", i)) > -1) {
            s = s.substring(i + 1);
        }
        return s;
    }

    protected static String trimStacktraceEnd(String sStack, String sToTrim) {
        String s = sStack;
        int i = s.indexOf(sToTrim);
        if (i > 6) {
            s = s.substring(0, i - 5);
        }
        return s;
    }

    protected static String getStacktraceTopMethod(String sStacktrace) {
        int nIdx_Start;
        String sRet = null;
        if (sStacktrace != null && (nIdx_Start = sStacktrace.indexOf("at ")) > -1) {
            int nIdx_End;
            if (sStacktrace.charAt(3) == ' ') {
                ++nIdx_Start;
            }
            if ((nIdx_End = sStacktrace.indexOf("(", nIdx_Start)) > -1) {
                sRet = sStacktrace.substring(nIdx_Start + 3, nIdx_End);
            }
        }
        return sRet;
    }

    public static String getStacktraceText_Complete() {
        Exception ex = new Exception();
        return CMIndications.getStacktraceText_Complete(ex);
    }

    public static String getStacktraceText_Complete(Throwable t) {
        String s = null;
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
            PrintStream ps = new PrintStream(baos);
            t.printStackTrace(ps);
            s = baos.toString();
        }
        return s;
    }

    public static void Audit_Message_FreeFormText(String sMsgCode, CMException.Parm[] listParms, int level, String sCategory, String sObjType, String sObjPath, String sStatus, String[] sErrors) {
        logSys_.audit_Message_FreeFormText(sMsgCode, listParms, level, sCategory, sObjType, sObjPath, sStatus, sErrors);
    }

    public static void Audit_Message_Config(String msgCode, CMException.Parm[] listParms, Locale locale, String status, String[] errors) {
        String sMsgText = CMError.getMessage(msgCode, listParms, locale);
        logSys_.audit(true, AUDIT_CM_LOG, 50000, "StartService", sMsgText, "ContentManagerService", "", status, errors);
    }

    public static void Audit_Message(String sMsgText) {
        logSys_.audit_Fmt1(true, AUDIT_CM_LOG, 50000, null, null, null, null, null, null, sMsgText, null, null, null);
    }

    public static void Audit_Access() {
        CMExecutionContext ctx = CMExecutionContext.get();
        ArrayList<CMIPFData> objectsAuditList = ctx.getAuditContext().getEntries();
        if (objectsAuditList != null && objectsAuditList.size() > 0) {
            for (CMIPFData objectIPFData : objectsAuditList) {
                CMIndications.Audit_Access(objectIPFData.getOperation(), objectIPFData.getObjectClass(), objectIPFData.getDisplayPath());
            }
            ctx.getAuditContext().clear();
        } else {
            CMIndications.Audit_Access(ctx.getIPFOperation(), ctx.getIPFObjectType(), ctx.getIPFObjectPath());
        }
    }

    public static void Audit_Access(String operation, String objClass, String objPath) {
        AuditAccessFilter filter;
        if (auditAccessFilters != null && (filter = auditAccessFilters.get(operation)) != null && filter.matches(objClass)) {
            return;
        }
        logSys_.audit_Fmt1(true, null, 30000, operation, objClass, objPath, "Success", null, null, null, null, null, null);
    }

    public static void Audit_Request(String sReq) {
        logSys_.audit_Fmt4(null, "Request", sReq, null, null, null, null);
    }

    public static void Audit_Response(String sResp) {
        logSys_.audit_Fmt4(null, "Response", sResp, null, null, null, null);
    }

    public static void Audit_Info(String sMsgCode, CMException.Parm[] listParms, String sCategory) {
        if (sMsgCode == null) {
            return;
        }
        String sMsgText = CMError.getMessage(sMsgCode, listParms, null);
        CMIndications._Audit(true, AUDIT_CM_LOG, 20000, sCategory, sMsgText, "ContentManagerService", "", "Info", null);
    }

    public static void Audit_Info(String msgCode, String category) {
        CMIndications.Audit_Info(msgCode, new CMException.Parm[0], category);
    }

    public static void Audit_Warning(String sMsgCode, CMException.Parm[] listParms, String sCategory) {
        CMIndications.Audit_Warning(sMsgCode, listParms, sCategory, null);
    }

    public static void Audit_Warning(String sMsgCode, CMException.Parm[] listParms, String sCategory, Locale locale) {
        if (sMsgCode == null) {
            return;
        }
        String sMsgText = CMError.getMessage(sMsgCode, listParms, locale);
        CMIndications._Audit(true, AUDIT_CM_LOG, 30000, sCategory, sMsgText, "ContentManagerService", "", "Warning", null);
    }

    public static synchronized void _Audit(boolean bAuditAccess, String sCategory, int nLevel, String sOperation, String sLogDataXML, String sObjectType, String sObjectPath, String sStatus, String[] vErrorMessages) {
        logSys_.audit(bAuditAccess, sCategory, nLevel, sOperation, sLogDataXML, sObjectType, sObjectPath, sStatus, vErrorMessages);
    }

    protected static void _writeParmsToSB(CMException.Parm[] listExceptionParms, StringBuffer sb) {
        if (listExceptionParms != null && listExceptionParms.length > 0) {
            int nIdx = 0;
            for (nIdx = 0; nIdx < listExceptionParms.length; ++nIdx) {
                CMException.Parm parm = listExceptionParms[nIdx];
                String sKey = parm.getName();
                String sValue = parm.getValue();
                CMIndications._writeParmToSB(sKey, sValue, sb);
            }
        }
    }

    protected static void _writeParmsToSB(ArrayList<?> arrayExceptionParms, StringBuffer sb) {
        if (arrayExceptionParms != null && arrayExceptionParms.size() > 0) {
            int nIdx = 0;
            for (nIdx = 0; nIdx < arrayExceptionParms.size(); ++nIdx) {
                Object obj = arrayExceptionParms.get(nIdx);
                if (!(obj instanceof CMException.Parm)) continue;
                CMException.Parm parm = (CMException.Parm)((Object)obj);
                String sKey = parm.getName();
                String sValue = parm.getValue();
                CMIndications._writeParmToSB(sKey, sValue, sb);
            }
        }
    }

    protected static void _writeParmToSB(String sKey, String sValue, StringBuffer sb) {
        sb.append("<item name=\"");
        sb.append(sKey);
        sb.append("\"><![CDATA[");
        sb.append(sValue);
        sb.append("]]></item>");
    }

    static void _writeMsgsToSB(String[] listMessages, StringBuffer sb) {
        if (listMessages != null && listMessages.length > 0) {
            int nIdx = 0;
            for (nIdx = 0; nIdx < listMessages.length; ++nIdx) {
                String sMsg = listMessages[nIdx];
                sb.append("<message>");
                sb.append(sMsg);
                sb.append("</message>");
            }
        }
    }

    static void _writeMsgsToSB(ArrayList<?> vMsgs, StringBuffer sb) {
        if (vMsgs != null && vMsgs.size() > 0) {
            int nIdx = 0;
            for (nIdx = 0; nIdx < vMsgs.size(); ++nIdx) {
                Object obj = vMsgs.get(nIdx);
                if (!(obj instanceof String)) continue;
                String sMsg = (String)obj;
                sb.append("<message>");
                sb.append(sMsg);
                sb.append("</message>");
            }
        }
    }

    public static void _DEBUG_ReportInactiveCategory(LogTypedLogger tl, int nLevel) {
        System.out.println("CM Indication on inactive category " + tl.getName() + " Level=" + nLevel);
        System.out.println(" STACKTRACE: " + CMIndications.getStacktraceText_Complete());
    }

    public static void printCDATAEnd(PrintWriter out) {
        out.print("]]>");
    }

    public static void printCDATABegin(PrintWriter out) {
        out.print("<![CDATA[" + CMConstants.NEW_LINE_SEPERATOR);
    }

    public static Throwable printThrowableMessage(Throwable ex, PrintWriter out) {
        out.print("FAULT:" + CMConstants.NEW_LINE_SEPERATOR);
        boolean done = false;
        while (!done) {
            String msg = null;
            if (ex instanceof CMException) {
                CMException cme = (CMException)ex;
                msg = cme.getMessage(null);
                if (cme.ex_ != null) {
                    ex = cme.ex_;
                } else if (cme.cause_ != null) {
                    ex = cme.cause_;
                } else {
                    done = true;
                }
            } else {
                msg = ex.getLocalizedMessage();
                if (msg == null) {
                    msg = "Exception: " + ex.getClass().getName();
                }
                done = true;
            }
            out.print(msg);
            out.print(CMConstants.NEW_LINE_SEPERATOR);
        }
        return ex;
    }

    public static void printStackTrace(Throwable ex, PrintWriter out) {
        out.print(CMConstants.NEW_LINE_SEPERATOR + "STACK:" + CMConstants.NEW_LINE_SEPERATOR);
        StringWriter wrt = new StringWriter();
        ex.printStackTrace(new PrintWriter(wrt));
        String stack = wrt.toString();
        String cognosOnlyPackagePrefix = "at com.cognos.cm";
        String ibmCognosPackagePrefix = "at com.ibm.cognos.cm";
        int idx = stack.lastIndexOf(cognosOnlyPackagePrefix);
        int offset = cognosOnlyPackagePrefix.length();
        int ibmPackageIdx = stack.lastIndexOf(ibmCognosPackagePrefix);
        if (ibmPackageIdx > idx) {
            idx = ibmPackageIdx;
            offset = ibmCognosPackagePrefix.length();
        }
        if (idx >= 0) {
            idx = stack.indexOf("\n", idx + offset);
        }
        if (idx < 0) {
            idx = stack.length();
        }
        out.print(stack.substring(0, idx));
    }

    public static void printErrorMessage(String message, PrintWriter out) {
        out.print(CMConstants.NEW_LINE_SEPERATOR + "ERROR:" + CMConstants.NEW_LINE_SEPERATOR);
        out.print(message);
        out.print(CMConstants.NEW_LINE_SEPERATOR);
    }

    protected static class ConfigObserver
    implements Observer {
        protected ConfigObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            CMIndications.reconfigure();
        }
    }
}

