/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.indications;

import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.util.CMEnvironment;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;

public class CMSessionLogging {
    private static final String SESSION_LOGGING_FILE = "cm-session-log.dat";
    private static final String SESSION_LOG_XML_FILE_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE logs\n[\n\t<!ENTITY data SYSTEM \"cm-session-log.dat\">\n\t<!ELEMENT log ANY>\n\t<!ELEMENT logs (log)*>\n]>\n<logs>\n\t&data;\n</logs>";
    private static SortedSet m_trqUsers = new TreeSet();
    private static SortedSet m_sqlUsers = new TreeSet();
    private static volatile boolean m_trqLogging;
    private static volatile boolean m_sqlLogging;
    private static FileWriter m_fileWriter;
    private static DateFormat m_format;
    private static File logsDir;
    private static PrintStream errorStream;

    public static void reset() {
        logsDir = CMEnvironment.getCRNLogsDir();
        errorStream = System.err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoggingTRQ() {
        if (m_trqLogging) {
            SortedSet sortedSet = m_trqUsers;
            synchronized (sortedSet) {
                CMExecutionContext ctx = CMExecutionContext.get();
                String userSearchPath = ctx.getCurrentUserSearchPath();
                return null == userSearchPath ? false : m_trqUsers.contains(userSearchPath);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoggingSQL() {
        if (m_sqlLogging) {
            SortedSet sortedSet = m_sqlUsers;
            synchronized (sortedSet) {
                CMExecutionContext ctx = CMExecutionContext.get();
                String userSearchPath = ctx.getCurrentUserSearchPath();
                return null == userSearchPath ? false : m_sqlUsers.contains(userSearchPath);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logRequest(String soapAction, String request) {
        if (m_trqLogging) {
            SortedSet sortedSet = m_trqUsers;
            synchronized (sortedSet) {
                CMExecutionContext ctx = CMExecutionContext.get();
                try {
                    String userSearchPath = ctx.getCurrentUserSearchPath();
                    if (null != userSearchPath && m_trqUsers.contains(userSearchPath)) {
                        StringBuffer buffer = new StringBuffer(200);
                        buffer.append("<log type=\"TRQ\"><time value=\"");
                        buffer.append(m_format.format(new Date(System.currentTimeMillis())));
                        buffer.append("\"/><session id=\"");
                        buffer.append(ctx.getAccManPassportID());
                        buffer.append("\"/><thread id=\"");
                        buffer.append(Thread.currentThread().getName());
                        buffer.append("\"/><request soapAction=\"").append(soapAction).append('\"');
                        if (null == request) {
                            buffer.append(" xsi:nil=\"true\"/>");
                        } else {
                            buffer.append('>');
                            if (request.startsWith("<?xml")) {
                                int pos = request.indexOf("?>");
                                if (-1 != pos) {
                                    buffer.append(request.substring(pos + 2));
                                } else {
                                    buffer.append("<!-- ERROR: The response XML is malformed. See the following CDATA section. --><![CDATA[");
                                    buffer.append(request);
                                    buffer.append("]]>");
                                }
                            } else {
                                buffer.append(request);
                            }
                            buffer.append("</request>");
                        }
                        buffer.append("</log>\n");
                        m_fileWriter.write(buffer.toString());
                        m_fileWriter.flush();
                    }
                }
                catch (IOException e) {
                    CMSessionLogging.logException(e, "IOException while writing to the session logging file.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logResponse(String response) {
        if (m_trqLogging) {
            SortedSet sortedSet = m_trqUsers;
            synchronized (sortedSet) {
                CMExecutionContext ctx = CMExecutionContext.get();
                try {
                    String userSearchPath = ctx.getCurrentUserSearchPath();
                    if (null != userSearchPath && m_trqUsers.contains(userSearchPath)) {
                        StringBuffer buffer = new StringBuffer(200);
                        buffer.append("<log type=\"TRQ\"><time value=\"");
                        buffer.append(m_format.format(new Date(System.currentTimeMillis())));
                        buffer.append("\"/><session id=\"");
                        buffer.append(ctx.getAccManPassportID());
                        buffer.append("\"/><thread id=\"");
                        buffer.append(Thread.currentThread().getName());
                        buffer.append("\"/><response");
                        if (null == response) {
                            buffer.append(" xsi:nil=\"true\"/>");
                        } else {
                            buffer.append('>');
                            if (response.startsWith("<?xml ")) {
                                int pos = response.indexOf("?>");
                                if (-1 != pos) {
                                    buffer.append(response.substring(pos + 2));
                                } else {
                                    buffer.append("<!-- ERROR: The response XML is malformed. See the following CDATA section. --><![CDATA[");
                                    buffer.append(response);
                                    buffer.append("]]>");
                                }
                            } else {
                                buffer.append(response);
                            }
                            buffer.append("</response>");
                        }
                        buffer.append("</log>\n");
                        m_fileWriter.write(buffer.toString());
                        m_fileWriter.flush();
                    }
                }
                catch (IOException e) {
                    CMSessionLogging.logException(e, "IOException while writing to the session logging file.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logSQLStart(String sql, String params, String connectionID, String statementID) {
        if (m_sqlLogging) {
            SortedSet sortedSet = m_sqlUsers;
            synchronized (sortedSet) {
                CMExecutionContext ctx = CMExecutionContext.get();
                try {
                    String userSearchPath = ctx.getCurrentUserSearchPath();
                    if (null != userSearchPath && m_sqlUsers.contains(userSearchPath)) {
                        m_fileWriter.write("<log type=\"SQL\"><time value=\"" + m_format.format(new Date(System.currentTimeMillis())) + "\"/><session id=\"" + ctx.getAccManPassportID() + "\"/><SQL><![CDATA[" + (null == sql ? "null" : sql) + "]]></SQL>" + (null != params ? params : "") + "<connection id=\"" + connectionID + "\"/><statement id=\"" + statementID + "\"/><thread id=\"" + Thread.currentThread().getName() + "\"/></log>\n");
                        m_fileWriter.flush();
                    }
                }
                catch (IOException e) {
                    CMSessionLogging.logException(e, "IOException while writing to session logging file.");
                }
            }
        }
    }

    private static void logException(Exception e, String msg) {
        errorStream.println(msg);
        errorStream.println(e.getMessage());
        e.printStackTrace(errorStream);
        errorStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logSQLFinish(long duration, String connectionID, String statementID) {
        if (m_sqlLogging) {
            SortedSet sortedSet = m_sqlUsers;
            synchronized (sortedSet) {
                CMExecutionContext ctx = CMExecutionContext.get();
                try {
                    String userSearchPath = ctx.getCurrentUserSearchPath();
                    if (null != userSearchPath && m_sqlUsers.contains(userSearchPath)) {
                        m_fileWriter.write("<log type=\"SQL\"><time value=\"" + m_format.format(new Date(System.currentTimeMillis())) + "\"/><session id=\"" + ctx.getAccManPassportID() + "\"/><connection id=\"" + connectionID + "\"/><statement id=\"" + statementID + "\"/><duration value=\"" + String.valueOf(duration) + "\"/><thread id=\"" + Thread.currentThread().getName() + "\"/></log>\n");
                        m_fileWriter.flush();
                    }
                }
                catch (IOException e) {
                    CMSessionLogging.logException(e, "IOException while writing to the session logging file.");
                }
            }
        }
    }

    private static synchronized void createLogFiles() {
        if (null == m_fileWriter) {
            try {
                m_fileWriter = new FileWriter(logsDir + "/" + SESSION_LOGGING_FILE, true);
                File xmlFile = new File(logsDir + "/CMSessionLogs.xml");
                if (!xmlFile.exists()) {
                    FileWriter fw = new FileWriter(xmlFile);
                    fw.write(SESSION_LOG_XML_FILE_CONTENT);
                    fw.close();
                }
            }
            catch (IOException e) {
                CMSessionLogging.logException(e, "IOException while creating the Writer for the session logging file.");
            }
        }
    }

    private static synchronized void closeLogFiles() {
        if (null != m_fileWriter) {
            try {
                m_fileWriter.close();
            }
            catch (IOException e) {
                CMSessionLogging.logException(e, "IOException while closing the Writer for the session logging file.");
            }
            m_fileWriter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSOAPUsers() {
        SortedSet sortedSet = m_trqUsers;
        synchronized (sortedSet) {
            return m_trqUsers.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSQLUsers() {
        SortedSet sortedSet = m_sqlUsers;
        synchronized (sortedSet) {
            return m_sqlUsers.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUsers(String[] soapUsers, String[] sqlUsers) {
        int i;
        if (0 < soapUsers.length + sqlUsers.length) {
            CMSessionLogging.createLogFiles();
        }
        SortedSet sortedSet = m_trqUsers;
        synchronized (sortedSet) {
            m_trqUsers.clear();
            for (i = 0; i < soapUsers.length; ++i) {
                m_trqUsers.add(soapUsers[i]);
            }
            m_trqLogging = soapUsers.length > 0;
        }
        sortedSet = m_sqlUsers;
        synchronized (sortedSet) {
            m_sqlUsers.clear();
            for (i = 0; i < sqlUsers.length; ++i) {
                m_sqlUsers.add(sqlUsers[i]);
            }
            m_sqlLogging = sqlUsers.length > 0;
        }
        if (!m_trqLogging && !m_sqlLogging) {
            CMSessionLogging.closeLogFiles();
        }
    }

    public static void setLogsDir(File dir) {
        logsDir = dir;
    }

    public static File getLogsDir() {
        return logsDir;
    }

    public static void setErrorStream(PrintStream stream) {
        errorStream = stream;
    }

    static {
        m_format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        logsDir = CMEnvironment.getCRNLogsDir();
        errorStream = System.err;
    }
}

