/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.indications;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.cmInfo;
import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.diagnostics.DiagnosticsContext;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.indications.LoggingSystem;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.config.ConfigurationException;
import com.cognos.cmutils.xml.XMLUtils;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.PerfTimer;
import com.cognos.pogo.util.NameValuePair;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Level;

public class IPFLoggingSystem
extends LogAuditAccessIndication
implements LoggingSystem {
    private static final long serialVersionUID = 1866121753268316396L;
    static final PerfTimer PERF_IN_IPF = PerfMonitor.getThreadLocalTimer((String)"com.cognos.cm.function.inIPF", (String)"The count and the time spent in IPF", (int)5);
    static final PerfTimer PERF_IN_IPF_OUTSIDE_CM = PerfMonitor.getThreadLocalTimer((String)"com.cognos.cm.function.inIPF.outsideCM", (String)"The count and the time spent in IPF (outside CM)", (int)5);
    static boolean g_bWeStartedIPF_ = false;
    protected boolean gInit_ = false;
    private ConcurrentHashMap<String, LogTypedLogger> _loggerCache = new ConcurrentHashMap();
    protected final int CMIND_NOT_A_LEVEL = -111;

    public IPFLoggingSystem() {
        super("XXX", 0);
    }

    private LogTypedLogger _getLogger(String loggerName, Class<?> loggerClass) {
        String cacheKey = loggerName + loggerClass.getName();
        LogTypedLogger logger = this._loggerCache.get(cacheKey);
        if (logger == null) {
            logger = LogTypedLogger.getInstance((String)loggerName, loggerClass);
            this._loggerCache.put(cacheKey, logger);
        }
        return logger;
    }

    @Override
    public void reconfigure() {
        CMIndicationGlobals.setGlobalBooleans();
    }

    @Override
    public void initialize() throws ConfigurationException {
        boolean bDoIPFStart = ContentManager.startedSelf_;
        if (!this.gInit_) {
            this.gInit_ = true;
            if (bDoIPFStart) {
                g_bWeStartedIPF_ = true;
                try {
                    this.configureLoggingSystem();
                }
                catch (CMException e) {
                    throw new ConfigurationException(e.getFullMessage(), (Throwable)e);
                }
            } else {
                g_bWeStartedIPF_ = false;
            }
            this.SetDefaultLevel("Trace.CM.DBG.SAX", Level.OFF);
            this.SetDefaultLevel("Trace.CM.DBG.TMP", Level.OFF);
            this.SetDefaultLevel("Trace.CM.TCH", Level.OFF);
            this.SetDefaultLevel("Trace.CM.TLM", Level.OFF);
            this.SetDefaultLevel("Trace.CM.stacktrace", Level.OFF);
            this.SetDefaultLevel("Perf.CM.stacktrace", Level.OFF);
            this.SetDefaultLevel("Perf.CM.debug", Level.OFF);
            this.SetDefaultLevel("Trace.CM.MIME", Level.OFF);
            LogTypedLogger logger = this._getLogger("Trace.CM.stacktrace", LogTraceIndication.class);
            if (logger != null && logger.getLevel().toInt() == 10000) {
                System.out.println("CM: Trace.CM.stacktrace is set to 'debug': CM will print Trace.CM.* stacktraces.");
                CMIndications.g_bPrintTraceStacktraces = true;
            }
            if ((logger = this._getLogger("Perf.CM.stacktrace", LogTraceIndication.class)) != null && logger.getLevel() == Level.DEBUG) {
                System.out.println("CM: Perf.CM.stacktrace is set to 'debug': CM will print Perf.CM.* stacktraces.");
            }
            if ((logger = this._getLogger("Perf.CM.debug", LogTraceIndication.class)) != null && logger.getLevel() == Level.DEBUG) {
                System.out.println("CM: Perf.CM.debug is set to 'debug': CM will print perf counters to console.");
            }
            try {
                String sVer = cmInfo.getVersion();
                StringTokenizer tok = new StringTokenizer(sVer, ".");
                tok.nextToken();
                tok.nextToken();
                String sBuildNum = tok.nextToken();
                Long l = new Long(sBuildNum);
                CMIndications.g_nBuildNumber_ = l.intValue();
            }
            catch (Exception e) {
                CMIndications.g_nBuildNumber_ = 0;
            }
            CMIndicationGlobals.setGlobalBooleans();
            LogIPFControl.addConfigObserver((Observer)new ConfigObserver());
        }
    }

    protected void configureLoggingSystem() throws CMException {
        try {
            LogIPFConfigure.serverInit((ICCLConfiguration)ConfigurationFactory.getCCLConfig());
        }
        catch (CCLConfigurationException e) {
            throw new CMException((Exception)((Object)e), "cmIPFConfigFailed");
        }
        if (!LogIPFControl.start()) {
            System.err.println("***** FATAL ERROR *****");
            System.err.println("*** UNABLE TO START Default IPF Client");
            throw new CMException("cmIPFConfigFailed");
        }
        this.Audit_Message("ContentManager service has started the IPF logging facility.");
    }

    @Override
    public boolean isInitialized() {
        return this.gInit_;
    }

    @Override
    public void shutdown() {
        if (g_bWeStartedIPF_) {
            LogIPFControl.stop();
        }
    }

    protected void SetDefaultLevel(String sCatName, Level l) {
        LogTypedLogger log = this._getLogger(sCatName, LogTraceIndication.class);
        if (log != null && log.getLevel() == null) {
            log.setLevel(l);
        }
    }

    public void logThrowable(Throwable ex) {
        this.logException(ex, null);
    }

    public void logException(Throwable ex, String request) {
        this.logException(ex, request, null, null, null);
    }

    @Override
    public void logException(Throwable ex, String request, String sOperation, String sObjectType, String sObjectPath) {
        String sMsgText = null;
        String sMsgCode = "cmCMError";
        if (ex instanceof CMException) {
            CMException cmex = (CMException)ex;
            sMsgText = cmex.getFullMessageSys();
            sMsgCode = cmex.getCode();
        } else {
            String sStackTrace = CMIndications.getStacktraceText_Complete(ex);
            sMsgText = ex.getMessage() + CMConstants.NEW_LINE_SEPERATOR + sStackTrace;
        }
        this.audit_Fmt1(true, "Audit.CM", 50000, sOperation, sObjectType, sObjectPath, "Warning", null, sMsgCode, sMsgText, request, null, null);
    }

    @Override
    public void logData(String xmlData) {
        this.audit(true, "Audit.CM", 50000, null, xmlData, null, null, "Warning", null);
    }

    @Override
    public int getLogLevel(String sCategory) {
        if (this.logEnabled(sCategory, 10000)) {
            return 10000;
        }
        if (this.logEnabled(sCategory, 20000)) {
            return 20000;
        }
        if (this.logEnabled(sCategory, 30000)) {
            return 30000;
        }
        if (this.logEnabled(sCategory, 40000)) {
            return 40000;
        }
        if (this.logEnabled(sCategory, 50000)) {
            return 50000;
        }
        return Integer.MAX_VALUE;
    }

    public boolean logEnabled(String sCategory) {
        return this.logEnabled(sCategory, 10000);
    }

    @Override
    public boolean logEnabled(String sCategory, int nLevel) {
        boolean bRet = false;
        PERF_IN_IPF.start();
        try {
            Class<LogTraceIndication> cls = null;
            if (sCategory.startsWith("Trace")) {
                cls = LogTraceIndication.class;
            } else if (sCategory.startsWith("Perf")) {
                cls = LogPerfIndication.class;
            } else if (sCategory.startsWith("Audit")) {
                cls = LogAuditIndication.class;
            } else {
                throw new Exception("Unrecognized category in CMIndications.logEnabled: " + sCategory);
            }
            LogTypedLogger logger = this._getLogger(sCategory, cls);
            Level lev = null;
            if (logger == null) {
                throw new Exception("*** CM found no logger for category '" + sCategory + "' and class '" + cls.getName() + "'");
            }
            lev = Level.toLevel((int)nLevel);
            bRet = logger.isEnabledFor(lev);
        }
        catch (Exception e) {
            System.out.println("CM Indications threw an exception:" + e.toString() + "\r\n" + "Indications was checking whether log '" + sCategory + "' was enabled.");
            e.printStackTrace(System.out);
        }
        PERF_IN_IPF.stop();
        return bRet;
    }

    public void CMTraceText(String sCategory, int nLevel, String sMsgText) {
        this.traceText(sCategory, nLevel, sMsgText);
    }

    public void CMDebugTrace(String sMsgText) {
        this.traceText("Trace.CM.DBG.GNL", 10000, "DEBUG: " + sMsgText);
    }

    public void CMTempDebugTrace(String sMsgText) {
        this.traceText("Trace.CM.DBG.TMP", 10000, "TEMP: " + sMsgText);
    }

    public void CMTrace(String sMsgCode) {
        this.trace(-111, sMsgCode, null);
    }

    public void CMTrace(String sMsgCode, NameValuePair p1) {
        this.trace(-111, sMsgCode, new NameValuePair[]{p1});
    }

    public void CMTrace(String sMsgCode, NameValuePair p1, NameValuePair p2) {
        this.trace(-111, sMsgCode, new NameValuePair[]{p1, p2});
    }

    public void CMTrace(String sMsgCode, NameValuePair[] listExceptionParms) {
        this.trace(-111, sMsgCode, listExceptionParms);
    }

    @Override
    public boolean CMMessageEnabled(String sMsgCode) {
        boolean bRet = false;
        PERF_IN_IPF.start();
        try {
            String sMsgText = CMError.getMessage(sMsgCode, null, null);
            String sMsgSect = sMsgText.substring(3, 6);
            String sCategoryPrefix = "Trace.CM.";
            String sCategory = sCategoryPrefix + sMsgSect;
            Class<LogTraceIndication> cls = LogTraceIndication.class;
            int nMsgLevel = this._getLevel(sMsgText);
            LogTypedLogger logTypedLogger = this._getLogger(sCategory, LogTraceIndication.class);
            if (logTypedLogger == null) {
                throw new Exception("*** CM found no logger for category '" + sCategory + "' and class '" + cls.getName() + "'");
            }
            bRet = logTypedLogger.isEnabledFor(Level.toLevel((int)nMsgLevel));
        }
        catch (Exception e) {
            System.out.println("CM Indications threw an exception:" + e.toString() + "\r\n" + "Indications was trying to check whether message '" + sMsgCode + "' was enabled.");
            e.printStackTrace(System.out);
        }
        PERF_IN_IPF.stop();
        return bRet;
    }

    protected String _getMsgSect(String sMsgText) throws Exception {
        if (sMsgText.length() < 11 || sMsgText.charAt(2) != '-' || sMsgText.charAt(6) != '-') {
            throw new Exception("CMIndications: unexpected request for msg sect from '" + sMsgText + "'");
        }
        return sMsgText.substring(3, 6);
    }

    protected int _getLevel(String sMsgText) throws Exception {
        int nMsgLevel = -111;
        String sMsgLevel = sMsgText.substring(7, 8);
        if (sMsgLevel.equals("5")) {
            nMsgLevel = 50000;
        } else if (sMsgLevel.equals("4")) {
            nMsgLevel = 40000;
        } else if (sMsgLevel.equals("3")) {
            nMsgLevel = 30000;
        } else if (sMsgLevel.equals("2")) {
            nMsgLevel = 20000;
        } else if (sMsgLevel.equals("1")) {
            nMsgLevel = 10000;
        } else {
            throw new Exception("CM: improperly formatted error message: '" + sMsgText + "'");
        }
        if (nMsgLevel == -111) {
            nMsgLevel = 50000;
        }
        return nMsgLevel;
    }

    @Override
    public void trace(int nLevel, String sMsgCode, NameValuePair[] listExceptionParms) {
        this._CMTrace(nLevel, sMsgCode, listExceptionParms, false);
    }

    protected void _CMTrace(int nLevel, String sMsgCode, NameValuePair[] listExceptionParms, boolean bInsideCMIndication) {
        if (sMsgCode == null) {
            // empty if block
        }
        String sMsgText = CMError.getMessage(sMsgCode, listExceptionParms, null);
        this._CMTraceText(null, nLevel, sMsgText, bInsideCMIndication);
    }

    @Override
    public void traceText(String sCategory, int nLevel, String sMsgText) {
        this._CMTraceText(sCategory, nLevel, sMsgText, false);
    }

    protected void _CMTraceText(String sCategoryP, int nLevel, String sMsgText, boolean bInsideCMIndication) {
        if (!this.isInitialized()) {
            return;
        }
        PERF_IN_IPF.start();
        String sCategory = sCategoryP;
        String sCategoryPrefix = null;
        try {
            String sMsgID = null;
            String sMsgSect = null;
            int nMsgLevel = nLevel;
            LogTraceIndication ind = null;
            LogTypedLogger logTypedLogger = null;
            boolean bSendToAuditLog = false;
            boolean bSendToTraceLog = true;
            DiagnosticsContext diagnosticsCtx = DiagnosticsContext.get();
            String sRequester = diagnosticsCtx.get(DiagnosticsContext.Param.REQUESTER);
            if (sCategory == null) {
                if (sMsgText.length() >= 11) {
                    sMsgID = sMsgText.substring(0, 11);
                }
                sMsgSect = this._getMsgSect(sMsgID);
                if (nMsgLevel == -111) {
                    nMsgLevel = this._getLevel(sMsgID);
                }
                sCategoryPrefix = "Trace.CM.";
                if ((sMsgSect.equals("SYS") || sMsgSect.equals("CFG") || sMsgSect.equals("DEP")) && (nMsgLevel == 50000 || nMsgLevel == 40000)) {
                    bSendToAuditLog = true;
                    if (nMsgLevel == 50000) {
                        bSendToTraceLog = false;
                    }
                }
                sCategory = sCategoryPrefix + sMsgSect;
                String sCallerCompID = diagnosticsCtx.get(DiagnosticsContext.Param.COMPONENT);
                if (sMsgSect.equals("TRQ") && sCallerCompID != null) {
                    sCategory = sCategory + "." + sCallerCompID;
                }
            }
            if (bSendToTraceLog) {
                Class<LogTraceIndication> indClass = LogTraceIndication.class;
                logTypedLogger = this._getLogger(sCategory, indClass);
                if (logTypedLogger == null) {
                    throw new Exception("*** CM found no logger for category '" + sCategory + "' and class '" + indClass.getName() + "'");
                }
                if (logTypedLogger.isEnabled(nMsgLevel)) {
                    String sSTCat;
                    LogTypedLogger stackTraceLogger;
                    String sCompID = "CM";
                    ind = new LogTraceIndication(sCompID, CMIndications.g_nBuildNumber_);
                    ind.setLevel(nMsgLevel);
                    ind.setRequester(sRequester);
                    if (CMExecutionContext.hasContext()) {
                        CMExecutionContext ctx = CMExecutionContext.get();
                        String sSessionID = ctx.getSessionContext();
                        if (sSessionID != null && sSessionID.equals("")) {
                            sSessionID = ctx.getServiceId();
                        }
                        if (sSessionID != null) {
                            ind.setSessionID(sSessionID.trim());
                        }
                        ind.setRequestID(ctx.getRequestContext().trim());
                        ind.setStepID(ctx.getStepContext());
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("<trace>");
                    sb.append(sMsgText);
                    boolean bPrintStacktrace = CMIndications.g_bPrintTraceStacktraces;
                    if (!bPrintStacktrace && (stackTraceLogger = this._getLogger(sSTCat = sCategory + ".stacktrace", indClass)) != null && stackTraceLogger.getLevel() != null && stackTraceLogger.isEnabled(10000)) {
                        bPrintStacktrace = true;
                    }
                    if (bPrintStacktrace) {
                        IPFLoggingSystem.appendStacktraceToSB(sb);
                    }
                    sb.append("</trace>");
                    ind.setMessage(sb.toString());
                    if (CMExecutionContext.hasContext()) {
                        ind.setObject(CMExecutionContext.get().getIPFObjectPath());
                    }
                    if (ind.getObject() == null) {
                        ind.setObject("CM_Processing");
                    }
                    ind.setAction((byte)11);
                    this._logToIPF(logTypedLogger, (LogIndication)ind, bInsideCMIndication);
                }
            }
            if (bSendToAuditLog && nMsgLevel >= 40000) {
                PERF_IN_IPF.stop();
                this.audit_Fmt1(true, "Audit.CM", nMsgLevel, null, null, null, null, null, null, sMsgText, null, sRequester, null);
                PERF_IN_IPF.start();
            }
        }
        catch (Throwable th) {
            System.out.println("*** CM Indications threw an exception: '" + th.toString() + "\r\n" + "***    writing message '" + sMsgText + "'" + "\r\n" + "***    to category '" + sCategory + "'");
            th.printStackTrace(System.out);
        }
        PERF_IN_IPF.stop();
    }

    public static void appendStacktraceToSB(StringBuffer sb) {
        sb.append("<stacktrace>");
        String sStackTrace = IPFLoggingSystem.getStacktraceText_Trimmed();
        sStackTrace = XMLUtils.escape((String)sStackTrace);
        sb.append(sStackTrace);
        sb.append("</stacktrace>");
    }

    public static String getStacktraceText_Trimmed() {
        Exception ex = new Exception();
        ex.fillInStackTrace();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        PrintStream ps = new PrintStream(baos);
        ex.printStackTrace(ps);
        String s = baos.toString();
        s = IPFLoggingSystem.trimStacktrace(s);
        return s;
    }

    public static String trimStacktrace(String s) {
        String sTag = "CMIndications.java";
        int i = s.lastIndexOf(sTag);
        if (i > -1) {
            s = s.substring(i + sTag.length());
        }
        if ((i = s.indexOf("at")) > -1) {
            s = s.substring(i);
        }
        s = IPFLoggingSystem.trimStacktraceStart(s, "com.cognos.cm.store.CMCacheImpl.Log(");
        s = IPFLoggingSystem.trimStacktraceStart(s, "com.cognos.cm.indications.CMStatementProxy.logExecute(");
        s = IPFLoggingSystem.trimStacktraceStart(s, "$Proxy");
        s = IPFLoggingSystem.trimStacktraceStart(s, "com.cognos.cm.indications.CMPerfIndications");
        s = IPFLoggingSystem.trimStacktraceStart(s, "com.cognos.cm.indications.CMPerfIndications");
        s = IPFLoggingSystem.trimStacktraceEnd(s, "org.apache.catalina");
        String sRet = s = IPFLoggingSystem.trimStacktraceEnd(s, "javax.servlet");
        return sRet;
    }

    protected static String trimStacktraceStart(String sStack, String sToTrim) {
        String s = sStack;
        int i = s.indexOf(sToTrim);
        if (i > -1 && (i = s.indexOf(")", i)) > -1) {
            s = s.substring(i + 1);
        }
        return s;
    }

    protected static String trimStacktraceEnd(String sStack, String sToTrim) {
        String s = sStack;
        int i = s.indexOf(sToTrim);
        if (i > 6) {
            s = s.substring(0, i - 5);
        }
        return s;
    }

    protected static String getStacktraceTopMethod(String sStacktrace) {
        int nIdx_Start;
        String sRet = null;
        if (sStacktrace != null && (nIdx_Start = sStacktrace.indexOf("at ")) > -1) {
            int nIdx_End;
            if (sStacktrace.charAt(3) == ' ') {
                ++nIdx_Start;
            }
            if ((nIdx_End = sStacktrace.indexOf("(", nIdx_Start)) > -1) {
                sRet = sStacktrace.substring(nIdx_Start + 3, nIdx_End);
            }
        }
        return sRet;
    }

    public static String getStacktraceText_Complete() {
        Exception ex = new Exception();
        return IPFLoggingSystem.getStacktraceText_Complete(ex);
    }

    public static String getStacktraceText_Complete(Throwable t) {
        String s = null;
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
            PrintStream ps = new PrintStream(baos);
            t.printStackTrace(ps);
            s = baos.toString();
        }
        return s;
    }

    @Override
    public void audit_Message_FreeFormText(String sMsgCode, NameValuePair[] listParms, int level, String sCategory, String sObjType, String sObjPath, String sStatus, String[] sErrors) {
        if (sMsgCode == null) {
            return;
        }
        String sMsgText = CMError.getMessage(sMsgCode, listParms, null);
        this.audit(true, "Audit.CM", level, sCategory, sMsgText, sObjType, sObjPath, sStatus, sErrors);
    }

    public void Audit_Message(String sMsgText) {
        this.audit_Fmt1(true, "Audit.CM", 50000, null, null, null, null, null, null, sMsgText, null, null, null);
    }

    public void Audit_Request(String sReq) {
        this.audit_Fmt4(null, "Request", sReq, null, null, null, null);
    }

    public void Audit_Response(String sResp) {
        this.audit_Fmt4(null, "Response", sResp, null, null, null, null);
    }

    public void Audit_Info(String sMsgCode, NameValuePair[] listParms, String sCategory) {
        if (sMsgCode == null) {
            return;
        }
        String sMsgText = CMError.getMessage(sMsgCode, listParms, null);
        this.audit(true, "Audit.CM", 20000, sCategory, sMsgText, "ContentManagerService", "", "Info", null);
    }

    public void Audit_Warning(String sMsgCode, NameValuePair[] listParms, String sCategory) {
        if (sMsgCode == null) {
            return;
        }
        String sMsgText = CMError.getMessage(sMsgCode, listParms, null);
        this.audit(true, "Audit.CM", 30000, sCategory, sMsgText, "ContentManagerService", "", "Warning", null);
    }

    @Override
    public void audit_Fmt1(boolean bAuditAccess, String sCategory, int nLevel, String sOperation, String sObjectType, String sObjectPath, String sStatus, String[] vErrorMessages, String sMsgCode, String sMsgText, String sRequest, String sRequester, NameValuePair[] listExceptionParms) {
        PERF_IN_IPF.start();
        if (sMsgCode != null && sMsgText == null) {
            sMsgText = CMError.getMessage(sMsgCode, listExceptionParms, null);
        }
        if (sRequester == null) {
            sRequester = DiagnosticsContext.get().get(DiagnosticsContext.Param.REQUESTER);
        }
        StringBuffer sbLogDataXML = new StringBuffer();
        if (sMsgCode != null || sMsgText != null || listExceptionParms != null && listExceptionParms.length > 0) {
            String sTrimmedStackTrace;
            String sTopMethod;
            sbLogDataXML.append("<parameters>");
            if (sMsgCode != null) {
                sbLogDataXML.append("<item name=\"msgCode\"><![CDATA[");
                sbLogDataXML.append(sMsgCode);
                sbLogDataXML.append("]]></item>");
            }
            if (sMsgText != null) {
                sbLogDataXML.append("<item name=\"msgText\"><![CDATA[");
                sbLogDataXML.append(sMsgText);
                sbLogDataXML.append("]]></item>");
            }
            if (sRequest != null) {
                sbLogDataXML.append("<item name=\"request\"><![CDATA[");
                sbLogDataXML.append(sRequest);
                sbLogDataXML.append("]]></item>");
            }
            if (sRequester != null) {
                sbLogDataXML.append("<item name=\"requester\"><![CDATA[");
                sbLogDataXML.append(sRequester);
                sbLogDataXML.append("]]></item>");
            }
            if ((sTopMethod = CMIndications.getStacktraceTopMethod(sTrimmedStackTrace = CMIndications.trimStacktrace(CMIndications.getStacktraceText_Complete()))) != null) {
                sbLogDataXML.append("<item name=\"msgLocation\"><![CDATA[");
                sbLogDataXML.append(sTopMethod);
                sbLogDataXML.append("]]></item>");
            }
            this._writeParmsToSB(listExceptionParms, sbLogDataXML);
            if (nLevel == 30000 && CMExecutionContext.hasContext()) {
                CMExecutionContext ctx = CMExecutionContext.get();
                ArrayList<CMException.Parm> vAL = ctx.getLevel3Parms();
                this._writeParmsToSB(vAL, sbLogDataXML);
            }
            sbLogDataXML.append("</parameters>");
        }
        this.audit(bAuditAccess, sCategory, nLevel, sOperation, sbLogDataXML.toString(), sObjectType, sObjectPath, sStatus, vErrorMessages);
        PERF_IN_IPF.stop();
    }

    @Override
    public void audit_Fmt4(String sCategory, String sOperation, String sMessageBody, String sObjectType, String sObjectPath, String sStatus, String[] vErrorMessages) {
        PERF_IN_IPF.start();
        sMessageBody = CMXMLUtils.removeXMLTag(sMessageBody);
        StringBuffer sbLogDataXML = new StringBuffer();
        sbLogDataXML.append(sOperation.equals("Request") ? "<request>" : "<response>");
        sbLogDataXML.append(sMessageBody);
        sbLogDataXML.append(sOperation.equals("Request") ? "</request>" : "</response>");
        this.audit(false, sCategory, 20000, sOperation, sbLogDataXML.toString(), sObjectType, sObjectPath, sStatus, vErrorMessages);
        PERF_IN_IPF.stop();
    }

    protected void _writeParmsToSB(NameValuePair[] listExceptionParms, StringBuffer sb) {
        if (listExceptionParms != null && listExceptionParms.length > 0) {
            int nIdx = 0;
            for (nIdx = 0; nIdx < listExceptionParms.length; ++nIdx) {
                NameValuePair parm = listExceptionParms[nIdx];
                String sKey = parm.getName();
                String sValue = parm.getValue();
                this._writeParmToSB(sKey, sValue, sb);
            }
        }
    }

    protected void _writeParmsToSB(ArrayList<CMException.Parm> arrayExceptionParms, StringBuffer sb) {
        if (arrayExceptionParms != null && arrayExceptionParms.size() > 0) {
            int nIdx = 0;
            for (nIdx = 0; nIdx < arrayExceptionParms.size(); ++nIdx) {
                CMException.Parm obj = arrayExceptionParms.get(nIdx);
                if (!(obj instanceof NameValuePair)) continue;
                NameValuePair parm = obj;
                String sKey = parm.getName();
                String sValue = parm.getValue();
                this._writeParmToSB(sKey, sValue, sb);
            }
        }
    }

    protected void _writeParmToSB(String sKey, String sValue, StringBuffer sb) {
        sb.append("<item name=\"");
        sb.append(sKey);
        sb.append("\"><![CDATA[");
        sb.append(sValue);
        sb.append("]]></item>");
    }

    void _writeMsgsToSB(String[] listMessages, StringBuffer sb) {
        if (listMessages != null && listMessages.length > 0) {
            int nIdx = 0;
            for (nIdx = 0; nIdx < listMessages.length; ++nIdx) {
                String sMsg = listMessages[nIdx];
                sb.append("<message>");
                sb.append(sMsg);
                sb.append("</message>");
            }
        }
    }

    void _writeMsgsToSB(ArrayList<String> vMsgs, StringBuffer sb) {
        if (vMsgs != null && vMsgs.size() > 0) {
            int nIdx = 0;
            for (nIdx = 0; nIdx < vMsgs.size(); ++nIdx) {
                String obj = vMsgs.get(nIdx);
                if (!(obj instanceof String)) continue;
                String sMsg = obj;
                sb.append("<message>");
                sb.append(sMsg);
                sb.append("</message>");
            }
        }
    }

    void _logToIPF(LogTypedLogger logger, LogIndication indication) {
        this._logToIPF(logger, indication, false);
    }

    private void _logToIPF(LogTypedLogger logger, LogIndication indication, boolean bInsideCMIndication) {
        if (!bInsideCMIndication) {
            PERF_IN_IPF_OUTSIDE_CM.start();
        }
        logger.log((Object)indication);
        if (!bInsideCMIndication) {
            PERF_IN_IPF_OUTSIDE_CM.stop();
        }
    }

    public void _DEBUG_ReportInactiveCategory(LogTypedLogger tl, int nLevel) {
        System.out.println("CM Indication on inactive category " + tl.getName() + " Level=" + nLevel);
        System.out.println(" STACKTRACE: " + IPFLoggingSystem.getStacktraceText_Complete());
    }

    @Override
    public void log(Throwable ex) {
        this.log(ex, "Audit.CM", 50000, null, null, null, "Warning", false);
    }

    @Override
    public void log(Throwable ex, String sCategory, int nLevel, String sOperation, String sObjectType, String sObjectPath, String sStatus, boolean putErrorDetails) {
        String sMsgText = null;
        int ErrorLevel = nLevel;
        String[] vErrorMessages = null;
        if (ex instanceof CMException) {
            CMException cmex = (CMException)ex;
            sMsgText = cmex.getFullMessageSys();
            ErrorLevel = cmex.ErrorLevel;
            if (putErrorDetails) {
                vErrorMessages = new String[]{cmex.getFullMessageSys(false)};
            }
        } else {
            String sStackTrace = CMIndications.getStacktraceText_Complete(ex);
            sMsgText = ex.getMessage() + CMConstants.NEW_LINE_SEPERATOR + sStackTrace;
            if (putErrorDetails) {
                vErrorMessages = new String[]{ex.getMessage()};
            }
        }
        this.audit(true, sCategory, ErrorLevel, sOperation, sMsgText, sObjectType, sObjectPath, sStatus, vErrorMessages);
    }

    @Override
    public void audit(boolean bAuditAccess, String sCategory, int nLevel, String sOperation, String sLogDataXML, String sObjectType, String sObjectPath, String sStatus, String[] vErrorMessages) {
        if (!this.isInitialized()) {
            System.err.println("[com.cognos.cm.indications.CMIndications._Audit]: Not initialized. Cannot log audit message: " + sCategory + " " + sLogDataXML);
            return;
        }
        try {
            if (CMExecutionContext.hasContext()) {
                CMExecutionContext ctx = CMExecutionContext.get();
                sCategory = ctx.getIPFCategory();
            }
            if (sCategory == null) {
                sCategory = CMIndications.g_sDefaultIPFCategory;
            }
            if (sCategory == null) {
                throw new Exception("CM indications.  No category set");
            }
            if (sOperation != null && (sOperation.equals("Request") || sOperation.equals("Response"))) {
                sCategory = sCategory + ".Request";
            }
            Object ind = null;
            String sCompID = "CM";
            ind = bAuditAccess ? new LogAuditAccessIndication(sCompID, CMIndications.g_nBuildNumber_) : new LogAuditIndication(sCompID, CMIndications.g_nBuildNumber_);
            LogTypedLogger logger = this._getLogger(sCategory, ind.getClass());
            if (logger == null) {
                throw new Exception("CM indications.  Could not load logger for category '" + sCategory + "'" + " and class '" + ind.getClass().getName() + "'");
            }
            if (logger.isEnabled(nLevel)) {
                CMExecutionContext ctx;
                boolean hasContext = CMExecutionContext.hasContext();
                if (hasContext) {
                    ctx = CMExecutionContext.get();
                    if (sOperation == null) {
                        sOperation = ctx.getIPFOperation();
                    }
                    if (sObjectType == null) {
                        sObjectType = ctx.getIPFObjectType();
                    }
                    if (sObjectPath == null) {
                        sObjectPath = ctx.getIPFObjectPath();
                    }
                }
                if (sOperation == null) {
                    sOperation = CMIndications.g_sDefaultIPFOperation;
                }
                if (hasContext) {
                    String requestId;
                    ctx = CMExecutionContext.get();
                    String sSessionID = ctx.getSessionContext();
                    if (sSessionID != null && sSessionID.equals("")) {
                        sSessionID = ctx.getServiceId();
                    }
                    if (sSessionID != null) {
                        ind.setSessionID(sSessionID.trim());
                    }
                    if ((requestId = ctx.getRequestContext().trim()).length() == 0) {
                        requestId = " ";
                    }
                    ind.setRequestID(requestId);
                    ind.setStepID(ctx.getStepContext());
                    long ctxTimestamp = ctx.getIPFTimestamp();
                    if (ctxTimestamp != 0L) {
                        ind.setTime(ctx.getIPFTimestamp());
                    }
                }
                ind.setLevel(nLevel);
                ind.setOperation(sOperation);
                ind.setLogData(sLogDataXML);
                if (bAuditAccess) {
                    LogAuditAccessIndication accind = ind;
                    accind.setObjectPath(sObjectPath);
                    accind.setObjectType(sObjectType);
                    accind.setStatus(sStatus == null ? STATUS_SUCCESS : sStatus);
                    StringBuffer sb = new StringBuffer();
                    ArrayList<String> vMsgs = null;
                    if (hasContext && accind.getLevel() == 30000) {
                        CMExecutionContext ctx2 = CMExecutionContext.get();
                        vMsgs = ctx2.getLevel3Messages();
                    }
                    if (vErrorMessages != null && vErrorMessages.length > 0 || vMsgs != null && vMsgs.size() > 0) {
                        sb.append("<messages>");
                        this._writeMsgsToSB(vErrorMessages, sb);
                        if (vMsgs != null) {
                            this._writeMsgsToSB(vMsgs, sb);
                        }
                        sb.append("</messages>");
                    }
                    accind.setErrorMessage(sb.toString());
                }
                if (hasContext) {
                    ctx = CMExecutionContext.get();
                    ctx.setAuditIndicationSentForLevel(ind.getLevel(), true);
                }
                this._logToIPF(logger, (LogIndication)ind);
            }
        }
        catch (Throwable ex) {
            System.out.println("*** CM indications threw an exception: '" + ex.toString() + "\r\n" + "***    while logging message: '" + sLogDataXML + "'\r\n" + "***    to category: '" + sCategory + "'");
            ex.printStackTrace(System.out);
        }
    }

    protected class ConfigObserver
    implements Observer {
        protected ConfigObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            IPFLoggingSystem.this.reconfigure();
        }
    }
}

