/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.locking;

import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.locking.CMLockHandlerDenied;
import com.cognos.cm.locking.CMLockManager;
import com.cognos.cm.locking.CMLockManagerContext;
import com.cognos.cm.locking.ILockHandler;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMPerfAlarm;

public abstract class AbstractLockHandler
implements ILockHandler {
    @Override
    public abstract int LMInitialize(boolean var1) throws CMLockHandlerDenied, CMCacheException;

    @Override
    public abstract int LMAllocateHandle() throws CMLockHandlerDenied, CMCacheException;

    @Override
    public abstract void LMReleaseAllLocks(int var1) throws CMLockHandlerDenied, CMCacheException;

    @Override
    public abstract void LMReleaseHandle(int var1) throws CMLockHandlerDenied, CMCacheException;

    @Override
    public abstract void LMFinishedProtectedMutex(int var1) throws CMLockHandlerDenied, CMCacheException;

    @Override
    public abstract boolean LMHasExclusiveLocks(int var1) throws CMCacheException;

    @Override
    public abstract int LMAcquireLocks(String var1, int var2, int var3) throws CMLockHandlerDenied, CMCacheException;

    @Override
    public abstract int LMAcquireLocks(int[] var1, int var2, int var3) throws CMLockHandlerDenied, CMCacheException;

    @Override
    public abstract int LMAcquireLocks(Iterable<CacheEntry> var1, int var2, int var3) throws CMLockHandlerDenied, CMCacheException;

    @Override
    public abstract CMCacheQueryInstance getCacheQueryInstance(int var1);

    @Override
    public CMCacheQueryInstance acquireLocks(CMLockManagerContext ctx, ICMStorePath query2, int lockType, int iHandle) throws CMLockHandlerDenied, CMCacheException, CMException {
        long nOpStart = CMPerfAlarm.getSystemTicks();
        ctx.setCurrentLockType(lockType);
        String sCacheQueryPath = query2.getCacheQueryPath();
        int queryHandle = this.LMAcquireLocks(sCacheQueryPath, lockType, iHandle);
        query2.setLocksHaveBeenObtained();
        ctx.setHasAcquiredLocks(true, ctx.isCurrentLockTypeExclusive());
        CMCacheQueryInstance ret = this.getCacheQueryInstance(queryHandle);
        long threshold = AdvancedSettings.CMLOCKHANDLER_PERFALARM_THRESHOLD;
        if (threshold > 0L) {
            CMPerfAlarm.alarmTicksNow1Arg(nOpStart, threshold, "CMLockHandler", "acquireLocks", query2);
        }
        return ret;
    }

    @Override
    public boolean acquireLocks(CMLockManagerContext ctx, int[] object_ids, int lockType, int iHandle) throws CMLockHandlerDenied, CMCacheException, CMException {
        long nOpStart = CMPerfAlarm.getSystemTicks();
        ctx.setCurrentLockType(lockType);
        this.LMAcquireLocks(object_ids, lockType, iHandle);
        ctx.setHasAcquiredLocks(true, ctx.isCurrentLockTypeExclusive());
        long threshold = AdvancedSettings.CMLOCKHANDLER_PERFALARM_THRESHOLD;
        if (threshold > 0L) {
            CMPerfAlarm.alarmTicksNow1Arg(nOpStart, threshold, "CMLockHandler", "acquireLocks", "int[]");
        }
        return true;
    }

    @Override
    public boolean acquireLocks(CMLockManagerContext ctx, Iterable<CacheEntry> entries, int lockType, int iHandle) throws CMLockHandlerDenied, CMCacheException, CMException {
        long nOpStart = CMPerfAlarm.getSystemTicks();
        ctx.setCurrentLockType(lockType);
        this.LMAcquireLocks(entries, lockType, iHandle);
        ctx.setHasAcquiredLocks(true, ctx.isCurrentLockTypeExclusive());
        long threshold = AdvancedSettings.CMLOCKHANDLER_PERFALARM_THRESHOLD;
        if (threshold > 0L) {
            CMPerfAlarm.alarmTicksNow1Arg(nOpStart, threshold, "CMLockHandler", "acquireLocks", "Iterable<CacheEntry>");
        }
        return true;
    }

    @Override
    public int getCurrentHandle() throws CMException {
        return CMLockManager.getCurrentLockHandlerHandle();
    }
}

