/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.locking;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.AnalyzedLockInfo;
import com.cognos.cm.locking.CMLockManager;
import com.cognos.cm.locking.CMLockManagerLog;
import com.cognos.cm.locking.ILockHandler;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.UserSessionCacheEntry;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePredicateElement;
import com.cognos.cm.store.path.CMStorePredicateInteger;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.cognos.cmutils.xml.XMLUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CMLockAnalysis {
    private static final int CMID_ROOT = 0;
    private ArrayList<AnalyzedLockInfo> infos_ = new ArrayList();
    private boolean bLockStore_;
    private int netLockUsage_ = 16;

    private void appendNameValueEncoded(CMIndentedPrintStream out, String name, String value) {
        out.print("<" + name + ">");
        out.print(XMLUtils.escape((String)value));
        out.println("</" + name + ">");
    }

    public void outputStateXML(CMIndentedPrintStream out) {
        if (this.infos_.size() == 0) {
            out.println("<analysis/>");
            return;
        }
        out.println("<analysis>");
        out.indent();
        for (AnalyzedLockInfo entry : this.infos_) {
            out.println("<entry>");
            out.indent();
            if (entry != null) {
                int[] objectsToLock;
                out.println("<analysisInfo>");
                out.indent();
                if (entry.path != null) {
                    this.appendNameValueEncoded(out, "path", entry.path.getOriginalPath());
                }
                if (entry.lockMode == 0) {
                    this.appendNameValueEncoded(out, "type", "LOCK_QUERY_PATH");
                } else if (entry.lockMode == 2) {
                    this.appendNameValueEncoded(out, "type", "LOCK_ALTERNATE_PATH");
                } else if (entry.lockMode == 3) {
                    this.appendNameValueEncoded(out, "type", "LOCK_OBJECTS_BY_ID");
                } else if (entry.lockMode == 1) {
                    this.appendNameValueEncoded(out, "type", "LOCK_STORE");
                } else if (entry.lockMode == 4) {
                    this.appendNameValueEncoded(out, "type", "LOCK_DEFERRED");
                } else if (entry.lockMode == 5) {
                    this.appendNameValueEncoded(out, "type", "LOCK_PROXY_PATH");
                } else {
                    this.appendNameValueEncoded(out, "type", "UNKNOWN");
                }
                this.appendNameValueEncoded(out, "lockManagerUsage", CMLockManager.LockHandlerTypeStringFromPathUsage(entry.lockManagerUsage));
                if (entry.ifNotExistLockPath != null) {
                    this.appendNameValueEncoded(out, "ifNotExistPath", entry.ifNotExistLockPath.toString());
                }
                if (entry.lockMode == 3 && (objectsToLock = entry.objectsToLock) != null) {
                    for (int j = 0; j < objectsToLock.length; ++j) {
                        out.println("<objectID id=\"" + objectsToLock[j] + "\"/>");
                    }
                }
                if (entry.lockMode == 1) {
                    out.println("<lockStore/>");
                }
                out.unindent();
                out.println("</analysisInfo>");
            }
            out.unindent();
            out.println("</entry>");
        }
        out.unindent();
        out.println("</analysis>\n");
    }

    public CMLockAnalysis(List<ICMStorePath> searchPaths) throws CMException {
        int count = searchPaths.size();
        if (AdvancedSettings.MAXPATHLOCK <= 0 || count <= AdvancedSettings.MAXPATHLOCK) {
            String previousPath = null;
            for (ICMStorePath path : searchPaths) {
                if (path.getLocksHaveBeenObtained() || previousPath != null && path.getOriginalPath().startsWith(previousPath)) continue;
                this.analyzeQueryForLocks(path);
                int usage = path.getLockManagerUsageFlag();
                if (this.bLockStore_) {
                    this.netLockUsage_ = CMLockAnalysis.parentUsageFromUsage(usage);
                    break;
                }
                if (CMLockManager.LockHandlerTypeFromPathUsage(usage) == 0) continue;
                previousPath = path.getOriginalPath();
            }
        } else {
            this.bLockStore_ = true;
        }
    }

    public AnalyzedLockInfo[] getAnalysisInfo() {
        AnalyzedLockInfo[] result = new AnalyzedLockInfo[this.infos_.size()];
        return this.infos_.toArray(result);
    }

    public boolean lockEntireStore() {
        return this.bLockStore_;
    }

    public int netLockUsage() {
        return this.netLockUsage_;
    }

    private void analyzeObjectIDs(AnalyzedLockInfo info, int[] objIDs) {
        info.objectsToLock = new int[objIDs.length];
        System.arraycopy(objIDs, 0, info.objectsToLock, 0, objIDs.length);
        info.lockMode = 3;
    }

    private void analyzeQueryForLocks(ICMStorePath path) throws CMStoreParseException {
        CMExecutionContext execCtx = CMExecutionContext.get();
        AnalyzedLockInfo info = new AnalyzedLockInfo();
        info.lockMode = 0;
        info.lockManagerUsage = path.getLockManagerUsageFlag();
        path.ResolveCurrentUserSteps(true);
        int numSteps = path.size();
        CMStorePathStep firstStep = numSteps > 0 ? path.stepAt(0) : null;
        CMStorePathPredicateFunction function = CMLockAnalysis.getNodesetFunction(path);
        String sOriginalSearchPath = path.getOriginalPath();
        if (numSteps == 0) {
            info.objectsToLock = new int[]{0};
            info.lockMode = 3;
        } else if ((sOriginalSearchPath.startsWith("~/") || sOriginalSearchPath.equals("~")) && (firstStep == null || firstStep.bCurrentUser_)) {
            try {
                String userPath = execCtx.getCurrentUserInternalPath();
                info.path = CMStoreXPath.parse(userPath);
                if (!sOriginalSearchPath.equals("~")) {
                    info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(info.lockManagerUsage);
                }
            }
            catch (Throwable e) {
                CMIndications.logException(e);
                this.lockAccountAsLastResort(info, execCtx);
            }
        } else if (sOriginalSearchPath.startsWith("~~")) {
            info.path = path;
            try {
                execCtx = CMExecutionContext.get();
                String userPath = execCtx.getCurrentUserInternalPath();
                if (CMLockManager.LockHandlerTypeFromPathUsage(info.lockManagerUsage) != 0) {
                    info.ifNotExistLockPath = CMStoreXPath.parse(userPath);
                }
            }
            catch (Throwable e) {
                CMIndications.logException(e);
                this.lockAccountAsLastResort(info, execCtx);
            }
        } else if (function != null) {
            int funcID = function.function_.getID();
            if (funcID == 23) {
                this.analyzeURLID(path, info);
            } else if (funcID == 19 || funcID == 32 || funcID == 36) {
                info.path = function.getPathArgument(0);
                if (info.path == null) {
                    info.path = CMLockManager.getCognosNSPath();
                }
                info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(info.lockManagerUsage);
            } else if (funcID == 16) {
                info.path = CMLockManager.getCognosNSPath();
                info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(info.lockManagerUsage);
            } else if (funcID == 21) {
                info.path = function.getPathArgument(0);
                info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(info.lockManagerUsage);
            } else if (funcID == 15) {
                this.analyzeCAMID(path, info);
            } else if (funcID == 28) {
                if (numSteps == 1) {
                    info.path = path;
                } else {
                    this.analyzeDescendants(path, 1, info);
                }
            } else if (funcID == 30) {
                CMStorePath argPath = function.getPathArgument(0);
                this.analyzeQueryForLocks(argPath);
                info = null;
            } else if (funcID == 17) {
                this.analyzeExpandMembers(function.getPathArgument(0), path.getLockManagerUsageFlag());
                info = null;
            } else if (funcID == 29) {
                UserSessionCacheEntry userSessionEntry = execCtx.getContext().getCurrentUserSession();
                List<Integer> identityObjects = userSessionEntry.getIdentityAccounts();
                int[] accountIDs = new int[identityObjects.size()];
                for (int i = 0; i < identityObjects.size(); ++i) {
                    accountIDs[i] = identityObjects.get(i);
                }
                this.analyzeObjectIDs(info, accountIDs);
            } else if (funcID == 35) {
                CMStorePathFunctionArgument arg = (CMStorePathFunctionArgument)function.args.get(0);
                int objectId = ((CMStorePredicateInteger)arg.PredicateExpressions.get((int)0)).digit;
                this.analyzeObjectIDs(info, new int[]{objectId});
                info.lockManagerUsage = 16;
            } else {
                this.lockStoreAsLastResort(info);
            }
        } else {
            this.analyzeDescendants(path, 0, info);
        }
        if (info != null) {
            this.infos_.add(info);
        }
        if (CMLockManagerLog.bLockManagerLogging_) {
            CMLockManager.log_.logAnalysis(info);
        }
    }

    private void analyzeExpandMembers(ICMStorePath storePath, int usage) throws CMStoreParseException {
        AnalyzedLockInfo info;
        List<ICMStorePath> list;
        if (storePath.isUnion()) {
            list = storePath.getUnion();
        } else {
            list = new ArrayList<ICMStorePath>();
            list.add(storePath);
        }
        HashSet<String> namespaces = new HashSet<String>();
        boolean lockDirectory = false;
        boolean lockRoot = false;
        for (ICMStorePath path : list) {
            CMStorePathPredicateFunction function = CMLockAnalysis.getNodesetFunction(path);
            if (function != null && function.function_ == CMConstants.FUNC_CAMID_DEF) {
                String camid = function.getStringArgument(0);
                namespaces.add(CMCAMIDHelper.getNamespaceIDFromCAMID(camid));
                continue;
            }
            if (path.toString().startsWith("/directory")) {
                lockDirectory = true;
                continue;
            }
            lockRoot = true;
            break;
        }
        if (lockRoot) {
            info = new AnalyzedLockInfo();
            info.lockManagerUsage = usage;
            this.lockStoreAsLastResort(info);
            this.infos_.add(info);
        } else if (lockDirectory) {
            info = new AnalyzedLockInfo();
            info.lockMode = 0;
            info.path = new CMStoreXPath("/directory");
            info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(usage);
            this.infos_.add(info);
        } else if (namespaces.contains(":")) {
            info = new AnalyzedLockInfo();
            info.lockMode = 0;
            info.path = new CMStoreXPath("/directory/namespace");
            info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(usage);
        } else if (AdvancedSettings.CAMSEARCHDEFERREDLOCKING) {
            info = new AnalyzedLockInfo();
            info.lockMode = 4;
        } else {
            for (String ns : namespaces) {
                AnalyzedLockInfo info2 = new AnalyzedLockInfo();
                info2.lockMode = 0;
                info2.path = CMCAMIDHelper.newInternalPath(ns);
                info2.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(usage);
                this.infos_.add(info2);
            }
        }
    }

    private static CMStorePathPredicateFunction getNodesetFunction(ICMStorePath path) {
        if (path.size() != 0 && !path.isUnion()) {
            CMStorePredicateElement predicate;
            CMStorePathStep step = path.stepAt(0);
            if (step.Predicates != null && step.Predicates.size() > 0 && (predicate = step.Predicates.get(0)).getClass() == CMStorePathPredicateFunction.class) {
                return (CMStorePathPredicateFunction)predicate;
            }
        }
        return null;
    }

    private void analyzeDescendants(ICMStorePath path, int iStep, AnalyzedLockInfo info) {
        while (iStep < path.size()) {
            if (path.stepAt(iStep).isDescendant()) {
                if (!path.stepAt(iStep).searchingByGloballyUniqueString()) {
                    if (iStep == 0) {
                        this.lockStoreAsLastResort(info);
                        break;
                    }
                    info.path = path.getParent(iStep);
                    info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(info.lockManagerUsage);
                    break;
                }
            } else if (null != path.stepAt(iStep).getPredicateFunction(CMConstants.FUNC_LAST_DEF)) {
                info.path = path.getParent(iStep);
                info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(info.lockManagerUsage);
                break;
            }
            ++iStep;
        }
        if (iStep == path.size()) {
            path.clearHasDescendantSteps();
            info.path = path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeURLID(ICMStorePath path, AnalyzedLockInfo info) throws CMStoreParseException {
        int numSteps = path.size();
        CMStorePathPredicateFunction func = CMLockAnalysis.getNodesetFunction(path);
        String sURLID = func.getStringArgument(0);
        int iObjID = -1;
        if (sURLID != null) {
            byte[] data = Base64.decode(sURLID);
            String urlPath = new String(data);
            if (urlPath.startsWith("+1")) {
                int iColon = urlPath.indexOf(":");
                CMStoreXPath camPath = new CMStoreXPath(urlPath.substring(iColon + 1));
                this.analyzeCAMID(camPath, info);
            } else {
                int iColon = urlPath.indexOf(":");
                iObjID = Integer.parseInt(urlPath.substring(0, iColon));
                urlPath = null;
                boolean bObjectValid = false;
                try {
                    CMStore store = CMExecutionContext.get().getStore();
                    ILockHandler iLockHandler = CMLockManager.getLockHandler();
                    synchronized (iLockHandler) {
                        if (store.isObjectIDValid(iObjID)) {
                            if (numSteps > 1) {
                                urlPath = store.getObjectSearchPath(iObjID);
                            }
                            bObjectValid = true;
                        }
                    }
                }
                catch (CMException ex) {
                    CMIndications.logException(ex);
                }
                if (numSteps > 1 && urlPath != null) {
                    info.path = new CMStoreXPath(urlPath);
                    info.path.append(path, 1);
                } else if (bObjectValid) {
                    info.objectsToLock = new int[1];
                    info.objectsToLock[0] = iObjID;
                    info.lockMode = 3;
                } else {
                    this.lockStoreAsLastResort(info);
                }
            }
        } else {
            this.lockStoreAsLastResort(info);
        }
    }

    private void analyzeCAMID(ICMStorePath path, AnalyzedLockInfo info) throws CMStoreParseException {
        CMStorePathPredicateFunction func = CMLockAnalysis.getNodesetFunction(path);
        String camid = func.getStringArgument(0);
        if (CMCAMIDHelper.CAMIDIsExternal(camid)) {
            if (AdvancedSettings.CAMSEARCHDEFERREDLOCKING) {
                this.analyzeExternalCAMIDDeferred(path, info, camid);
            } else {
                this.analyzeExternalCAMIDCoarse(path, info, camid);
            }
        } else {
            this.analyzeInternalCAMID(path, info, camid);
        }
    }

    public static int parentUsageFromUsage(int usage) {
        if (CMLockManager.LockHandlerTypeFromPathUsage(usage) == 0 || CMLockManager.LockHandlerTypeFromPathUsage(usage) == 6 || CMLockManager.LockHandlerTypeFromPathUsage(usage) == 7) {
            usage = 16;
        } else if (CMLockManager.LockHandlerTypeFromPathUsage(usage) == 4) {
            usage = 13;
        }
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeInternalCAMID(ICMStorePath path, AnalyzedLockInfo info, String camid) throws CMStoreParseException {
        int numSteps = path.size();
        if (camid.startsWith("::") && !CMCAMIDHelper.isFixedCAMID(camid)) {
            int object_id = CMCAMIDHelper.objectIdFromInternalCAMID(camid);
            if (object_id > 0) {
                String urlPath = null;
                boolean bObjectValid = false;
                try {
                    CMStore store = CMExecutionContext.get().getStore();
                    ILockHandler iLockHandler = CMLockManager.getLockHandler();
                    synchronized (iLockHandler) {
                        if (store.isObjectIDValid(object_id)) {
                            if (numSteps > 1) {
                                urlPath = store.getObjectSearchPath(object_id);
                            }
                            bObjectValid = true;
                        }
                    }
                }
                catch (CMException cMException) {
                    // empty catch block
                }
                if (numSteps > 1 && urlPath != null) {
                    info.path = new CMStoreXPath(urlPath);
                    info.path.append(path, 1);
                } else if (bObjectValid) {
                    info.objectsToLock = new int[1];
                    info.objectsToLock[0] = object_id;
                    info.lockMode = 3;
                } else {
                    info.path = CMCAMIDHelper.newInternalPath(":");
                    info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(info.lockManagerUsage);
                }
            } else {
                info.path = path;
            }
        } else if (!CMCAMIDHelper.isFixedCAMID(camid)) {
            String cognosNSPath = CMCAMIDHelper.CognosNSPathFromCAMID(camid);
            info.path = new CMStoreXPath(cognosNSPath, info.lockManagerUsage);
        } else {
            info.path = CMCAMIDHelper.newInternalPath(":", camid);
            info.path.setLockManagerUsageFlag(info.lockManagerUsage);
        }
    }

    private void analyzeExternalCAMIDCoarse(ICMStorePath path, AnalyzedLockInfo info, String camid) throws CMStoreParseException {
        String namespaceID = CMCAMIDHelper.getNamespaceIDFromCAMID(camid);
        if (camid.indexOf(58) >= 0) {
            info.path = CMCAMIDHelper.newInternalPath(namespaceID, camid);
            info.path.append(path, 1);
            info.ifNotExistLockPath = null;
        } else {
            info.path = CMCAMIDHelper.newInternalPath(namespaceID);
            info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(info.lockManagerUsage);
        }
    }

    private void analyzeExternalCAMIDDeferred(ICMStorePath path, AnalyzedLockInfo info, String camid) throws CMStoreParseException {
        boolean bExternalSearch;
        int numSteps = path.size();
        String namespaceID = CMCAMIDHelper.getNamespaceIDFromCAMID(camid);
        boolean bl = bExternalSearch = numSteps < 3 && (CMCAMIDHelper.isExtNamespace(camid) || CMCAMIDHelper.isExtNamespaceFolder(namespaceID, camid));
        if (bExternalSearch) {
            info.lockMode = 4;
        } else {
            info.lockMode = 5;
            info.path = camid.indexOf(58) == -1 ? CMCAMIDHelper.newInternalPath(namespaceID) : CMCAMIDHelper.newInternalPath(namespaceID, camid);
            int startIdx = 1;
            int endIdx = numSteps - 1;
            int i = startIdx;
            while (i < numSteps) {
                CMStorePathStep nextStep = path.stepAt(i);
                if (nextStep != null && nextStep.isDescendant()) {
                    info.lockMode = 2;
                    info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(info.lockManagerUsage);
                    break;
                }
                endIdx = i++;
            }
            info.path.append(path, startIdx, endIdx);
            info.path.setOriginalPath(info.path.toString());
            info.ifNotExistLockPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAccountAsLastResort(AnalyzedLockInfo info, CMExecutionContext execCtx) {
        int cmid = 0;
        try {
            cmid = execCtx.getCurrentUserAccountObjectID();
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        finally {
            if (cmid == 0) {
                this.lockStoreAsLastResort(info);
            }
        }
        info.objectsToLock = new int[]{cmid};
        info.lockManagerUsage = CMLockAnalysis.parentUsageFromUsage(info.lockManagerUsage);
    }

    private void lockStoreAsLastResort(AnalyzedLockInfo info) {
        this.bLockStore_ = true;
        info.lockMode = 1;
    }
}

