/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.locking;

import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.query.CacheEntryIterator;
import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.AbstractLockHandler;
import com.cognos.cm.locking.AnalyzedLockInfo;
import com.cognos.cm.locking.CMLockAnalysis;
import com.cognos.cm.locking.CMLockHandlerDenied;
import com.cognos.cm.locking.CMLockManagerContext;
import com.cognos.cm.locking.CMLockManagerLog;
import com.cognos.cm.locking.CMLockManagerScheduler;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.locking.ILockHandler;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.AddDef;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathPredicate;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePredicateElement;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.CMStoreXPathStep;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.cognos.cm.util.CMPerfAlarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public final class CMLockManager
implements ICMLockManager {
    private static boolean dbgDisableLocks_;
    private static final String sDebugLMNoLocks_ = "CM.debugLMNoLocks";
    private static boolean dbgDebugToConsole_;
    private static final String sDebugConsole_ = "CM.debugPerfLM";
    private static Set<CMConstants.FunctionDef> lockOptimizedPredFuncs;
    private static CMLockManagerScheduler sched_;
    private static ILockHandler lockHandler_;
    static CMStoreXPath CognosNamespacePath_;
    static final int[] rootObject;
    protected static CMLockManagerLog log_;

    public static boolean DebugToConsole() {
        return dbgDebugToConsole_;
    }

    public CMLockManager(AbstractLockHandler lh) {
        try {
            lockHandler_ = lh;
            lockHandler_.LMInitialize(CMIndicationGlobals.bLockManagerLogDebug);
            log_.Initialize();
        }
        catch (CMLockHandlerDenied e) {
            throw new CMRuntimeException(e);
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException(e, "cmStoreUnexpected");
            cmex.setAddStackTrace(true);
            throw new CMRuntimeException(cmex);
        }
    }

    public static String getLockTypeString(int nType) {
        switch (nType) {
            case -1: {
                return "UNSET";
            }
            case 0: {
                return "SHARED";
            }
            case 1: {
                return "SHARED_DESCENDANT";
            }
            case 2: {
                return "SHARED_EXCLUSIVE_DESCENDANT";
            }
            case 3: {
                return "EXCLUSIVE";
            }
            case 4: {
                return "EXCLUSIVE_PARENT";
            }
            case 6: {
                return "CHILD_MUTEX";
            }
            case 7: {
                return "PARENT_CHILD_MUTEX";
            }
            case 5: {
                return "HAVEBEENACQUIRED";
            }
            case 10: {
                return "QUERY";
            }
            case 11: {
                return "ADD";
            }
            case 12: {
                return "ADDREPLACE";
            }
            case 13: {
                return "UPDATE";
            }
            case 14: {
                return "UPDATERENAME";
            }
            case 15: {
                return "DELETE";
            }
            case 16: {
                return "COPYSRC";
            }
            case 17: {
                return "COPYDEST";
            }
            case 18: {
                return "MOVESRC";
            }
            case 19: {
                return "MOVEDEST";
            }
            case 20: {
                return "SECURITYREF";
            }
            case 21: {
                return "VERIFY";
            }
            case 22: {
                return "QUERYATOMIC";
            }
        }
        return "UNKNOWN=" + nType;
    }

    public static boolean lockTypeIsExclusive(int lockType) {
        return lockType == 3 || lockType == 4;
    }

    private List<ICMStorePath> splitCompoundPaths(List<ICMStorePath> paths) {
        boolean hasCompound = false;
        for (ICMStorePath path : paths) {
            if (!path.isUnion()) continue;
            hasCompound = true;
            break;
        }
        if (hasCompound) {
            ArrayList<ICMStorePath> list = new ArrayList<ICMStorePath>();
            for (ICMStorePath path : paths) {
                if (path.isUnion()) {
                    int usage = path.getLockManagerUsageFlag();
                    List<ICMStorePath> temp = path.getUnion();
                    for (ICMStorePath p : temp) {
                        p.setLockManagerUsageFlag(usage);
                    }
                    list.addAll(temp);
                    continue;
                }
                list.add(path);
            }
            paths = list;
        }
        return paths;
    }

    private static CMLockManagerContext getContext() throws CMException {
        CMLockManagerContext ctx = CMLockManagerContext.getContext();
        if (ctx == null) {
            ctx = CMLockManagerContext.createContext();
        }
        return ctx;
    }

    @Override
    public void requestLocks(List<ICMStorePath> searchPaths) throws CMException {
        List<ICMStorePath> paths = this.splitCompoundPaths(searchPaths);
        CMLockManagerContext ctx = CMLockManager.getContext();
        CMLockAnalysis analysis = new CMLockAnalysis(paths);
        AnalyzedLockInfo[] analysisInfo = analysis.getAnalysisInfo();
        ctx.setAnalysis(analysis);
        boolean locksDenied = true;
        while (locksDenied) {
            ++ctx.lockAttempts_;
            try {
                if (analysis.lockEntireStore()) {
                    ctx.setCoarseLocking(true);
                    this.requestLocksInsideMutex(ctx, rootObject, analysis.netLockUsage());
                } else {
                    this.requestLocksInsideMutex(ctx, analysisInfo);
                }
                locksDenied = false;
            }
            catch (CMLockHandlerDenied e) {
                this.handleLocksDenied(ctx, e);
            }
        }
        this.setLocksHaveBeenObtained(searchPaths);
        this.clearCachedResults(analysisInfo);
        if (CMLockManagerLog.bLockManagerLogging_) {
            log_.logAcquire(searchPaths);
        }
    }

    private void setLocksHaveBeenObtained(List<ICMStorePath> searchPaths) {
        for (ICMStorePath path : searchPaths) {
            path.setLocksHaveBeenObtained();
        }
    }

    private void clearCachedResults(AnalyzedLockInfo[] analysisInfos) {
        for (AnalyzedLockInfo info : analysisInfos) {
            if (info == null || info.path == null || info.path.getCacheResults() == null) continue;
            if (AdvancedSettings.CAMSEARCHDEFERREDLOCKING) {
                if (info.lockManagerUsage == 10 && info.path.getCacheResults().length <= 0) continue;
                info.path.setCacheResults(null);
                continue;
            }
            info.path.setCacheResults(null);
        }
    }

    @Override
    public void requestLocks(ICMStorePath path) throws CMException {
        ArrayList<ICMStorePath> paths = new ArrayList<ICMStorePath>();
        paths.add(path);
        this.requestLocks(paths);
    }

    public static CMStoreXPath getCognosNSPath() {
        if (CognosNamespacePath_ == null) {
            try {
                CognosNamespacePath_ = new CMStoreXPath("/directory/namespace[@id=':']");
            }
            catch (Throwable e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        return CognosNamespacePath_;
    }

    private CMCacheQueryInstance lockOfLastResort(ICMStorePath path, int usage, ICMStorePath alternatePath) throws CMLockHandlerDenied, CMException {
        CMLockManagerContext ctx = CMLockManagerContext.getContext();
        CMCacheQueryInstance results = null;
        int alternateUsage = CMLockAnalysis.parentUsageFromUsage(usage);
        if (alternatePath == null && path != null && path.size() > 1) {
            alternatePath = path.removeStep(-1);
        }
        while (alternatePath != null && alternatePath.size() > 0) {
            results = lockHandler_.acquireLocks(ctx, alternatePath, CMLockManager.LockHandlerTypeFromPathUsage(alternateUsage), lockHandler_.getCurrentHandle());
            if (results != null && results.count() > 0) {
                return results;
            }
            if (results != null) {
                results.release();
            }
            alternatePath = alternatePath.removeStep(-1);
        }
        ctx.setCoarseLocking(true);
        lockHandler_.acquireLocks(ctx, rootObject, CMLockManager.LockHandlerTypeFromPathUsage(alternateUsage), lockHandler_.getCurrentHandle());
        return null;
    }

    private void lockNothing(ICMStorePath searchPath) {
        int[] iaEmpty = new int[]{};
        searchPath.setCacheResults(iaEmpty);
        if (CMLockManagerLog.bLockManagerLogging_) {
            log_.logDebug("!!! Empty query result. lockNothing:" + searchPath);
        }
    }

    @Override
    public void requestLocksToObjects(int[] object_ids, int usage) throws CMException {
        if (CMIndicationGlobals.bLockManagerLogEnabled) {
            StringBuffer objs = new StringBuffer(object_ids.length * 12);
            objs.append("{");
            for (int i = 0; i < object_ids.length; ++i) {
                if (i > 0) {
                    objs.append(" ");
                }
                objs.append(Integer.toString(object_ids[i]));
            }
            objs.append("}");
            this.logLockMsg(objs.toString(), usage);
        }
        CMLockManagerContext ctx = CMLockManager.getContext();
        boolean locksDenied = true;
        while (locksDenied) {
            ++ctx.lockAttempts_;
            try {
                this.requestLocksInsideMutex(ctx, object_ids, usage);
                locksDenied = false;
            }
            catch (CMLockHandlerDenied e) {
                this.handleLocksDenied(ctx, e);
            }
        }
    }

    @Override
    public void requestLocks(Collection<InternalStoreId> ids, int usage) throws CMException {
        if (CMIndicationGlobals.bLockManagerLogEnabled) {
            StringBuffer buf = new StringBuffer(ids.size() * 34);
            buf.append("{");
            for (InternalStoreId id : ids) {
                buf.append(id.stringValue());
                buf.append(" ");
            }
            buf.deleteCharAt(buf.length() - 1);
            buf.append("}");
            this.logLockMsg(buf.toString(), usage);
        }
        CMLockManagerContext ctx = CMLockManager.getContext();
        boolean locksDenied = true;
        while (locksDenied) {
            ++ctx.lockAttempts_;
            try {
                this.requestLocksInsideMutex(ctx, CacheEntryIterator.create(ids), usage);
                locksDenied = false;
            }
            catch (CMLockHandlerDenied e) {
                this.handleLocksDenied(ctx, e);
            }
        }
    }

    @Override
    public void requestLockToRoot(int usage) throws CMException {
        this.requestLocksToObjects(rootObject, usage);
    }

    @Override
    public void requestLockToNamespace(String namespaceID, int lockUsage) throws CMStoreParseException, CMException {
        StringBuffer sb = new StringBuffer(60);
        sb.append("/directory/namespace[@id=");
        sb.append(CMStoreXPath.attributeQuoteString(namespaceID));
        sb.append("]");
        CMStoreXPath namespacePath = new CMStoreXPath(sb.toString());
        lockUsage = CMLockAnalysis.parentUsageFromUsage(lockUsage);
        namespacePath.setLockManagerUsageFlag(lockUsage);
        this.requestLocks(namespacePath);
    }

    @Override
    public void releaseLocks() throws CMException {
        if (CMIndicationGlobals.bLockManagerLogEnabled) {
            CMIndications.CMTrace("cmLockManagerLockRelease");
        }
        CMLockManagerContext ctx = null;
        ctx = CMLockManagerContext.getContext();
        if (ctx != null && !ctx.getDisableRelease()) {
            if (CMLockManagerLog.bLockManagerLogging_) {
                log_.logRelease();
            }
            ctx.release();
        }
    }

    @Override
    public boolean hasLocks() {
        CMLockManagerContext ctx = CMLockManagerContext.getContext();
        return ctx != null && ctx.hasAcquiredLocks();
    }

    @Override
    public void setDisableReleaseForInternalRequest(boolean bDisable) throws CMException {
        CMLockManagerContext ctx = null;
        ctx = CMLockManagerContext.getContext();
        if (ctx != null) {
            ctx.setDisableRelease(bDisable);
        }
    }

    @Override
    public boolean currentThreadHasExclusiveLocks() {
        boolean hasExclusiveLocks = false;
        CMLockManagerContext ctx = null;
        ctx = CMLockManagerContext.getContext();
        if (ctx != null) {
            hasExclusiveLocks = ctx.hasExclusiveLocks();
        }
        return hasExclusiveLocks;
    }

    protected static int getCurrentLockHandlerHandle() throws CMException {
        return CMLockManager.getContext().getHandle();
    }

    @Override
    public void handleLocksDenied(CMLockHandlerDenied e) throws CMException {
        CMLockManagerContext ctx = CMLockManagerContext.getContext();
        this.handleLocksDenied(ctx, e);
    }

    private void handleLocksDenied(CMLockManagerContext ctx, CMLockHandlerDenied e) throws CMException {
        ctx.setDeniedObject(e.getObject());
        if (!e.isCritical()) {
            if (CMIndicationGlobals.bLockManagerLogEnabled) {
                CMIndications.CMTrace("cmLocksDenied", new CMException.Parm("Path", e.getObject()));
            }
        } else {
            throw e;
        }
        sched_.suspendCurrentThread(ctx);
    }

    public static int LockHandlerTypeFromPathUsage(int usage) {
        if (usage == 10 || usage == 22 || usage == 20) {
            return 0;
        }
        if (usage == 17 || usage == 19 || usage == 13) {
            return 3;
        }
        if (usage == 11 || usage == 12) {
            return 3;
        }
        if (usage == 14 || usage == 15 || usage == 18) {
            return 4;
        }
        if (usage == 16 || usage == 16 || usage == 16) {
            return 1;
        }
        throw new IllegalStateException("Invalid Lock Manager lock usage specified: " + usage);
    }

    public static String LockHandlerTypeStringFromPathUsage(int usage) {
        if (usage == 10 || usage == 22 || usage == 20) {
            return "shared";
        }
        if (usage == 13 || usage == 17 || usage == 19) {
            return "exclusive";
        }
        if (usage == 11 || usage == 12) {
            return "shared-child-mutex";
        }
        if (usage == 14 || usage == 15 || usage == 18) {
            return "shared-parent-child-mutex";
        }
        if (usage == 16 || usage == 16 || usage == 16) {
            return "shared-descendant";
        }
        return "unknown";
    }

    public static int LockHandlerTypeFromSearchPath(ICMStorePath path) {
        if (path.getLocksHaveBeenObtained()) {
            return 5;
        }
        return CMLockManager.LockHandlerTypeFromPathUsage(path.getLockManagerUsageFlag());
    }

    private void logLockMsg(String path, int usage) {
        if (!CMIndicationGlobals.bLockManagerLogEnabled) {
            return;
        }
        if (usage < 0) {
            throw new IllegalStateException("Lock Manager lock usage not set on searchPath " + path);
        }
        CMException.Parm pathParam = new CMException.Parm("Path", path);
        switch (usage) {
            case 10: {
                CMIndications.CMTrace("cmLockManagerLockQuery", pathParam);
                break;
            }
            case 11: {
                CMIndications.CMTrace("cmLockManagerLockAdd", pathParam);
                break;
            }
            case 12: {
                CMIndications.CMTrace("cmLockManagerLockAddReplace", pathParam);
                break;
            }
            case 13: {
                CMIndications.CMTrace("cmLockManagerLockUpdate", pathParam);
                break;
            }
            case 14: {
                CMIndications.CMTrace("cmLockManagerLockUpdateRename", pathParam);
                break;
            }
            case 15: {
                CMIndications.CMTrace("cmLockManagerLockDelete", pathParam);
                break;
            }
            case 16: {
                CMIndications.CMTrace("cmLockManagerLockCopySrc", pathParam);
                break;
            }
            case 17: {
                CMIndications.CMTrace("cmLockManagerLockCopyDest", pathParam);
                break;
            }
            case 18: {
                CMIndications.CMTrace("cmLockManagerLockMoveSrc", pathParam);
                break;
            }
            case 19: {
                CMIndications.CMTrace("cmLockManagerLockCopyDest", pathParam);
                break;
            }
            case 20: {
                CMIndications.CMTrace("cmLockManagerLockSecurityRef", pathParam);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestLocksInsideMutex(CMLockManagerContext ctx, int[] object_ids, int usage) throws CMLockHandlerDenied, CMException {
        if (dbgDisableLocks_) {
            return;
        }
        long nOpStart = CMPerfAlarm.getSystemTicks();
        try {
            ILockHandler iLockHandler = lockHandler_;
            synchronized (iLockHandler) {
                lockHandler_.acquireLocks(ctx, object_ids, CMLockManager.LockHandlerTypeFromPathUsage(usage), lockHandler_.getCurrentHandle());
                lockHandler_.LMFinishedProtectedMutex(ctx.getHandle());
            }
        }
        catch (Throwable e) {
            this.handleExceptionInAcquire(e, usage);
        }
        finally {
            long threshold = AdvancedSettings.CMLOCKMANAGER_PERFALARM_THRESHOLD;
            if (threshold > 0L) {
                CMPerfAlarm.alarmTicksNow1Arg(nOpStart, threshold, "CMLockManager", "requestLocksInsideMutex", "int[]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestLocksInsideMutex(CMLockManagerContext ctx, Iterable<CacheEntry> entries, int usage) throws CMLockHandlerDenied, CMException {
        if (dbgDisableLocks_) {
            return;
        }
        long nOpStart = CMPerfAlarm.getSystemTicks();
        try {
            ILockHandler iLockHandler = lockHandler_;
            synchronized (iLockHandler) {
                lockHandler_.acquireLocks(ctx, entries, CMLockManager.LockHandlerTypeFromPathUsage(usage), lockHandler_.getCurrentHandle());
                lockHandler_.LMFinishedProtectedMutex(ctx.getHandle());
            }
        }
        catch (Throwable e) {
            this.handleExceptionInAcquire(e, usage);
        }
        finally {
            long threshold = AdvancedSettings.CMLOCKMANAGER_PERFALARM_THRESHOLD;
            if (threshold > 0L) {
                CMPerfAlarm.alarmTicksNow1Arg(nOpStart, threshold, "CMLockManager", "requestLocksInsideMutex", "Iterable<CacheEntry>");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestLocksInsideMutex(CMLockManagerContext ctx, AnalyzedLockInfo info, boolean bReleaseLHMutex) throws CMLockHandlerDenied, CMException {
        ICMStorePath searchPath = info.path;
        int usage = info.lockManagerUsage;
        ICMStorePath ifNotExistLockPath = info.ifNotExistLockPath;
        if (searchPath == null) {
            return;
        }
        if (dbgDisableLocks_) {
            searchPath.setLocksHaveBeenObtained();
            return;
        }
        long nOpStart = CMPerfAlarm.getSystemTicks();
        int lockType = CMLockManager.LockHandlerTypeFromPathUsage(usage);
        CMCacheQueryInstance results = null;
        try {
            ILockHandler iLockHandler = lockHandler_;
            synchronized (iLockHandler) {
                boolean bNoLocksFound;
                results = lockHandler_.acquireLocks(ctx, searchPath, lockType, lockHandler_.getCurrentHandle());
                boolean bSessionKludge = searchPath.getOriginalPath() != null && searchPath.getOriginalPath().startsWith("~~") && lockType == 0;
                boolean bl = bNoLocksFound = results == null || results.count() == 0 && !bSessionKludge;
                if (bNoLocksFound) {
                    if (results != null) {
                        results.release();
                        results = null;
                    }
                    if (AdvancedSettings.CAMSEARCHDEFERREDLOCKING) {
                        this.lockNothing(searchPath);
                    } else {
                        results = this.lockOfLastResort(searchPath, usage, ifNotExistLockPath);
                    }
                } else if (results != null) {
                    searchPath.setCacheResults(results.resultObjects());
                }
                if (bReleaseLHMutex) {
                    lockHandler_.LMFinishedProtectedMutex(lockHandler_.getCurrentHandle());
                }
            }
        }
        catch (Throwable e) {
            this.handleExceptionInAcquire(e, usage);
        }
        finally {
            long threshold;
            if (results != null) {
                results.release();
            }
            if ((threshold = (long)AdvancedSettings.CMLOCKMANAGER_PERFALARM_THRESHOLD) > 0L) {
                CMPerfAlarm.alarmTicksNow1Arg(nOpStart, threshold, "CMLockManager", "requestLocksInsideMutex", searchPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestLocksInsideMutex(CMLockManagerContext ctx, AnalyzedLockInfo[] searchPaths) throws CMLockHandlerDenied, CMException {
        int usage = 10;
        boolean bHasExclusiveLocks = false;
        long nOpStart = CMPerfAlarm.getSystemTicks();
        try {
            ILockHandler iLockHandler = lockHandler_;
            synchronized (iLockHandler) {
                for (int i = 0; i < searchPaths.length; ++i) {
                    ICMStorePath searchPath;
                    AnalyzedLockInfo pathInfo = searchPaths[i];
                    if (pathInfo == null) continue;
                    usage = pathInfo.lockManagerUsage;
                    if (pathInfo.lockMode == 3) {
                        if (pathInfo.objectsToLock == null) continue;
                        lockHandler_.acquireLocks(ctx, pathInfo.objectsToLock, CMLockManager.LockHandlerTypeFromPathUsage(usage), lockHandler_.getCurrentHandle());
                        continue;
                    }
                    if (pathInfo.lockMode == 4 || (searchPath = pathInfo.path) == null) continue;
                    int lockType = CMLockManager.LockHandlerTypeFromPathUsage(usage);
                    bHasExclusiveLocks |= lockType != 0 && lockType != 1;
                    this.requestLocksInsideMutex(ctx, pathInfo, false);
                }
                lockHandler_.LMFinishedProtectedMutex(lockHandler_.getCurrentHandle());
            }
        }
        catch (Throwable e) {
            this.handleExceptionInAcquire(e, bHasExclusiveLocks);
        }
        finally {
            long threshold = AdvancedSettings.CMLOCKMANAGER_PERFALARM_THRESHOLD;
            if (threshold > 0L) {
                CMPerfAlarm.alarmTicksNowArgs(nOpStart, threshold, "CMLockManager", "requestLocksInsideMutex", searchPaths);
            }
        }
    }

    private void handleExceptionInAcquire(Throwable e, int usage) throws CMLockHandlerDenied, CMException {
        this.handleExceptionInAcquire(e, usage != 10 && usage != 21);
    }

    private void handleExceptionInAcquire(Throwable e, boolean bReleaseLocks) throws CMLockHandlerDenied, CMException {
        if (e instanceof CMLockHandlerDenied) {
            if (((CMLockHandlerDenied)e).isCritical() || bReleaseLocks) {
                this.clearLocksFromHandle();
            }
            throw (CMLockHandlerDenied)e;
        }
        if (e instanceof CMException) {
            this.clearLocksFromHandle();
            throw (CMException)e;
        }
        this.clearLocksFromHandle();
        throw new CMException(e, "cmStoreUnexpected");
    }

    private void clearLocksFromHandle() throws CMException {
        if (CMIndicationGlobals.bLockManagerLogEnabled) {
            CMIndications.CMTrace("cmLockManagerLockRelease");
        }
        CMLockManagerContext ctx = null;
        ctx = CMLockManagerContext.getContext();
        if (ctx == null) {
            return;
        }
        int lockHandle = ctx.getHandle();
        try {
            lockHandler_.LMReleaseAllLocks(lockHandle);
        }
        catch (Exception e) {
            throw new CMException(e, "cmStoreUnexpected");
        }
    }

    public static String getState() {
        return CMLockManagerScheduler.state();
    }

    public static StringBuffer toPerfConsole(StringBuffer sb) {
        CMLockManagerScheduler.toPerfConsole(sb);
        return sb;
    }

    public static void outputStateXML(CMIndentedPrintStream out) {
        out.println("<lockManager>");
        out.indent();
        out.println("<contexts>");
        out.indent();
        Iterator<CMLockManagerContext> iter = CMLockManagerContext.getContextIterator();
        while (iter.hasNext()) {
            iter.next().outputStateXML(out);
        }
        out.unindent();
        out.println("</contexts>");
        out.unindent();
        out.println("</lockManager>");
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getObjectsCachedPropertiesInsideLockMutex(int[] objectIds, int[] properties) {
        Object[] returnArray = new Object[objectIds.length];
        try {
            CMStore store = CMExecutionContext.get().getStore();
            ILockHandler iLockHandler = lockHandler_;
            synchronized (iLockHandler) {
                for (int i = 0; i < objectIds.length; ++i) {
                    returnArray[i] = CMLockManager.getObjectCachedProperties(store, objectIds[i], properties);
                }
            }
        }
        catch (CMException ex) {
            return null;
        }
        return returnArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getObjectCachedPropertiesInsideLockMutex(int objectID, int[] properties) {
        Object[] returnArray = null;
        try {
            CMStore store = CMExecutionContext.get().getStore();
            ILockHandler iLockHandler = lockHandler_;
            synchronized (iLockHandler) {
                returnArray = CMLockManager.getObjectCachedProperties(store, objectID, properties);
            }
        }
        catch (CMException cMException) {
            // empty catch block
        }
        return returnArray;
    }

    private static Object[] getObjectCachedProperties(CMStore store, int objectID, int[] properties) {
        Object[] returnArray = null;
        if (objectID == -1) {
            return null;
        }
        try {
            if (store.isObjectIDValid(objectID)) {
                CMObjectClass cls = store.getObjectClass(objectID);
                if (cls == CMObjectClass._DELETEDOBJECT) {
                    return null;
                }
                returnArray = new Object[properties.length];
                for (int i = 0; i < properties.length; ++i) {
                    if (properties[i] == 4) {
                        returnArray[i] = cls;
                        continue;
                    }
                    if (properties[i] == 1) {
                        returnArray[i] = store.getObjectSearchPath(objectID);
                        continue;
                    }
                    if (properties[i] == 2) {
                        returnArray[i] = store.getObjectStoreID(objectID);
                        continue;
                    }
                    if (properties[i] != 3) continue;
                    returnArray[i] = store.getObjectSecurityReference(objectID);
                }
            }
        }
        catch (CMException cMException) {
            // empty catch block
        }
        return returnArray;
    }

    public static boolean shouldLockObjectIDs(ICMStorePath path) throws CMException {
        List<CMStorePredicateElement> predicates;
        boolean bRet = false;
        if (path == null || path.size() == 0) {
            return bRet;
        }
        if (path.isUnion()) {
            return bRet;
        }
        CMStorePathStep firstStep = path.stepAt(0);
        List<CMStorePredicateElement> list = predicates = firstStep == null ? null : firstStep.Predicates;
        if (predicates == null) {
            return bRet;
        }
        CMStorePathPredicateFunction predFunc = null;
        if (predicates.size() == 1) {
            CMStorePredicateElement firstPredicateExpress;
            CMStorePathPredicate firstPredicate = (CMStorePathPredicate)predicates.get(0);
            List<CMStorePredicateElement> predicateExpressions = firstPredicate.PredicateExpressions;
            if (predicateExpressions != null && predicateExpressions.size() == 1 && (firstPredicateExpress = predicateExpressions.get(0)) instanceof CMStorePathPredicateFunction) {
                predFunc = (CMStorePathPredicateFunction)firstPredicateExpress;
            }
        } else if (predicates.size() == 2 && firstStep instanceof CMStoreXPathStep) {
            CMStoreXPathStep firstXPathStep = (CMStoreXPathStep)firstStep;
            if (firstXPathStep.classpredicate_ != null) {
                for (int predicateIdx = 0; predicateIdx < 2; ++predicateIdx) {
                    CMStorePredicateElement firstPredicateExpress;
                    CMStorePathPredicate aPredicate = (CMStorePathPredicate)predicates.get(predicateIdx);
                    List<CMStorePredicateElement> predicateExpressions = aPredicate.PredicateExpressions;
                    if (predicateExpressions == null || predicateExpressions.size() != 1 || !((firstPredicateExpress = predicateExpressions.get(0)) instanceof CMStorePathPredicateFunction)) continue;
                    predFunc = (CMStorePathPredicateFunction)firstPredicateExpress;
                }
            }
        }
        if (predFunc != null && lockOptimizedPredFuncs.contains(predFunc.function_)) {
            bRet = true;
        }
        return bRet;
    }

    public static ILockHandler getLockHandler() {
        if (lockHandler_ == null) {
            throw new IllegalStateException("CMLockManager has not been initialized");
        }
        return lockHandler_;
    }

    public static void setLockHandler(ILockHandler mockLockHandler) {
        lockHandler_ = mockLockHandler;
    }

    @Override
    public int optimizeLockUsage(int lockUsage, AddDef addDef) {
        int adjustedLockUsage = lockUsage;
        if (lockUsage == 13) {
            if (addDef.hasName()) {
                adjustedLockUsage = 14;
            } else if (addDef.size() == 0) {
                adjustedLockUsage = -1;
            } else if (!addDef.isUpdatingCacheProperty() && !addDef.isUpdatingRetentionRules()) {
                adjustedLockUsage = 10;
            }
        } else if (lockUsage == 11 && AdvancedSettings.ENABLE_CONCURRENT_ADD && this.permitConcurrentAdd(addDef)) {
            adjustedLockUsage = 10;
        }
        return adjustedLockUsage;
    }

    private boolean permitConcurrentAdd(AddDef addDef) {
        CMObjectClass objectClass = addDef.objectClass;
        return CMObjectClass.OUTPUT.equals(objectClass) && !addDef.hasName();
    }

    static {
        lockOptimizedPredFuncs = new HashSet<CMConstants.FunctionDef>();
        lockOptimizedPredFuncs.add(CMConstants.FUNC_CONTAINSREFERENCES_DEF);
        lockOptimizedPredFuncs.add(CMConstants.FUNC_OWNEDBY_DEF);
        sched_ = CMLockManagerScheduler.getInstance();
        rootObject = new int[]{0};
        log_ = new CMLockManagerLog();
        Properties sysProps = System.getProperties();
        dbgDisableLocks_ = sysProps.containsKey(sDebugLMNoLocks_);
        if (sysProps.containsKey(sDebugConsole_)) {
            dbgDebugToConsole_ = true;
            System.out.println("CM.debugPerfLM specified on command line, will print out LM console debug stmts");
        } else {
            dbgDebugToConsole_ = false;
        }
    }
}

