/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.locking;

import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.CMLockAnalysis;
import com.cognos.cm.locking.CMLockHandlerDenied;
import com.cognos.cm.locking.CMLockManager;
import com.cognos.cm.locking.CMLockManagerScheduler;
import com.cognos.cm.locking.CMLockManagerState;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.cognos.cmutils.xml.XMLUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public final class CMLockManagerContext
implements Comparable<CMLockManagerContext> {
    public static final Counter lockWait = new AccumulatingCounter().makeThreadLocal();
    private static final Timer lockWaitTimer = new Timer(lockWait);
    private static long ticksPerSec_ = CMLockManagerContext.getSystemTicksPerSec();
    private static long g_nTotalContextsCreatedCount_ = 0L;
    private static final CMLockManagerScheduler sched_ = CMLockManagerScheduler.getInstance();
    Thread thread_ = null;
    private boolean assertThreadOwnership = true;
    private boolean bReleased_ = false;
    private String deniedObject_ = null;
    private String ipfOp_ = null;
    private String ipfPath_ = null;
    private CMLockManagerState state_ = CMLockManagerState.INACTIVE;
    private CMLockAnalysis analysis_ = null;
    private boolean bHasAcquiredLocks_ = false;
    private boolean disableRelease_ = false;
    private int lockHandlerHandle_ = -1;
    public int lockAttempts_ = 0;
    private boolean hasExclusiveLocks_ = false;
    private int currentLockType_ = -1;
    private boolean coarseLocking_ = false;
    private long ticksWaiting_ = 0L;
    private long ticksAcquired_ = 0L;
    private long startAcquired_ = 0L;
    private long startTime_ = 0L;
    private long ticksExecuting_ = 0L;
    private ArrayList<String> debugPaths_ = null;
    private static ConcurrentHashMap<Thread, CMLockManagerContext> currentContexts_ = new ConcurrentHashMap(87);
    private static long g_nTotalCoarseContextsCreatedCount_ = 0L;

    private CMLockManagerContext(Thread t, boolean assertThreadOwnership) {
        CMExecutionContext execCtx = CMExecutionContext.get();
        this.assertThreadOwnership = assertThreadOwnership;
        this.thread_ = t;
        this.ipfOp_ = execCtx.getIPFOperation();
        this.ipfPath_ = execCtx.getIPFObjectPath();
        this.reset();
        CMLockManagerContext.incrTotalContextsCreatedCount();
    }

    protected CMLockManagerContext(int handle) {
        this.lockHandlerHandle_ = handle;
    }

    @Override
    public int compareTo(CMLockManagerContext other) {
        if (other.lockHandlerHandle_ == this.lockHandlerHandle_) {
            return 0;
        }
        return this.lockHandlerHandle_ < other.lockHandlerHandle_ ? -1 : 1;
    }

    private static synchronized void incrTotalContextsCreatedCount() {
        ++g_nTotalContextsCreatedCount_;
    }

    public static long getTotalContextsCreatedCount() {
        return g_nTotalContextsCreatedCount_;
    }

    private static synchronized void incrTotalCoarseContextsCreatedCount() {
        ++g_nTotalCoarseContextsCreatedCount_;
    }

    public static long getTotalCoarseContextsCreatedCount() {
        return g_nTotalCoarseContextsCreatedCount_;
    }

    public boolean isValid() {
        return this.lockHandlerHandle_ >= 0;
    }

    public CMLockManagerState getState() {
        return this.state_;
    }

    public boolean isStarving() {
        return this.state_.equals(CMLockManagerState.STARVING);
    }

    public void setState(CMLockManagerState state) {
        Thread ctxThread = this.getThread();
        if (this.assertThreadOwnership && ctxThread != null && Thread.currentThread() != ctxThread) {
            throw new IllegalStateException("Attempt to set state from another thread.");
        }
        if (state != this.state_) {
            if (this.state_ == CMLockManagerState.EXECUTING) {
                CMLockManagerScheduler.decrExecutingThreadsCount();
            }
            this.state_ = state;
            if (this.state_ == CMLockManagerState.EXECUTING) {
                CMLockManagerScheduler.incrExecutingThreadsCount();
            }
        }
    }

    public Thread getThread() {
        return this.thread_;
    }

    protected int getHandle() throws CMException {
        if (this.lockHandlerHandle_ < 0) {
            try {
                this.reset();
                this.lockHandlerHandle_ = CMLockManager.getLockHandler().LMAllocateHandle();
                sched_.enter(this);
            }
            catch (CMLockHandlerDenied e) {
                throw e;
            }
            catch (CMCacheException e) {
                throw new CMException(e, "cmStoreUnexpected");
            }
        }
        return this.lockHandlerHandle_;
    }

    protected void finishedProtectedMutex() throws CMException {
        try {
            if (this.lockHandlerHandle_ >= 0) {
                CMLockManager.getLockHandler().LMFinishedProtectedMutex(this.lockHandlerHandle_);
            }
        }
        catch (CMLockHandlerDenied e) {
            throw e;
        }
        catch (CMCacheException e) {
            throw new CMException(e, "cmStoreUnexpected");
        }
    }

    protected void release() throws CMException {
        this.release(true);
    }

    private void release(boolean bWorryAboutState) throws CMException {
        if (this.bReleased_) {
            return;
        }
        if (this.assertThreadOwnership && Thread.currentThread() != this.getThread()) {
            throw new IllegalStateException("Setting context state from other thread");
        }
        CMLockManagerContext mappedCtx = currentContexts_.remove(this.thread_);
        if (bWorryAboutState && (mappedCtx == null || mappedCtx != this)) {
            throw new IllegalStateException("Attempt to release an unmapped CMLockManagerContext!");
        }
        try {
            if (this.lockHandlerHandle_ >= 0) {
                CMLockManager.getLockHandler().LMReleaseHandle(this.lockHandlerHandle_);
                this.bReleased_ = true;
                sched_.exit(this);
            }
        }
        catch (CMLockHandlerDenied e) {
            CMIndications.logException(e);
            throw e;
        }
        catch (CMCacheException e) {
            throw new CMException(e, "cmStoreUnexpected");
        }
        this.reset();
    }

    protected static long getSystemTicks() {
        try {
            return System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    protected static long getSystemTicksPerSec() {
        try {
            return 1000L;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void reset() {
        this.lockHandlerHandle_ = -1;
        this.setHasAcquiredLocks(false, false);
        this.setState(CMLockManagerState.INACTIVE);
        this.coarseLocking_ = false;
        this.currentLockType_ = -1;
        this.resetTimers();
        this.debugPaths_ = null;
        this.lockAttempts_ = 0;
        this.disableRelease_ = false;
        this.analysis_ = null;
        this.deniedObject_ = null;
    }

    public int getCurrentLockType() {
        return this.currentLockType_;
    }

    public void setCurrentLockType(int type) {
        this.currentLockType_ = type;
    }

    public boolean isCurrentLockTypeExclusive() {
        return CMLockManager.lockTypeIsExclusive(this.currentLockType_);
    }

    public void setDisableRelease(boolean bDisable) {
        this.disableRelease_ = bDisable;
    }

    public boolean getDisableRelease() {
        return this.disableRelease_;
    }

    public void setCoarseLocking(boolean flag) {
        if (this.assertThreadOwnership && Thread.currentThread() != this.getThread()) {
            throw new IllegalStateException("Setting context state from other thread");
        }
        if (this.coarseLocking_ != flag) {
            if (!this.coarseLocking_ && flag) {
                CMLockManagerContext.incrTotalCoarseContextsCreatedCount();
            }
            this.coarseLocking_ = flag;
        }
    }

    public void resetTimers() {
        this.ticksWaiting_ = 0L;
        this.ticksAcquired_ = 0L;
        this.startAcquired_ = 0L;
        this.startTime_ = 0L;
        this.ticksExecuting_ = 0L;
    }

    public void startAcquiredTimer() {
        this.startAcquired_ = CMLockManagerContext.getSystemTicks();
    }

    public void stopAcquiredTimer() {
        this.ticksAcquired_ = CMLockManagerContext.getSystemTicks() - this.startAcquired_;
    }

    public void startExecuteTimer() {
        this.startTime_ = CMLockManagerContext.getSystemTicks();
    }

    public void stopExecuteTimer() {
        this.ticksExecuting_ = CMLockManagerContext.getSystemTicks() - this.startTime_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(long interval) throws InterruptedException {
        if (CMIndicationGlobals.bLockManagerLogEnabled) {
            CMException.Parm threadParam = new CMException.Parm("Thread", this.thread_.getName());
            CMIndications.CMTrace("cmLockManagerSuspendingThread", threadParam);
        }
        lockWaitTimer.start();
        try {
            long elapsed = 0L;
            CMLockManagerContext cMLockManagerContext = this;
            synchronized (cMLockManagerContext) {
                long started = CMLockManagerContext.getSystemTicks();
                this.wait(interval);
                elapsed = CMLockManagerContext.getSystemTicks() - started;
                this.ticksWaiting_ += elapsed;
            }
        }
        finally {
            lockWaitTimer.stop();
        }
        if (CMIndicationGlobals.bLockManagerLogEnabled) {
            CMException.Parm threadParam = new CMException.Parm("Thread", this.thread_.getName());
            CMException.Parm waitedParam = new CMException.Parm("Waited", this.getTimeWaitedString());
            CMIndications.CMTrace("cmLockManagerResumingThread", threadParam, waitedParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        if (CMIndicationGlobals.bLockManagerLogEnabled) {
            CMException.Parm threadParam = new CMException.Parm("Thread", this.thread_.getName());
            CMIndications.CMTrace("cmLockManagerNotifyThread", threadParam);
        }
        CMLockManagerContext cMLockManagerContext = this;
        synchronized (cMLockManagerContext) {
            this.notify();
        }
    }

    public long getTicksWaited() {
        return this.ticksWaiting_;
    }

    public long getTimeWaited() {
        return this.ticksWaiting_ / ticksPerSec_;
    }

    public String getTimeWaitedString() {
        return this.ticksToSeconds(this.ticksWaiting_);
    }

    public long getTicksSinceAcquired() {
        if (this.startAcquired_ == 0L) {
            return 0L;
        }
        if (this.ticksAcquired_ != 0L) {
            return this.ticksAcquired_;
        }
        return CMLockManagerContext.getSystemTicks() - this.startAcquired_;
    }

    public long getTimeSinceAcquired() {
        return this.getTicksSinceAcquired() / ticksPerSec_;
    }

    public String getTimeSinceAcquiredString() {
        return this.ticksToSeconds(this.getTicksSinceAcquired());
    }

    public long getTicksExecuted() {
        if (this.startTime_ != 0L) {
            if (this.ticksExecuting_ != 0L) {
                return this.ticksExecuting_;
            }
            return CMLockManagerContext.getSystemTicks() - this.startTime_;
        }
        return 0L;
    }

    public long getTimeExecuted() {
        return this.getTicksExecuted() / ticksPerSec_;
    }

    public String getTimeExecutedString() {
        return this.ticksToSeconds(this.getTicksExecuted());
    }

    private String ticksToSeconds(long ticks) {
        DecimalFormat formatter = new DecimalFormat("0.###");
        double numSeconds = (double)ticks / (double)ticksPerSec_;
        return formatter.format(numSeconds);
    }

    public int hashCode() {
        return this.thread_.hashCode();
    }

    public void outputStateXML(CMIndentedPrintStream out) {
        CMLockAnalysis analysis;
        out.println("<context>");
        out.indent();
        out.println("<handle>" + this.lockHandlerHandle_ + "</handle>");
        out.println("<thread>" + XMLUtils.escape((String)this.thread_.getName(), (boolean)false) + "</thread>");
        out.println("<state>" + this.state_ + "</state>");
        out.println("<operation>" + this.ipfOp_ + "</operation>");
        out.println("<path>" + XMLUtils.escape((String)this.ipfPath_, (boolean)false) + "</path>");
        out.println("<executed>" + this.getTimeExecutedString() + "</executed>");
        out.println("<waited>" + this.getTimeWaitedString() + "</waited>");
        out.println("<held>" + this.getTimeSinceAcquiredString() + "</held>");
        out.println("<attempts>" + this.lockAttempts_ + "</attempts>");
        if (this.isWaiting()) {
            out.println("<deniedObject>" + this.deniedObject_ + "</deniedObject>");
        }
        if ((analysis = this.getAnalysis()) != null) {
            analysis.outputStateXML(out);
        }
        out.unindent();
        out.println("</context>");
        out.flush();
    }

    public boolean isExecuting() {
        return this.state_ == CMLockManagerState.EXECUTING;
    }

    public boolean isWaiting() {
        return this.state_ == CMLockManagerState.WAITING;
    }

    public boolean isInactive() {
        return this.state_ == CMLockManagerState.INACTIVE;
    }

    public String toString() {
        CMExecutionContext.get();
        StringBuffer sb = new StringBuffer();
        sb.append(this.thread_.getName());
        sb.append(":state=" + this.state_);
        sb.append(":handle=");
        sb.append(this.lockHandlerHandle_);
        sb.append(":coarseLocking=");
        sb.append(this.coarseLocking_);
        sb.append(":hasExclusiveLocks=");
        sb.append(this.hasExclusiveLocks_);
        sb.append(":executed=");
        sb.append(this.getTimeExecutedString());
        sb.append(":waited=");
        sb.append(this.getTimeWaitedString());
        sb.append(":attempts=");
        sb.append(this.lockAttempts_);
        if (this.isWaiting()) {
            sb.append(":deniedObject=").append(this.deniedObject_);
        }
        if (this.ipfOp_ != null) {
            sb.append(":ipfOp=" + this.ipfOp_);
        }
        if (this.ipfPath_ != null) {
            sb.append(":ipfPath=" + this.ipfPath_);
        }
        if (this.debugPaths_ != null) {
            for (int i = 0; i < this.debugPaths_.size(); ++i) {
                String debugPath = this.debugPaths_.get(i);
                if (debugPath == null) continue;
                sb.append(":path");
                sb.append(i);
                sb.append("=");
                sb.append(debugPath);
            }
        }
        return sb.toString();
    }

    public StringBuffer toPerfConsole(StringBuffer sb) {
        sb.append("    Context: ").append(this.thread_.getName());
        sb.append(" state=").append(this.state_);
        sb.append(" handle=").append(this.lockHandlerHandle_);
        sb.append(" LOCKS=[");
        sb.append(" type:").append(CMLockManager.getLockTypeString(this.currentLockType_));
        sb.append(" ").append(this.bHasAcquiredLocks_ ? "ACQUIRED" : "not-acquired");
        sb.append(" ").append(this.coarseLocking_ ? "COARSE" : "fine");
        sb.append(" ").append(this.hasExclusiveLocks_ ? "EXCLUSIVE" : "shared");
        sb.append("]");
        sb.append(" waited=").append(this.getTimeWaitedString());
        sb.append(" attempts=").append(this.lockAttempts_);
        sb.append(" ").append(this.bReleased_ ? "RELEASED" : "");
        if (this.debugPaths_ != null) {
            sb.append("\n");
            if (this.debugPaths_.size() == 0) {
                sb.append("        No paths");
            } else {
                for (int i = 0; i < this.debugPaths_.size(); ++i) {
                    sb.append("        Path=" + this.debugPaths_.get(i));
                    if (i + 1 >= this.debugPaths_.size()) continue;
                    sb.append("\n");
                }
            }
        }
        return sb;
    }

    protected static CMLockManagerContext getContext() {
        Thread currentThread = Thread.currentThread();
        CMLockManagerContext ctx = currentContexts_.get(currentThread);
        return ctx;
    }

    protected static CMLockManagerContext createContext() throws CMException {
        return CMLockManagerContext.createContext(Thread.currentThread(), true);
    }

    static CMLockManagerContext createContext(Thread thread, boolean assertThreadOwnership) throws CMException {
        CMLockManagerContext ctxNEW = null;
        CMLockManagerContext ctxEXISTING = null;
        ctxNEW = new CMLockManagerContext(thread, assertThreadOwnership);
        ctxEXISTING = currentContexts_.put(thread, ctxNEW);
        if (ctxEXISTING != null && CMLockManager.DebugToConsole()) {
            StringBuffer sb = new StringBuffer(200);
            sb.append("LM: create context: unexpected context remains in map: ");
            ctxEXISTING.toPerfConsole(sb);
        }
        if (ctxEXISTING != null) {
            ctxEXISTING.release(false);
        }
        ctxNEW.getHandle();
        return ctxNEW;
    }

    public static Iterator<CMLockManagerContext> getContextIterator() {
        return currentContexts_.values().iterator();
    }

    public static int getNumWaitingContexts() {
        int nWaiting = 0;
        Iterator<CMLockManagerContext> iter = CMLockManagerContext.getContextIterator();
        while (iter.hasNext()) {
            CMLockManagerContext ctx = iter.next();
            if (ctx.getState() != CMLockManagerState.WAITING) continue;
            ++nWaiting;
        }
        return nWaiting;
    }

    public static int getContextCount() {
        return currentContexts_.size();
    }

    public boolean isReleased() {
        return this.bReleased_;
    }

    public boolean hasCoarseLocking() {
        return this.coarseLocking_;
    }

    public void setHasAcquiredLocks(boolean bAcquired, boolean bExclusive) {
        if (this.assertThreadOwnership && this.getThread() != null && Thread.currentThread() != this.getThread()) {
            throw new IllegalStateException("Setting context state from other thread");
        }
        if (!this.bHasAcquiredLocks_ && bAcquired) {
            this.startAcquiredTimer();
        }
        if (this.bHasAcquiredLocks_ != bAcquired || this.hasExclusiveLocks_ != bExclusive) {
            this.bHasAcquiredLocks_ = bAcquired;
            this.hasExclusiveLocks_ = bExclusive;
        }
    }

    public boolean hasAcquiredLocks() {
        return this.bHasAcquiredLocks_;
    }

    public void setAnalysis(CMLockAnalysis analysis) {
        this.analysis_ = analysis;
    }

    public CMLockAnalysis getAnalysis() {
        return this.analysis_;
    }

    public void Debug_AddPath(String sPath) {
        if (this.debugPaths_ == null) {
            this.debugPaths_ = new ArrayList();
        }
        this.debugPaths_.add(sPath);
    }

    public boolean hasExclusiveLocks() {
        return this.hasExclusiveLocks_;
    }

    public void setDeniedObject(String objectPath) {
        this.deniedObject_ = objectPath;
    }
}

