/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.locking;

import com.cognos.cm.locking.AnalyzedLockInfo;
import com.cognos.cm.locking.CMLockManager;
import com.cognos.cm.locking.CMLockManagerContext;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class CMLockManagerLog {
    public static boolean bLockManagerLogging_;
    private static OutputStreamWriter lockManagerLog_;

    public void Initialize() {
        String sRecordFilePath = "../logs/cm_locking.xml";
        Properties sysProps = System.getProperties();
        String sProp = "CM.recordLocking";
        bLockManagerLogging_ = false;
        if (sysProps.containsKey(sProp)) {
            bLockManagerLogging_ = true;
            String sPath = sysProps.getProperty(sProp);
            if (sPath != null && sPath.length() > 0) {
                sRecordFilePath = sPath;
            }
        }
        if (!bLockManagerLogging_) {
            return;
        }
        try {
            lockManagerLog_ = new OutputStreamWriter(new FileOutputStream(sRecordFilePath));
            System.out.println("*** Using property '" + sProp + "' to log CM lock activity to file '" + sRecordFilePath + "'...");
        }
        catch (FileNotFoundException e) {
            System.out.println("!!! Using property '" + sProp + "', unable to log CM lock activity to file '" + sRecordFilePath + "': " + e);
            lockManagerLog_ = null;
        }
    }

    private void appendNameValue(StringBuffer msgBuf, String name, String value) {
        msgBuf.append(name);
        msgBuf.append("=\"");
        msgBuf.append(value);
        msgBuf.append("\" ");
    }

    private void appendNameValueEncoded(StringBuffer msgBuf, String name, String value) {
        msgBuf.append(name);
        msgBuf.append("=\"");
        msgBuf.append(XMLUtils.escape((String)value));
        msgBuf.append("\" ");
    }

    private void appendLockCtx(StringBuffer msgBuf, CMLockManagerContext lockCtx) {
        msgBuf.append("handle=\"");
        try {
            msgBuf.append(lockCtx.getHandle());
        }
        catch (Exception e) {
            msgBuf.append("-1");
        }
        msgBuf.append("\" ");
        msgBuf.append("coarse=\"");
        msgBuf.append(lockCtx.hasCoarseLocking());
        msgBuf.append("\" ");
        msgBuf.append("waited=\"");
        msgBuf.append(lockCtx.getTimeWaitedString());
        msgBuf.append("\" ");
    }

    public void logAcquire(ICMStorePath path) {
        this.logPathOperation(path, "acquire");
    }

    public void logRequest(ICMStorePath path) {
        this.logPathOperation(path, "request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logPathOperation(ICMStorePath path, String sElementName) {
        if (lockManagerLog_ == null) {
            return;
        }
        StringBuffer msgBuf = new StringBuffer();
        try {
            CMExecutionContext ctx = CMExecutionContext.get();
            CMLockManagerContext lockCtx = CMLockManagerContext.getContext();
            Date curDate = new Date();
            msgBuf.append("<").append(sElementName).append(" ");
            this.appendNameValue(msgBuf, "date", curDate.toString());
            this.appendNameValue(msgBuf, "context", String.valueOf(ctx.getId()));
            this.appendNameValue(msgBuf, "thread", Thread.currentThread().getName());
            this.appendNameValue(msgBuf, "user", ctx.getCurrentUser());
            this.appendNameValue(msgBuf, "operation", ctx.getIPFOperation());
            this.appendNameValueEncoded(msgBuf, "object", ctx.getIPFObjectPath());
            if (lockCtx != null) {
                this.appendLockCtx(msgBuf, lockCtx);
            }
            if (path != null) {
                this.appendNameValueEncoded(msgBuf, "path", path.getOriginalPath());
                this.appendNameValue(msgBuf, "type", CMLockManager.LockHandlerTypeStringFromPathUsage(path.getLockManagerUsageFlag()));
            }
            msgBuf.append("/>\n");
            OutputStreamWriter outputStreamWriter = lockManagerLog_;
            synchronized (outputStreamWriter) {
                lockManagerLog_.write(msgBuf.toString());
                lockManagerLog_.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e + ": Unable to log message: " + msgBuf.toString());
        }
    }

    public void logAcquire(List<ICMStorePath> paths) {
        this.logPathOperation(paths, "acquire");
    }

    public void logRequest(List<ICMStorePath> paths) {
        this.logPathOperation(paths, "request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logPathOperation(List<ICMStorePath> paths, String sElementName) {
        if (lockManagerLog_ == null) {
            return;
        }
        StringBuffer msgBuf = new StringBuffer();
        try {
            CMExecutionContext ctx = CMExecutionContext.get();
            CMLockManagerContext lockCtx = CMLockManagerContext.getContext();
            Date curDate = new Date();
            msgBuf.append("<").append(sElementName).append(" ");
            this.appendNameValue(msgBuf, "date", curDate.toString());
            this.appendNameValue(msgBuf, "context", String.valueOf(ctx.getId()));
            this.appendNameValue(msgBuf, "operation", ctx.getIPFOperation());
            this.appendNameValue(msgBuf, "object", ctx.getIPFObjectPath());
            if (lockCtx != null) {
                this.appendLockCtx(msgBuf, lockCtx);
            }
            if (paths != null) {
                msgBuf.append(">\n");
                for (int i = 0; i < paths.size(); ++i) {
                    ICMStorePath path = paths.get(i);
                    msgBuf.append("  <path ");
                    this.appendNameValueEncoded(msgBuf, "value", path.getOriginalPath());
                    this.appendNameValue(msgBuf, "type", CMLockManager.LockHandlerTypeStringFromPathUsage(path.getLockManagerUsageFlag()));
                    msgBuf.append("/>\n");
                }
                msgBuf.append("</").append(sElementName).append(">\n");
            } else {
                msgBuf.append("/>\n");
            }
            OutputStreamWriter outputStreamWriter = lockManagerLog_;
            synchronized (outputStreamWriter) {
                lockManagerLog_.write(msgBuf.toString());
                lockManagerLog_.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e + ": Unable to log message: " + msgBuf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRelease() {
        if (lockManagerLog_ == null) {
            return;
        }
        StringBuffer msgBuf = new StringBuffer();
        try {
            CMExecutionContext ctx = CMExecutionContext.get();
            CMLockManagerContext lockCtx = CMLockManagerContext.getContext();
            Date curDate = new Date();
            msgBuf.append("<release ");
            this.appendNameValue(msgBuf, "date", curDate.toString());
            this.appendNameValue(msgBuf, "context", String.valueOf(ctx.getId()));
            this.appendNameValue(msgBuf, "thread", Thread.currentThread().getName());
            this.appendNameValue(msgBuf, "user", ctx.getCurrentUser());
            this.appendNameValue(msgBuf, "operation", ctx.getIPFOperation());
            this.appendNameValueEncoded(msgBuf, "object", ctx.getIPFObjectPath());
            if (lockCtx != null) {
                this.appendLockCtx(msgBuf, lockCtx);
                this.appendNameValue(msgBuf, "duration", lockCtx.getTimeSinceAcquiredString());
            }
            msgBuf.append("/>\n");
            OutputStreamWriter outputStreamWriter = lockManagerLog_;
            synchronized (outputStreamWriter) {
                lockManagerLog_.write(msgBuf.toString());
                lockManagerLog_.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e + ": Unable to log message: " + msgBuf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAnalysis(AnalyzedLockInfo info) {
        StringBuffer msgBuf = new StringBuffer();
        try {
            CMExecutionContext ctx = CMExecutionContext.get();
            CMLockManagerContext lockCtx = CMLockManagerContext.getContext();
            Date curDate = new Date();
            msgBuf.append("<").append("analysis ");
            this.appendNameValue(msgBuf, "date", curDate.toString());
            this.appendNameValue(msgBuf, "context", String.valueOf(ctx.getId()));
            this.appendNameValue(msgBuf, "operation", ctx.getIPFOperation());
            this.appendNameValue(msgBuf, "object", ctx.getIPFObjectPath());
            if (lockCtx != null) {
                this.appendLockCtx(msgBuf, lockCtx);
            }
            if (info.lockMode == 0) {
                this.appendNameValue(msgBuf, "type", "LOCK_QUERY_PATH");
            } else if (info.lockMode == 2) {
                this.appendNameValue(msgBuf, "type", "LOCK_ALTERNATE_PATH");
            } else if (info.lockMode == 3) {
                this.appendNameValue(msgBuf, "type", "LOCK_OBJECTS_BY_ID");
            } else if (info.lockMode == 1) {
                this.appendNameValue(msgBuf, "type", "LOCK_STORE");
            } else if (info.lockMode == 4) {
                this.appendNameValue(msgBuf, "type", "LOCK_DEFERRED");
            } else if (info.lockMode == 5) {
                this.appendNameValue(msgBuf, "type", "LOCK_PROXY_PATH");
            } else {
                this.appendNameValue(msgBuf, "type", "UNKNOWN");
            }
            this.appendNameValue(msgBuf, "lockManagerUsage", CMLockManager.LockHandlerTypeStringFromPathUsage(info.lockManagerUsage));
            msgBuf.append(">\n");
            if (info.lockMode == 0 || info.lockMode == 2 || info.lockMode == 5) {
                if (!info.path.getLocksHaveBeenObtained()) {
                    msgBuf.append("  <path ");
                    this.appendNameValueEncoded(msgBuf, "value", info.path.toString());
                    this.appendNameValue(msgBuf, "type", CMLockManager.LockHandlerTypeStringFromPathUsage(info.lockManagerUsage));
                    if (info.ifNotExistLockPath != null) {
                        this.appendNameValueEncoded(msgBuf, "ifNotExistPath", info.ifNotExistLockPath.toString());
                    }
                    msgBuf.append("/>\n");
                }
            } else if (info.lockMode == 3) {
                for (int i = 0; i < info.objectsToLock.length; ++i) {
                    msgBuf.append("  <objectID id=\"" + info.objectsToLock[i] + "\"/>\n");
                }
            } else if (info.lockMode == 1) {
                msgBuf.append("  <lockStore/>\n");
            } else {
                msgBuf.append("  <unknown/>\n");
            }
            msgBuf.append("</analysis>\n");
            OutputStreamWriter outputStreamWriter = lockManagerLog_;
            synchronized (outputStreamWriter) {
                lockManagerLog_.write(msgBuf.toString());
                lockManagerLog_.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e + ": Unable to log message: " + msgBuf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDebug(String msg) {
        StringBuffer msgBuf = new StringBuffer();
        try {
            CMExecutionContext ctx = CMExecutionContext.get();
            CMLockManagerContext.getContext();
            Date curDate = new Date();
            msgBuf.append("<").append("debug ");
            this.appendNameValue(msgBuf, "date", curDate.toString());
            this.appendNameValue(msgBuf, "context", String.valueOf(ctx.getId()));
            this.appendNameValue(msgBuf, "message", msg);
            msgBuf.append("/>\n");
            OutputStreamWriter outputStreamWriter = lockManagerLog_;
            synchronized (outputStreamWriter) {
                lockManagerLog_.write(msgBuf.toString());
                lockManagerLog_.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e + ": Unable to log message: " + msgBuf.toString());
        }
    }
}

