/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.locking;

import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.CMLockManager;
import com.cognos.cm.locking.CMLockManagerContext;
import com.cognos.cm.locking.CMLockManagerState;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.util.RequestPasswordRemover;
import java.util.Iterator;

final class CMLockManagerScheduler {
    private static CMLockManagerScheduler singleton_ = new CMLockManagerScheduler();
    private static final String errMsgBeginCalledOnActiveThread = "CM LockManagerScheduler begin() called but thread is already active.";
    private static final String errMsgNoCMLockManagerContext = "Internal locking error or missing internal requestLocks/releaseLocks. An inactive Lock Manager thread is present in the Lock Manager scheduler.";
    private static int g_nCurrentExecutingThreadsCount = 0;
    public static boolean MAX_TOTAL_WAIT_ENABLED = true;
    public static long STARVATION_THRESHOLD = 300L;
    private static long nWakeups = 0L;
    private static long nWakeupsAvoided = 0L;
    private static long nMaxWaitsExceeded = 0L;
    private static long nWarningThreshold = 0L;

    public static synchronized void incrExecutingThreadsCount() {
        ++g_nCurrentExecutingThreadsCount;
    }

    public static synchronized void decrExecutingThreadsCount() {
        if (--g_nCurrentExecutingThreadsCount == 0) {
            nWarningThreshold = nMaxWaitsExceeded;
        } else if (g_nCurrentExecutingThreadsCount < 0) {
            g_nCurrentExecutingThreadsCount = 0;
            throw new IllegalStateException("decrementing executing threads below zero");
        }
    }

    public static int getExecutingThreadsCount() {
        return g_nCurrentExecutingThreadsCount;
    }

    CMLockManagerScheduler() {
    }

    public static CMLockManagerScheduler getInstance() {
        return singleton_;
    }

    public void enter(CMLockManagerContext ctx) throws CMException {
        if (CMIndicationGlobals.bLockManagerLogDebug) {
            this.logState("CMLockManagerScheduler.enter(" + ctx.getHandle() + ")");
        }
        if (!ctx.isValid()) {
            throw new RuntimeException(errMsgBeginCalledOnActiveThread);
        }
        ctx.resetTimers();
        ctx.startExecuteTimer();
        ctx.setState(CMLockManagerState.EXECUTING);
        boolean bEligibleForSuspensionOnEntry = this.eligibleForSuspensionOnEntry(ctx);
        if (bEligibleForSuspensionOnEntry) {
            this.suspendCurrentThread(ctx);
        }
    }

    public void exit(CMLockManagerContext ctx) {
        ctx.stopExecuteTimer();
        ctx.stopAcquiredTimer();
        this.warnIfMaxExecutionTimeExceeded(ctx);
        ctx.setState(CMLockManagerState.INACTIVE);
        if (!ctx.isReleased() && CMLockManager.DebugToConsole()) {
            StringBuffer sb = new StringBuffer(500);
            ctx.toPerfConsole(sb);
            System.out.println("LM: exit scheduler without releasing context: " + sb.toString());
        }
        ctx.reset();
        if (CMIndicationGlobals.bLockManagerLogDebug) {
            this.logState("CMLockManagerScheduler.exit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendCurrentThread(CMLockManagerContext ctx) throws CMException {
        Thread.currentThread();
        if (!ctx.isValid()) {
            RuntimeException ex = new RuntimeException(errMsgNoCMLockManagerContext);
            throw ex;
        }
        boolean bEligibleForSuspension = this.eligibleForSuspension(ctx);
        if (!bEligibleForSuspension) {
            return;
        }
        if (CMIndicationGlobals.bLockManagerLogDebug) {
            this.logState("suspendCurrentThread-enter");
        }
        ctx.setState(CMLockManagerState.WAITING);
        try {
            this.throwIfMaxWaitExceeded(ctx);
            ctx.suspend(AdvancedSettings.LOCKRETRYINTERVAL);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            ctx.setState(CMLockManagerState.EXECUTING);
        }
        if (CMIndicationGlobals.bLockManagerLogDebug) {
            this.logState("suspendCurrentThread-exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throwIfMaxWaitExceeded(CMLockManagerContext ctx) throws CMException {
        if (MAX_TOTAL_WAIT_ENABLED && ctx.getTimeWaited() > (long)AdvancedSettings.MAXLOCKWAIT) {
            Class<CMLockManagerScheduler> clazz = CMLockManagerScheduler.class;
            synchronized (CMLockManagerScheduler.class) {
                ++nMaxWaitsExceeded;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                CMException ex = new CMException("cmLockWaitExceeded", new CMException.Parm("Value", ctx.getTimeWaitedString()), new CMException.Parm("State", ""));
                this.logStateValueException("cmLockWaitExceeded", ctx.getTimeWaitedString());
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void warnIfMaxExecutionTimeExceeded(CMLockManagerContext ctx) {
        long executionTime = ctx.getTimeExecuted() - ctx.getTicksWaited();
        if (!MAX_TOTAL_WAIT_ENABLED || executionTime <= (long)AdvancedSettings.MAXLOCKWAIT) return;
        boolean bIssueWarning = false;
        Class<CMLockManagerScheduler> clazz = CMLockManagerScheduler.class;
        synchronized (CMLockManagerScheduler.class) {
            if (nMaxWaitsExceeded > nWarningThreshold) {
                bIssueWarning = true;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (!bIssueWarning) return;
            CMExecutionContext execCtx = CMExecutionContext.get();
            StringBuffer sb = new StringBuffer();
            sb.append("\nContext:\n");
            sb.append(ctx.toString());
            sb.append("\nState:\n");
            sb.append(CMLockManagerScheduler.state());
            String soapRequest = RequestPasswordRemover.filterOutPassword(execCtx.getSOAPRequest());
            if (soapRequest != null) {
                sb.append("\nRequest:\n");
                sb.append(soapRequest);
            }
            CMException ex = new CMException("cmLockExecuteExceeded", new CMException.Parm("Value", ctx.getTimeExecutedString()), new CMException.Parm("State", sb.toString()));
            String msg = ex.getLocalizedMessage(ex);
            CMIndications.logException(ex, msg);
            return;
        }
    }

    private boolean eligibleForSuspensionOnEntry(CMLockManagerContext ctx) {
        return false;
    }

    private boolean eligibleForSuspension(CMLockManagerContext ctx) throws CMException {
        boolean bRet = false;
        bRet = CMLockManagerScheduler.getExecutingThreadsCount() > 1;
        return bRet;
    }

    public static String state() {
        StringBuffer buf = new StringBuffer();
        CMLockManagerScheduler.state(buf);
        return buf.toString();
    }

    protected static void state(StringBuffer buf) {
        Iterator<CMLockManagerContext> iter = CMLockManagerContext.getContextIterator();
        while (iter.hasNext()) {
            CMLockManagerContext ctx = iter.next();
            buf.append("  ");
            buf.append(ctx.toString());
            buf.append("\n");
        }
        if (buf.length() == 0) {
            buf.append("(no active contexts)");
        }
    }

    public static StringBuffer toPerfConsole(StringBuffer sb) {
        long nTotalContexts = CMLockManagerContext.getTotalContextsCreatedCount();
        long nTotalCoarseContexts = CMLockManagerContext.getTotalCoarseContextsCreatedCount();
        long nCoarseRatio = 0L;
        if (nTotalContexts != 0L) {
            nCoarseRatio = nTotalCoarseContexts * 100L / nTotalContexts;
        }
        long nWakeupsTotal = nWakeups + nWakeupsAvoided;
        long nWakeupAvoidedRatio = 0L;
        if (nWakeupsTotal != 0L) {
            nWakeupAvoidedRatio = nWakeupsAvoided * 100L / nWakeupsTotal;
        }
        sb.append(CMLockManagerContext.getContextCount()).append(" current contexts (");
        sb.append(nTotalContexts).append(" created ");
        sb.append(nCoarseRatio);
        sb.append("% coarse)");
        sb.append(" wakeups=").append(nWakeups).append("/").append(nWakeupsTotal);
        sb.append(" (").append(nWakeupAvoidedRatio).append("% avoided)");
        sb.append("\n");
        Iterator<CMLockManagerContext> iter = CMLockManagerContext.getContextIterator();
        while (iter.hasNext()) {
            CMLockManagerContext ctx = iter.next();
            sb.append("  ");
            ctx.toPerfConsole(sb);
            sb.append("\n");
        }
        return sb;
    }

    public void printState() {
        System.err.println(CMLockManagerScheduler.state());
    }

    private void logState(String context) {
        String state = null;
        state = CMLockManagerScheduler.state();
        CMException.Parm ctxParam = new CMException.Parm("Context", context);
        CMException.Parm stateParam = new CMException.Parm("State", state);
        CMIndications.CMTrace("cmLockManagerSchedulerState", ctxParam, stateParam);
    }

    private void logStateValueException(String code, String value) {
        try {
            CMException logEx = new CMException("cmLockWaitExceeded", new CMException.Parm("Value", value), new CMException.Parm("State", CMLockManagerScheduler.state()));
            String msg = logEx.getLocalizedMessage(logEx);
            CMIndications.logException(logEx, msg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

