/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.locking;

import com.cognos.cm.cache.CMCacheJavaImpl;
import com.cognos.cm.cache.CacheAccessMan;
import com.cognos.cm.cache.CacheLockHandlerJavaImpl;
import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.cache.ICacheLockHandler;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.query.CacheQuery;
import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.locking.AbstractLockHandler;
import com.cognos.cm.locking.CMLockHandlerDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMCacheQueryInstanceJavaImpl;
import com.cognos.perfMonitor.PerfCounter;
import com.cognos.perfMonitor.PerfMonitor;
import java.util.HashMap;
import java.util.Map;

public class LockHandlerJavaImpl
extends AbstractLockHandler {
    public static final Counter lockAcquire = new AccumulatingCounter().makeThreadLocal();
    private static final Timer lockAcquireTimer = new Timer(lockAcquire);
    public static final int LH_PARENTLOCKSACQUIRED_CHECKPARENTS = 3;
    private Map<Integer, LockHandlerCounter> counters = new HashMap<Integer, LockHandlerCounter>();

    public LockHandlerJavaImpl() {
        this.addCounter(3, "exclusive");
        this.addCounter(6, "childMutex");
        this.addCounter(4, "exclusiveParent");
        this.addCounter(7, "parentChildMutex");
        this.addCounter(0, "shared");
        this.addCounter(1, "sharedDescendant");
        this.addCounter(2, "sharedExclusiveDescendant");
    }

    private void addCounter(int lockKey, String name) {
        this.counters.put(lockKey, new LockHandlerCounter(name));
    }

    @Override
    public int LMAcquireLocks(String cacheQuery, int lockType, int iHandle) throws CMLockHandlerDenied, CMCacheException {
        int iQueryHandle = -1;
        String strQuery = null;
        CacheQuery query2 = null;
        strQuery = cacheQuery;
        if (strQuery == null) {
            throw new CMCacheException("Unknown CMLockHandle LMAcquireLocks in Query, before allocating query (2).");
        }
        iQueryHandle = CMCacheJavaImpl.gblCache.query(strQuery, 0, iHandle, lockType, this.getSecurityManager());
        query2 = (CacheQuery)CMCacheJavaImpl.gblCache.getQuery(iQueryHandle);
        lockAcquireTimer.start();
        boolean success = false;
        try {
            if (iQueryHandle >= 0 && query2 != null) {
                query2.Parse(strQuery, null, 0);
            }
            this.getLockHandlerCounter(lockType).requested();
            this.getGlobalLockHandler().acquireLocks(iHandle, query2.getResults(), lockType, 3);
            success = true;
        }
        catch (CMLockHandlerDenied ex) {
            this.getLockHandlerCounter(lockType).denied();
            throw ex;
        }
        finally {
            if (!success) {
                CMCacheJavaImpl.gblCache.releaseQueryHandle(iQueryHandle);
            }
            lockAcquireTimer.stop();
        }
        CMCacheJavaImpl.gblCache.endCacheRead();
        return iQueryHandle;
    }

    private ICacheAccessMan getSecurityManager() {
        return new CacheAccessMan(CMCacheJavaImpl.gblCache, CMCacheJavaImpl.gblCache.getAAAProvider());
    }

    LockHandlerCounter getLockHandlerCounter(int lockType) {
        return this.counters.get(lockType);
    }

    @Override
    public int LMAcquireLocks(int[] object_ids, int lockType, int iHandle) throws CMLockHandlerDenied, CMCacheException {
        int[] pObjects = null;
        int iNumObjects = 0;
        if (object_ids != null) {
            iNumObjects = object_ids.length;
            pObjects = object_ids;
        }
        lockAcquireTimer.start();
        try {
            this.getLockHandlerCounter(lockType).requested();
            this.getGlobalLockHandler().acquireLocks(iHandle, pObjects, iNumObjects, lockType, 3);
        }
        catch (CMLockHandlerDenied ex) {
            this.getLockHandlerCounter(lockType).denied();
            throw ex;
        }
        finally {
            lockAcquireTimer.stop();
        }
        return -1;
    }

    @Override
    public int LMAcquireLocks(Iterable<CacheEntry> entries, int lockType, int iHandle) throws CMLockHandlerDenied, CMCacheException {
        lockAcquireTimer.start();
        try {
            this.getLockHandlerCounter(lockType).requested();
            this.getGlobalLockHandler().acquireLocks(iHandle, entries, lockType);
        }
        catch (CMLockHandlerDenied ex) {
            this.getLockHandlerCounter(lockType).denied();
            throw ex;
        }
        finally {
            lockAcquireTimer.stop();
        }
        return -1;
    }

    @Override
    public synchronized int LMAllocateHandle() throws CMLockHandlerDenied, CMCacheException {
        return this.getGlobalLockHandler().allocateHandle();
    }

    @Override
    public void LMFinishedProtectedMutex(int iHandle) throws CMLockHandlerDenied, CMCacheException {
        this.getGlobalLockHandler().finishedProtectedMutex(iHandle);
    }

    @Override
    public boolean LMHasExclusiveLocks(int iHandle) throws CMCacheException {
        return this.getGlobalLockHandler().hasExclLocks(iHandle);
    }

    @Override
    public int LMInitialize(boolean bEnableLogging) throws CMLockHandlerDenied, CMCacheException {
        this.getGlobalLockHandler().initialize(this, bEnableLogging);
        return 0;
    }

    @Override
    public synchronized void LMReleaseAllLocks(int iHandle) throws CMLockHandlerDenied, CMCacheException {
        this.getGlobalLockHandler().releaseAllLocks(iHandle);
    }

    @Override
    public synchronized void LMReleaseHandle(int iHandle) throws CMLockHandlerDenied, CMCacheException {
        this.getGlobalLockHandler().releaseHandle(iHandle);
    }

    ICacheLockHandler getGlobalLockHandler() {
        return CacheLockHandlerJavaImpl.getGlobalLockHandler();
    }

    @Override
    public CMCacheQueryInstance getCacheQueryInstance(int queryHandle) {
        return CMCacheQueryInstanceJavaImpl.getInstance(queryHandle);
    }

    public void setGlobalLockHandler(ICacheLockHandler mock) {
        CacheLockHandlerJavaImpl.setGlobalLockHandler(mock);
    }

    class LockHandlerCounter {
        private PerfCounter requested;
        private PerfCounter denied;
        private String name;

        public LockHandlerCounter(String name) {
            this.name = name;
            this.requested = PerfMonitor.getCounter((String)("com.cognos.cm.locking.requested." + name), (String)("The number of " + name + " locks requested"), (int)6);
            this.denied = PerfMonitor.getCounter((String)("com.cognos.cm.locking.denied." + name), (String)("The number of " + name + " locks denied"), (int)6);
        }

        public void requested() {
            this.requested.incr();
        }

        public void denied() {
            this.denied.incr();
        }

        String getName() {
            return this.name;
        }

        PerfCounter getRequestedCounter() {
            return this.requested;
        }

        PerfCounter getDeniedCounter() {
            return this.denied;
        }
    }
}

