/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.maintenancePluginTasks;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMMaintenancePluginTask;
import com.cognos.cm.server.CMMaintenanceTaskData;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cmutils.xml.XMLUtils;
import java.util.ArrayList;
import java.util.List;

public class AddAliasRoots
extends CMMaintenancePluginTask {
    private CMMaintenanceTaskData data_;
    private List<String> searchPathsToAdd_;
    private List<IConfiguration.AliasRoot> aliasRoots_ = null;

    @Override
    public void initialize(CMMaintenanceTaskData data) {
        this.data_ = data;
    }

    @Override
    public void invoke() throws CMException {
        IConfiguration config = ConfigurationFactory.getConfig();
        this.aliasRoots_ = config.getAliasRoots();
        if (this.aliasRoots_ == null) {
            CMIndications.CMTrace("cmAliasRootsNotConfigured");
            return;
        }
        this.searchPathsToAdd_ = this.data_.getSearchPaths();
        this.addAliasRoots();
    }

    private void addAliasRoots() throws CMException {
        for (String sp : this.searchPathsToAdd_) {
            this.add(sp);
        }
    }

    private void add(String searchPath) throws CMException {
        String addRequest = CMDataUpgradeUtils.buildAdd(searchPath, "aliasRoot", this.getObjectsAndProperties());
        String response = ContentManager.getInstance().ExecuteStaticRequest(addRequest, false, true);
        if (response == null) {
            throw new CMException("Failed to add AliasRoot. No response.");
        }
        if (response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new CMException("Failed to add AliasRoot objects:\n" + response);
        }
    }

    private List<String> getObjectsAndProperties() {
        ArrayList<String> objs = new ArrayList<String>();
        for (IConfiguration.AliasRoot root : this.aliasRoots_) {
            String escapedWinURI = XMLUtils.escape((String)root.getWindowsURI());
            String escapedUnixURI = XMLUtils.escape((String)root.getUnixURI());
            String escapedName = XMLUtils.escape((String)root.getName());
            StringBuilder strBuf = new StringBuilder();
            strBuf.append("          <defaultName xsi:type=\"bus:stringProp\">\n").append("            <value xsi:type=\"xsd:string\">").append(escapedName).append("</value>\n").append("          </defaultName>\n").append("          <windowsURI xsi:type=\"cm:anyURIProp\">\n").append("            <value xsi:type=\"xsd:string\" xml:space=\"preserve\">").append(escapedWinURI).append("</value>\n").append("          </windowsURI>\n").append("          <unixURI xsi:type=\"cm:anyURIProp\">\n").append("            <value xsi:type=\"xsd:string\" xml:space=\"preserve\">").append(escapedUnixURI).append("</value>\n").append("          </unixURI>\n");
            objs.add(strBuf.toString());
        }
        return objs;
    }
}

