/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.maintenanceTasks;

import com.cognos.cm.dbstore.CMDbStoreIDReferencesUtil;
import com.cognos.cm.dbstore.StubFolder;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.maintenanceTasks.CMMaintenanceTask;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;

public class CMMaintenanceTaskCleanDeletedObjects
implements CMMaintenanceTask {
    private boolean isCompleted_;

    @Override
    public boolean isCompleted() {
        return this.isCompleted_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CMStore store = null;
        try {
            CMExecutionContext.setUp();
            CMExecutionContext ctx = CMExecutionContext.get();
            ctx.setRequestContext("CleanDeletedObjects_REQ");
            ctx.setSessionContext("CleanDeletedObjects_SESS");
            store = ctx.getStore();
            store.beginTransaction();
            CMDbStoreIDReferencesUtil helper = new CMDbStoreIDReferencesUtil();
            int[] objectIDs = helper.getUnreferencedObjects(store, CMObjectClass._DELETEDOBJECT);
            StubFolder.deleteObjects(store, objectIDs);
            store.commitTransaction();
        }
        catch (CMException ex) {
            CMIndications.logException(new CMException(ex, "cmFailedCleanDeletedObjects"));
        }
        finally {
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception ex) {
                    CMIndications.logException(ex);
                }
            }
            this.releaseLocks(store);
            CMExecutionContext.tearDown();
        }
    }

    private void releaseLocks(CMStore store) {
        try {
            store.getLockManager().releaseLocks();
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
    }
}

