/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.maintenanceTasks;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.maintenanceTasks.CMMaintenanceTask;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.delete;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cmutils.date.DateUtils;
import java.sql.Timestamp;
import java.util.ArrayList;

public class CMMaintenanceTaskDeleteOldSessions
implements CMMaintenanceTask {
    private ArrayList oldSessions_;
    private boolean isCompleted_ = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMMaintenanceTaskDeleteOldSessions() throws CMException {
        Timestamp startTime = new Timestamp(DateUtils.getUTCTime());
        CMStoreQueryResults results = null;
        CMStore store = null;
        try {
            store = CMExecutionContext.get().getStore();
        }
        catch (CMStoreNotAvailable e) {
            return;
        }
        catch (CMStoreUnexpected e) {
            return;
        }
        if (store == null) {
            return;
        }
        ICMLockManager lockMgr = store.getLockManager();
        CMStorePath userPath = null;
        String sTime = CMDateUtils.getIsoDate(startTime);
        userPath = CMStoreXPath.parse("/directory//account/session[@creationTime < '" + sTime + "']");
        CMProperty[] props = new CMProperty[]{CMProperty.SEARCHPATH};
        this.oldSessions_ = new ArrayList();
        try {
            results = store.executeQuery(userPath, props, null, 0, 8704, null);
            while (results.next()) {
                this.oldSessions_.add(results.getValue(0).toString());
            }
        }
        finally {
            if (results != null) {
                results.release();
                results = null;
            }
            lockMgr.releaseLocks();
        }
        userPath = CMStoreXPath.parse("/directory//account/folder[@defaultName='Sessions']/session[@creationTime < '" + sTime + "']");
        try {
            results = store.executeQuery(userPath, props, null, 0, 8704, null);
            while (results.next()) {
                this.oldSessions_.add(results.getValue(0).toString());
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            lockMgr.releaseLocks();
            store.release();
        }
    }

    @Override
    public boolean isCompleted() {
        return this.isCompleted_;
    }

    @Override
    public void run() {
        try {
            CMExecutionContext.setUp();
            CMExecutionContext ctx = CMExecutionContext.get();
            ctx.setRequestContext("DeleteOldSessions_REQ");
            ctx.setSessionContext("DeleteOldSessions_SESS");
            this.deleteOldSessions();
        }
        catch (CMException ex) {
            CMIndications.logException(new CMException(ex, "cmErrCleanSessions"));
        }
        finally {
            CMExecutionContext.tearDown();
        }
        this.isCompleted_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOldSessions() throws CMException {
        int objectCount = 0;
        CMStoreQueryResults results = null;
        CMStore store = null;
        try {
            store = CMExecutionContext.get().getStore();
        }
        catch (CMStoreNotAvailable e) {
            return;
        }
        catch (CMStoreUnexpected e) {
            return;
        }
        if (store == null) {
            return;
        }
        ICMLockManager lockMgr = store.getLockManager();
        for (int i = 0; i < this.oldSessions_.size(); ++i) {
            CMStoreXPath userPath = new CMStoreXPath(null, (String)this.oldSessions_.get(i), false);
            userPath.setLockManagerUsageFlag(15);
            CMProperty[] props = new CMProperty[]{CMProperty.OBJECTCLASS};
            try {
                lockMgr.requestLocks(userPath);
                store.beginTransaction();
                results = store.executeQuery(userPath, props, null, 0, 512, null);
                while (results.next()) {
                }
                results.reset();
                while (results.next()) {
                    String path = results.getSearchPath();
                    objectCount += delete.deleteDescendants(store, path, 512, false);
                }
                store.commitTransaction();
                continue;
            }
            catch (CMException ex) {
                CMIndications.logException(new CMException((Exception)ex, "cmErrCleanSessionObject", new CMException.Parm("SearchPath", userPath)));
                continue;
            }
            finally {
                if (results != null) {
                    results.release();
                }
                lockMgr.releaseLocks();
                if (store.inTransaction()) {
                    try {
                        store.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.oldSessions_ = null;
        CMIndications.CMTrace("cmDeletedOldSessions", new CMException.Parm("Count", Integer.toString(objectCount)));
    }
}

