/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.maintenanceTasks;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.maintenanceTasks.CMMaintenanceTask;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import java.util.ArrayList;

public class CMMaintenanceTaskUpdateDeploymentStatus
implements CMMaintenanceTask {
    ArrayList deploymentHistories_ = null;
    private boolean isCompleted_ = false;
    private final String ImportDeploymentHistoryQueryStr_ = "/" + CMObjectClass.ADMINFOLDER.getName() + "/" + "/" + CMObjectClass.IMPORTDEPLOYMENT.getName() + "/" + CMObjectClass.HISTORY.getName();
    private final String ExportDeploymentHistoryQueryStr_ = "/" + CMObjectClass.ADMINFOLDER.getName() + "/" + "/" + CMObjectClass.EXPORTDEPLOYMENT.getName() + "/" + CMObjectClass.HISTORY.getName();

    @Override
    public boolean isCompleted() {
        return this.isCompleted_;
    }

    @Override
    public void run() {
        try {
            CMExecutionContext.setUp();
            CMExecutionContext ctx = CMExecutionContext.get();
            ctx.setRequestContext("DeleteOldSessions_REQ");
            ctx.setSessionContext("DeleteOldSessions_SESS");
            this.queryDeploymentStatus();
            this.updateDeploymentStatus();
        }
        catch (CMException ex) {
            CMIndications.logException(new CMException(ex, "cmFailedUpdateDeployStatus"));
        }
        finally {
            CMExecutionContext.tearDown();
        }
        this.isCompleted_ = true;
    }

    private void queryDeploymentStatus() throws CMException {
        boolean locked = false;
        CMStoreQueryResults results = null;
        CMStore store = CMExecutionContext.get().getStore();
        ICMLockManager lockMgr = store.getLockManager();
        try {
            CMStoreXPath importQueryPath = new CMStoreXPath(this.ImportDeploymentHistoryQueryStr_);
            importQueryPath.clearLocksHaveBeenObtained();
            importQueryPath.setLockManagerUsageFlag(10);
            lockMgr.requestLocks(importQueryPath);
            locked = true;
            CMProperty[] props = new CMProperty[]{CMProperty.SEARCHPATH, CMProperty.STATUS};
            results = store.executeQuery(importQueryPath, props, null, 0, 512, null);
            while (results.next()) {
                String status;
                if (results.getValue(1) == null || !(status = results.getValue(1).toString()).equals("executing")) continue;
                if (this.deploymentHistories_ == null) {
                    this.deploymentHistories_ = new ArrayList();
                }
                this.deploymentHistories_.add(results.getValue(0).toString());
            }
            results.release();
            results = null;
            CMStoreXPath exportQueryPath = new CMStoreXPath(this.ExportDeploymentHistoryQueryStr_);
            exportQueryPath.clearLocksHaveBeenObtained();
            exportQueryPath.setLockManagerUsageFlag(10);
            lockMgr.requestLocks(exportQueryPath);
            results = store.executeQuery(exportQueryPath, props, null, 0, 512, null);
            while (results.next()) {
                String status;
                if (results.getValue(1) == null || !(status = results.getValue(1).toString()).equals("executing")) continue;
                if (this.deploymentHistories_ == null) {
                    this.deploymentHistories_ = new ArrayList();
                }
                this.deploymentHistories_.add(results.getValue(0).toString());
            }
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedQueryDeployStatus");
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (locked) {
                lockMgr.releaseLocks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeploymentStatus() throws CMException {
        if (this.deploymentHistories_ == null || this.deploymentHistories_.isEmpty()) {
            return;
        }
        CMStore store = CMExecutionContext.get().getStore();
        ICMLockManager lockMgr = store.getLockManager();
        CMStoreQueryResults results = null;
        boolean locked = false;
        String searchPath = null;
        CMStoreXPath deployHistoryStorePath = null;
        for (int i = 0; i < this.deploymentHistories_.size(); ++i) {
            searchPath = (String)this.deploymentHistories_.get(i);
            deployHistoryStorePath = new CMStoreXPath(searchPath);
            try {
                deployHistoryStorePath.clearLocksHaveBeenObtained();
                deployHistoryStorePath.setLockManagerUsageFlag(13);
                lockMgr.requestLocks(deployHistoryStorePath);
                locked = true;
                store.beginTransaction();
                results = store.executeQuery(deployHistoryStorePath, null, null, 7, 2, null);
                if (!results.next()) {
                    throw new CMStoreObjectNotFound();
                }
                results.reset();
                ArrayList<CMProperty> propNames = new ArrayList<CMProperty>();
                ArrayList<Object> propValues = new ArrayList<Object>();
                propNames.add(CMProperty.STATUS);
                propValues.add("failed");
                store.update(results, propNames, propValues);
                store.commitTransaction();
                continue;
            }
            catch (CMStoreObjectNotFound ex) {
                CMIndications.logException(new CMException("cmMissingDeployHistory", new CMException.Parm("path", searchPath)));
                continue;
            }
            catch (Exception e) {
                CMIndications.logException(new CMException(e, "cmFailedUpdateDeployStatus"));
                continue;
            }
            finally {
                if (results != null) {
                    results.release();
                }
                if (store.inTransaction()) {
                    try {
                        store.rollbackTransaction();
                    }
                    catch (Exception ex) {
                        CMIndications.logException(new CMException(ex, "cmFailedToRollbackUpdate"));
                    }
                }
                if (locked) {
                    lockMgr.releaseLocks();
                }
            }
        }
        this.deploymentHistories_ = null;
    }
}

