/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.maintenanceTasks;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.maintenanceTasks.CMMaintenanceTask;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.AdvancedSettingsObserver;
import com.cognos.cm.server.CMException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CMMaintenanceThread
extends Thread
implements AdvancedSettingsObserver {
    HashMap tasks_;
    private boolean terminate_ = false;
    private long maintenanceWaitTime_ = AdvancedSettings.CMMAINTENANCEWAITTIME;

    public CMMaintenanceThread() {
        super("CRN.CM.MaintenanceThread");
        this.tasks_ = new HashMap();
        AdvancedSettings.addObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(String taskName, CMMaintenanceTask task) {
        HashMap hashMap = this.tasks_;
        synchronized (hashMap) {
            this.tasks_.put(taskName, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(String taskName) {
        HashMap hashMap = this.tasks_;
        synchronized (hashMap) {
            this.tasks_.remove(taskName);
        }
    }

    public synchronized void runNow() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSettings() {
        if (this.maintenanceWaitTime_ != AdvancedSettings.CMMAINTENANCEWAITTIME) {
            this.maintenanceWaitTime_ = AdvancedSettings.CMMAINTENANCEWAITTIME;
            CMMaintenanceThread cMMaintenanceThread = this;
            synchronized (cMMaintenanceThread) {
                this.notify();
            }
        }
    }

    public synchronized void terminate() {
        this.terminate_ = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.terminate_ = false;
        do {
            this.executeTasks();
            CMMaintenanceThread cMMaintenanceThread = this;
            synchronized (cMMaintenanceThread) {
                try {
                    this.wait(this.maintenanceWaitTime_ * 60000L);
                }
                catch (InterruptedException ex) {
                    this.terminate_ = true;
                }
            }
        } while (!this.terminate_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTasks() {
        HashMap currentTasks = new HashMap();
        HashMap hashMap = this.tasks_;
        synchronized (hashMap) {
            ArrayList tasksToDelete = new ArrayList();
            Set entryTasks = this.tasks_.entrySet();
            for (Map.Entry taskEntry : entryTasks) {
                CMMaintenanceTask task = (CMMaintenanceTask)taskEntry.getValue();
                if (task.isCompleted()) {
                    tasksToDelete.add(taskEntry.getKey());
                    continue;
                }
                currentTasks.put(taskEntry.getKey(), task);
            }
            for (int i = 0; i < tasksToDelete.size(); ++i) {
                this.tasks_.remove(tasksToDelete.get(i));
            }
        }
        Set entryTasks = currentTasks.entrySet();
        Iterator iter = entryTasks.iterator();
        while (iter.hasNext() && !this.terminate_) {
            Map.Entry taskEntry = iter.next();
            CMMaintenanceTask task = (CMMaintenanceTask)taskEntry.getValue();
            try {
                task.run();
            }
            catch (Throwable ex) {
                CMIndications.logException(new CMException(ex, "cmFailedExecuteMaintenanceTask", new CMException.Parm("name", (String)taskEntry.getKey())));
            }
        }
    }
}

