/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class Base64 {
    private static final byte[] S_BASE64CHAR;
    private static final char S_BASE64PAD = '=';
    private static final byte[] S_DECODETABLE;
    private static final byte[] W_BASE64CHAR;
    private static final char W_BASE64PAD = '_';
    private static final byte[] W_DECODETABLE;

    private static int decode0(byte[] ibuf, byte[] obuf, int wp, boolean web64) {
        byte b3;
        byte b2;
        byte b1;
        byte b0;
        int outlen = 3;
        if (web64) {
            if (ibuf[3] == 95) {
                outlen = 2;
            }
            if (ibuf[2] == 95) {
                outlen = 1;
            }
            b0 = W_DECODETABLE[ibuf[0]];
            b1 = W_DECODETABLE[ibuf[1]];
            b2 = W_DECODETABLE[ibuf[2]];
            b3 = W_DECODETABLE[ibuf[3]];
        } else {
            if (ibuf[3] == 61) {
                outlen = 2;
            }
            if (ibuf[2] == 61) {
                outlen = 1;
            }
            b0 = S_DECODETABLE[ibuf[0]];
            b1 = S_DECODETABLE[ibuf[1]];
            b2 = S_DECODETABLE[ibuf[2]];
            b3 = S_DECODETABLE[ibuf[3]];
        }
        switch (outlen) {
            case 1: {
                obuf[wp] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                return 1;
            }
            case 2: {
                obuf[wp++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                obuf[wp] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                return 2;
            }
            case 3: {
                obuf[wp++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                obuf[wp++] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                obuf[wp] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
                return 3;
            }
        }
        throw new RuntimeException("Internal Errror");
    }

    public static byte[] decode(byte[] data, int off, int len) {
        return Base64.decode(data, off, len, false);
    }

    public static byte[] decode(byte[] data, int off, int len, boolean web64) {
        byte[] DECODETABLE;
        byte PAD;
        byte[] ibuf = new byte[4];
        int ibufcount = 0;
        byte[] obuf = new byte[len / 4 * 3 + 3];
        int obufcount = 0;
        if (web64) {
            PAD = 95;
            DECODETABLE = W_DECODETABLE;
        } else {
            PAD = 61;
            DECODETABLE = S_DECODETABLE;
        }
        for (int i = off; i < off + len; ++i) {
            byte ch = data[i];
            if (ch != PAD && (ch >= DECODETABLE.length || DECODETABLE[ch] == 127)) continue;
            ibuf[ibufcount++] = ch;
            if (ibufcount != ibuf.length) continue;
            ibufcount = 0;
            obufcount += Base64.decode0(ibuf, obuf, obufcount, web64);
        }
        if (obufcount == obuf.length) {
            return obuf;
        }
        byte[] ret = new byte[obufcount];
        System.arraycopy(obuf, 0, ret, 0, obufcount);
        return ret;
    }

    public static byte[] decode(String data) {
        byte[] ibuf = new byte[4];
        int ibufcount = 0;
        byte[] obuf = new byte[data.length() / 4 * 3 + 3];
        int obufcount = 0;
        for (int i = 0; i < data.length(); ++i) {
            byte ch = (byte)data.charAt(i);
            if (ch != 61 && (ch >= S_DECODETABLE.length || S_DECODETABLE[ch] == 127)) continue;
            ibuf[ibufcount++] = ch;
            if (ibufcount != ibuf.length) continue;
            ibufcount = 0;
            obufcount += Base64.decode0(ibuf, obuf, obufcount, false);
        }
        if (obufcount == obuf.length) {
            return obuf;
        }
        byte[] ret = new byte[obufcount];
        System.arraycopy(obuf, 0, ret, 0, obufcount);
        return ret;
    }

    public static void decode(byte[] data, int off, int len, OutputStream ostream) throws IOException {
        byte[] ibuf = new byte[4];
        int ibufcount = 0;
        byte[] obuf = new byte[3];
        for (int i = off; i < off + len; ++i) {
            byte ch = data[i];
            if (ch != 61 && (ch >= S_DECODETABLE.length || S_DECODETABLE[ch] == 127)) continue;
            ibuf[ibufcount++] = ch;
            if (ibufcount != ibuf.length) continue;
            ibufcount = 0;
            int obufcount = Base64.decode0(ibuf, obuf, 0, false);
            ostream.write(obuf, 0, obufcount);
        }
    }

    public static void decode(String data, OutputStream ostream) throws IOException {
        byte[] ibuf = new byte[4];
        int ibufcount = 0;
        byte[] obuf = new byte[3];
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch != '=' && (ch >= S_DECODETABLE.length || S_DECODETABLE[ch] == 127)) continue;
            ibuf[ibufcount++] = (byte)ch;
            if (ibufcount != ibuf.length) continue;
            ibufcount = 0;
            int obufcount = Base64.decode0(ibuf, obuf, 0, false);
            ostream.write(obuf, 0, obufcount);
        }
    }

    public static void decode(char[] data, int off, int len, OutputStream ostream) throws IOException {
        byte[] ibuf = new byte[4];
        int ibufcount = 0;
        byte[] obuf = new byte[3];
        for (int i = off; i < off + len; ++i) {
            char ch = data[i];
            if (ch != '=' && (ch >= S_DECODETABLE.length || S_DECODETABLE[ch] == 127)) continue;
            ibuf[ibufcount++] = (byte)ch;
            if (ibufcount != ibuf.length) continue;
            ibufcount = 0;
            int obufcount = Base64.decode0(ibuf, obuf, 0, false);
            ostream.write(obuf, 0, obufcount);
        }
    }

    public static int getEncodedLength(int len) {
        return len / 3 * 4 + 4;
    }

    public static String encode(byte[] data) {
        return Base64.encode(data, 0, data.length, false);
    }

    public static String encode(byte[] data, int off, int len) {
        return Base64.encode(data, 0, data.length, false);
    }

    public static String encode(byte[] data, int off, int len, boolean web64) {
        int i;
        byte[] CHARTABLE;
        int PAD;
        if (len <= 0) {
            return "";
        }
        byte[] out = new byte[Base64.getEncodedLength(len)];
        int rindex = off;
        int windex = 0;
        int rest = len - off;
        if (web64) {
            PAD = 95;
            CHARTABLE = W_BASE64CHAR;
        } else {
            PAD = 61;
            CHARTABLE = S_BASE64CHAR;
        }
        while (rest >= 3) {
            i = ((data[rindex] & 0xFF) << 16) + ((data[rindex + 1] & 0xFF) << 8) + (data[rindex + 2] & 0xFF);
            out[windex++] = CHARTABLE[i >> 18];
            out[windex++] = CHARTABLE[i >> 12 & 0x3F];
            out[windex++] = CHARTABLE[i >> 6 & 0x3F];
            out[windex++] = CHARTABLE[i & 0x3F];
            rindex += 3;
            rest -= 3;
        }
        if (rest == 1) {
            i = data[rindex] & 0xFF;
            out[windex++] = CHARTABLE[i >> 2];
            out[windex++] = CHARTABLE[i << 4 & 0x3F];
            out[windex++] = PAD;
            out[windex++] = PAD;
        } else if (rest == 2) {
            i = ((data[rindex] & 0xFF) << 8) + (data[rindex + 1] & 0xFF);
            out[windex++] = CHARTABLE[i >> 10];
            out[windex++] = CHARTABLE[i >> 4 & 0x3F];
            out[windex++] = CHARTABLE[i << 2 & 0x3F];
            out[windex++] = PAD;
        }
        return new String(out, 0, windex);
    }

    public static void encode(byte[] data, int off, int len, OutputStream ostream) throws IOException {
        int i;
        int rest;
        if (len <= 0) {
            return;
        }
        byte[] out = new byte[4];
        int rindex = off;
        for (rest = len - off; rest >= 3; rest -= 3) {
            i = ((data[rindex] & 0xFF) << 16) + ((data[rindex + 1] & 0xFF) << 8) + (data[rindex + 2] & 0xFF);
            out[0] = S_BASE64CHAR[i >> 18];
            out[1] = S_BASE64CHAR[i >> 12 & 0x3F];
            out[2] = S_BASE64CHAR[i >> 6 & 0x3F];
            out[3] = S_BASE64CHAR[i & 0x3F];
            ostream.write(out, 0, 4);
            rindex += 3;
        }
        if (rest == 1) {
            i = data[rindex] & 0xFF;
            out[0] = S_BASE64CHAR[i >> 2];
            out[1] = S_BASE64CHAR[i << 4 & 0x3F];
            out[2] = 61;
            out[3] = 61;
            ostream.write(out, 0, 4);
        } else if (rest == 2) {
            i = ((data[rindex] & 0xFF) << 8) + (data[rindex + 1] & 0xFF);
            out[0] = S_BASE64CHAR[i >> 10];
            out[1] = S_BASE64CHAR[i >> 4 & 0x3F];
            out[2] = S_BASE64CHAR[i << 2 & 0x3F];
            out[3] = 61;
            ostream.write(out, 0, 4);
        }
    }

    public static void encode(byte[] data, int off, int len, Writer ostream) throws IOException {
        int i;
        int rest;
        if (len <= 0) {
            return;
        }
        char[] out = new char[4];
        int rindex = off;
        for (rest = len - off; rest >= 3; rest -= 3) {
            i = ((data[rindex] & 0xFF) << 16) + ((data[rindex + 1] & 0xFF) << 8) + (data[rindex + 2] & 0xFF);
            out[0] = (char)S_BASE64CHAR[i >> 18];
            out[1] = (char)S_BASE64CHAR[i >> 12 & 0x3F];
            out[2] = (char)S_BASE64CHAR[i >> 6 & 0x3F];
            out[3] = (char)S_BASE64CHAR[i & 0x3F];
            ostream.write(out, 0, 4);
            rindex += 3;
        }
        if (rest == 1) {
            i = data[rindex] & 0xFF;
            out[0] = (char)S_BASE64CHAR[i >> 2];
            out[1] = (char)S_BASE64CHAR[i << 4 & 0x3F];
            out[2] = 61;
            out[3] = 61;
            ostream.write(out, 0, 4);
        } else if (rest == 2) {
            i = ((data[rindex] & 0xFF) << 8) + (data[rindex + 1] & 0xFF);
            out[0] = (char)S_BASE64CHAR[i >> 10];
            out[1] = (char)S_BASE64CHAR[i >> 4 & 0x3F];
            out[2] = (char)S_BASE64CHAR[i << 2 & 0x3F];
            out[3] = 61;
            ostream.write(out, 0, 4);
        }
    }

    static {
        int i;
        S_BASE64CHAR = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        S_DECODETABLE = new byte[128];
        W_BASE64CHAR = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 45};
        W_DECODETABLE = new byte[128];
        for (i = 0; i < S_DECODETABLE.length; ++i) {
            Base64.S_DECODETABLE[i] = 127;
        }
        for (i = 0; i < S_BASE64CHAR.length; ++i) {
            Base64.S_DECODETABLE[Base64.S_BASE64CHAR[i]] = (byte)i;
        }
        for (i = 0; i < W_DECODETABLE.length; ++i) {
            Base64.W_DECODETABLE[i] = 127;
        }
        for (i = 0; i < W_BASE64CHAR.length; ++i) {
            Base64.W_DECODETABLE[Base64.W_BASE64CHAR[i]] = (byte)i;
        }
    }
}

