/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import com.cognos.cm.multipart.Base64;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class Base64DecodeWriter
extends Writer {
    private boolean closed_ = false;
    private OutputStream ostream_ = null;
    private char[] toWriteChars_ = new char[4];
    private int toWrite_ = 0;

    public Base64DecodeWriter(OutputStream os) {
        this.ostream_ = os;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int leftOverOff;
        int sendLen;
        if (this.closed_) {
            throw new IllegalStateException("CMTempOutputStream.write: file is closed");
        }
        int ending = off + len;
        if (this.toWrite_ > 0) {
            while (this.toWrite_ < 4 && off < ending) {
                this.toWriteChars_[this.toWrite_++] = cbuf[off++];
            }
            if (this.toWrite_ == 4) {
                Base64.decode(this.toWriteChars_, 0, 4, this.ostream_);
                this.toWrite_ = 0;
            }
        }
        if ((sendLen = (len = ending - off) / 4 * 4) > 0) {
            Base64.decode(cbuf, off, sendLen, this.ostream_);
        }
        if ((leftOverOff = ending - (sendLen + off)) > 0) {
            for (int i = 0; i < leftOverOff; ++i) {
                this.toWriteChars_[this.toWrite_++] = cbuf[off + sendLen + i];
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.ostream_ != null) {
            this.ostream_.flush();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.ostream_ != null) {
                this.ostream_.close();
            }
        }
        finally {
            this.closed_ = true;
        }
    }
}

