/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import com.cognos.cm.server.CMException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedPartInputStream
extends FilterInputStream {
    private byte[] boundary;
    private boolean eof;

    BufferedPartInputStream(InputStream in, String boundary) {
        super(in);
        this.boundary = boundary.getBytes();
        if (!in.markSupported()) {
            throw new IllegalArgumentException("InputStream " + in.getClass().getName() + " does not support mark/reset");
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.eof) {
            return -1;
        }
        int readLimit = b.length + this.boundary.length + 1;
        this.in.mark(readLimit);
        int read = this.in.read(b);
        if (read == -1) {
            CMException ex = new CMException("cmIOMIMEAttachEndMissing");
            throw new IOException(ex.getMessage());
        }
        read = this.findBoundary(b, read);
        return read;
    }

    private int findBoundary(byte[] b, int read) throws IOException {
        int boundaryStart = -1;
        int boundaryEnd = -1;
        int boundaryMatches = 0;
        boolean partialBoundary = false;
        for (int j = 0; j < read; ++j) {
            byte c = b[j];
            if (c != 10) continue;
            boundaryStart = j;
            int stopIdx = boundaryEnd = boundaryStart + this.boundary.length;
            if (boundaryEnd > read - 1) {
                stopIdx = read - 1;
                partialBoundary = true;
            }
            if (j > 0 && b[j - 1] == 13) {
                --boundaryStart;
            }
            ++j;
            int i = 0;
            while (j <= stopIdx) {
                if (this.boundary[i] != b[j]) {
                    boundaryStart = -1;
                    break;
                }
                ++boundaryMatches;
                ++i;
                ++j;
            }
            if (j > stopIdx) break;
        }
        read = boundaryStart != -1 ? (partialBoundary ? this.processPartialBoundary(read, boundaryStart, boundaryEnd, boundaryMatches) : this.processFullBoundary(boundaryStart, boundaryEnd)) : this.avoidCRLFSplit(b, read);
        return read;
    }

    private int avoidCRLFSplit(byte[] b, int read) throws IOException {
        if (b[read - 1] == 13) {
            int boundaryStart = read - 1;
            int boundaryEnd = boundaryStart + this.boundary.length;
            int nextByte = this.in.read();
            if (nextByte == -1) {
                this.eof = true;
            } else if (nextByte == 10) {
                read = this.processPartialBoundary(read, boundaryStart, ++boundaryEnd, 0);
            } else {
                this.resetAndSkip(read);
            }
        }
        return read;
    }

    private int processFullBoundary(int boundaryStart, int boundaryEnd) throws IOException {
        int read = boundaryStart;
        this.eof = true;
        this.resetAndSkip(boundaryEnd + 1);
        if (read == 0) {
            read = -1;
        }
        return read;
    }

    private int processPartialBoundary(int read, int boundaryStart, int boundaryEnd, int boundaryMatches) throws IOException {
        int nextByte;
        while (this.boundary.length - boundaryMatches > 0 && (nextByte = this.in.read()) != -1 && this.boundary[boundaryMatches] == nextByte) {
            ++boundaryMatches;
        }
        if (boundaryMatches == this.boundary.length) {
            read = this.processFullBoundary(boundaryStart, boundaryEnd);
        } else {
            this.resetAndSkip(read);
        }
        return read;
    }

    private void resetAndSkip(long numBytes) throws IOException {
        long skipped;
        if (numBytes == 0L) {
            return;
        }
        this.in.reset();
        do {
            if ((skipped = this.in.skip(numBytes)) > 0L) continue;
            throw new IllegalStateException("InputStream.skip(" + numBytes + ") returned " + skipped);
        } while ((numBytes -= skipped) > 0L);
    }

    @Override
    public void close() throws IOException {
        if (!this.eof) {
            byte[] b = new byte[4096];
            while (this.read(b) != -1) {
            }
        }
        this.eof = true;
    }
}

