/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import com.cognos.cm.server.CMException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ContentTypes {
    private Map<String, Entry> entries_ = new HashMap<String, Entry>();
    private static ContentTypes singleton_ = new ContentTypes();

    private ContentTypes() {
        this.addUncompressableMask("image/*");
        this.addUncompressableMask("application/zip");
        this.addUncompressableMask("application/x-zip-compressed");
        this.addUncompressableMask("application/pdf");
        this.addUncompressableMask("application/vnd.ibm.bi.pq");
    }

    public static Type getType(String contentType) throws CMException {
        return singleton_.internalGetType(contentType);
    }

    private Type internalGetType(String contentType) throws CMException {
        StringBuffer mediaBuf = new StringBuffer();
        StringBuffer subTypeBuf = new StringBuffer();
        ContentTypes.parseType(contentType, mediaBuf, subTypeBuf);
        String media = mediaBuf.toString();
        String subType = subTypeBuf.toString();
        if (media.length() > 0 && subType.length() > 0) {
            boolean compressable = true;
            Entry entry = this.entries_.get(media);
            if (entry != null) {
                compressable = !entry.includesSubType(subType);
            }
            return new Type(media + "/" + subType, compressable);
        }
        throw new CMException("cmIOMissingOrInvalidContentType");
    }

    private void addUncompressableMask(String contentTypeMask) {
        StringBuffer mediaBuf = new StringBuffer();
        StringBuffer subTypeBuf = new StringBuffer();
        ContentTypes.parseType(contentTypeMask, mediaBuf, subTypeBuf);
        String media = mediaBuf.toString();
        String subType = subTypeBuf.toString();
        if (media.length() > 0) {
            Entry entry = this.entries_.get(media);
            if (entry == null) {
                entry = new Entry();
                if (!subType.equals("*")) {
                    entry.subTypes_ = new ArrayList();
                    entry.subTypes_.add(subType);
                }
                this.entries_.put(media, entry);
            } else if (!entry.includesSubType(subType)) {
                if (!subType.equals("*")) {
                    entry.addSubType(subType);
                } else {
                    entry.subTypes_ = null;
                }
            }
        }
    }

    private static void parseType(String instr, StringBuffer mediaType, StringBuffer subType) {
        int sepPos = (instr = instr.trim()).indexOf("/");
        if (sepPos > 0) {
            mediaType.append(instr.substring(0, sepPos).toLowerCase());
            int endPos = instr.indexOf(";", sepPos + 1);
            if (endPos == -1) {
                endPos = instr.length();
            }
            subType.append(instr.substring(sepPos + 1, endPos).toLowerCase());
        }
    }

    private static class Entry {
        ArrayList<String> subTypes_;

        private Entry() {
        }

        boolean includesSubType(String subType) {
            int stIdx;
            if (this.subTypes_ == null) {
                return true;
            }
            int stCount = this.subTypes_.size();
            for (stIdx = 0; stIdx < stCount && !this.subTypes_.get(stIdx).equals(subType); ++stIdx) {
            }
            return stIdx != stCount;
        }

        void addSubType(String subType) {
            this.subTypes_.add(subType);
        }
    }

    public static class Type {
        String typeName_;
        boolean compressable_;

        private Type(String type, boolean compressable) {
            this.typeName_ = type;
            this.compressable_ = compressable;
        }

        public String getName() {
            return this.typeName_;
        }

        public boolean compressable() {
            return this.compressable_;
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (this.getClass() != rhs.getClass()) {
                return false;
            }
            Type typedRHS = (Type)rhs;
            return this.typeName_.equalsIgnoreCase(typedRHS.typeName_);
        }
    }
}

