/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multipart.RequestByteArrayAttachment;
import com.cognos.cm.multipart.RequestFileAttachment;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.NewLineFilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class MultipartParser {
    private boolean warningEnabled;
    private NewLineFilterInputStream in;
    private String boundary;

    public MultipartParser(HttpServletRequest req, InputStream is, long maxSize) throws CMException, IOException {
        this(req, is, maxSize, true, true, false);
    }

    public MultipartParser(HttpServletRequest req, InputStream is, long maxSize, boolean buffer, boolean limitLength, boolean warn) throws CMException, IOException {
        this.setWarningEnabled(warn);
        this.in = new NewLineFilterInputStream(is);
        String type = null;
        String type1 = req.getHeader("Content-Type");
        String type2 = req.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() > type2.length() ? type1 : type2;
        }
        if (type == null || !type.toLowerCase().startsWith("multipart/related")) {
            throw new CMException("cmIONotMultiPart");
        }
        int length = req.getContentLength();
        if ((long)length > maxSize) {
            throw new CMException("cmIOContentTooLong", new CMException.Parm("length", String.valueOf(length)), new CMException.Parm("maxSize", String.valueOf(maxSize)));
        }
        this.boundary = this.extractBoundary(type);
        if (this.boundary == null) {
            throw new CMException("cmIONoSeparationBoundary");
        }
        if (this.isWarningEnabled()) {
            String cid;
            String parttype = this.extractFirstPartType(type);
            if (parttype == null || !parttype.toLowerCase().startsWith("text/xml")) {
                CMException cmex = new CMException("cmIOBadFirstPart");
                CMIndications.CMTraceText("Trace.CM.MIME", 10000, cmex.getFullMessageSys() + ": " + type);
            }
            if ((cid = this.extractFirstPartCID(type)) == null || cid.length() <= 0) {
                CMException cmex = new CMException("cmIOMissingCid");
                CMIndications.CMTraceText("Trace.CM.MIME", 10000, cmex.getFullMessageSys() + ": " + type);
            }
        }
        String line = this.readLine();
        int iPreambleSize = 0;
        while (line != null && !line.startsWith(this.boundary)) {
            if ((iPreambleSize += line.length()) > 10000) {
                throw new CMException("cmIODenialService");
            }
            line = this.readLine();
        }
        if (line == null) {
            throw new CMException("cmIOMissingLeadBoundary", new CMException.Parm("boundary", this.boundary));
        }
    }

    public RequestFileAttachment readNextPartTempFile() throws CMException, IOException, CAMCryptoException {
        Vector<String> headers = new Vector<String>();
        String line = this.readLine();
        while (line != null && line.length() == 0) {
            line = this.readLine();
        }
        if (line == null) {
            return null;
        }
        headers.addElement(line);
        while ((line = this.readLine()) != null && line.length() > 0) {
            headers.addElement(line);
        }
        if (line == null) {
            return null;
        }
        String cid = null;
        String contentType = "text/plain";
        String contentEncoding = null;
        String contentTransferEncoding = null;
        Enumeration myEnum = headers.elements();
        while (myEnum.hasMoreElements()) {
            String headerline = (String)myEnum.nextElement();
            if (headerline.toLowerCase(Locale.ENGLISH).startsWith("content-id:")) {
                cid = this.extractContentID(headerline);
                continue;
            }
            if (headerline.toLowerCase().startsWith("content-type:")) {
                String type = this.extractContentType(headerline);
                if (type == null) continue;
                contentType = type;
                continue;
            }
            if (headerline.toLowerCase().startsWith("content-transfer-encoding:")) {
                contentTransferEncoding = this.extractContentTransferEncoding(headerline);
                continue;
            }
            if (!headerline.toLowerCase().startsWith("content-encoding:")) continue;
            contentEncoding = this.extractContentEncoding(headerline);
        }
        RequestFileAttachment newAttachment = new RequestFileAttachment(cid, this.in, this.boundary, contentType, contentEncoding, contentTransferEncoding);
        return newAttachment;
    }

    public RequestByteArrayAttachment readNextPartByteArray() throws CMException, IOException {
        Vector<String> headers = new Vector<String>();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        if (line.length() == 0) {
            return null;
        }
        headers.addElement(line);
        while ((line = this.readLine()) != null && line.length() > 0) {
            headers.addElement(line);
        }
        if (line == null) {
            return null;
        }
        String cid = null;
        String contentType = "text/plain";
        Enumeration myEnum = headers.elements();
        while (myEnum.hasMoreElements()) {
            String type;
            String headerline = (String)myEnum.nextElement();
            if (headerline.toLowerCase(Locale.ENGLISH).startsWith("content-id:")) {
                cid = this.extractContentID(headerline);
                continue;
            }
            if (!headerline.toLowerCase().startsWith("content-type:") || (type = this.extractContentType(headerline)) == null) continue;
            contentType = type;
        }
        return new RequestByteArrayAttachment(cid, this.in, this.boundary, contentType);
    }

    private String extractBoundary(String line) {
        int index = line.indexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        if (boundary.charAt(0) == '\"') {
            index = boundary.indexOf(34, 1);
            boundary = boundary.substring(1, index);
        }
        if ((index = boundary.indexOf(59)) >= 0) {
            boundary = boundary.substring(0, index);
        }
        boundary = "--" + boundary;
        return boundary;
    }

    private String extractFirstPartType(String line) {
        int index = line.lastIndexOf("type=");
        if (index == -1) {
            return null;
        }
        String type = line.substring(index + 5);
        if (type.charAt(0) == '\"') {
            index = type.indexOf(34, 1);
            type = type.substring(1, index);
        }
        if ((index = type.indexOf(59)) >= 0) {
            type = type.substring(0, index);
        }
        return type;
    }

    private String extractFirstPartCID(String line) {
        int index = line.lastIndexOf("start=");
        if (index == -1) {
            return null;
        }
        String cid = line.substring(index + 6);
        if (cid.charAt(0) == '\"') {
            index = cid.indexOf(34, 1);
            cid = cid.substring(1, index);
        }
        if ((index = cid.indexOf(59)) >= 0) {
            cid = cid.substring(0, index);
        }
        if ((index = cid.indexOf(60)) >= 0) {
            cid = cid.substring(index);
        }
        if ((index = cid.lastIndexOf(62)) >= 0) {
            cid = cid.substring(0, index);
        }
        return cid;
    }

    private String extractContentID(String line) throws CMException, IOException {
        String contentID = null;
        String origline = line;
        if ((line = origline.toLowerCase(Locale.ENGLISH)).startsWith("content-id")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new CMException("cmIOBadContentType", new CMException.Parm("origline", origline));
            }
            contentID = line.substring(start + 1);
        } else if (line.length() != 0) {
            throw new CMException("cmIOBadContentID", new CMException.Parm("origline", origline));
        }
        int index = contentID.indexOf(60);
        if (index >= 0) {
            contentID = contentID.substring(index + 1);
        }
        if ((index = contentID.lastIndexOf(62)) >= 0) {
            contentID = contentID.substring(0, index);
        }
        return contentID;
    }

    private String extractContentType(String line) throws CMException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-type")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new CMException("cmIOBadContentType", new CMException.Parm("origline", origline));
            }
            contentType = line.substring(start + 1);
        } else if (line.length() != 0) {
            throw new CMException("cmIOBadDispositionLine", new CMException.Parm("origline", origline));
        }
        return contentType;
    }

    private String extractContentTransferEncoding(String line) throws CMException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-transfer-encoding")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new CMException("cmIOBadContentType", new CMException.Parm("origline", origline));
            }
            contentType = line.substring(start + 1);
        } else if (line.length() != 0) {
            throw new CMException("cmIOBadDispositionLine", new CMException.Parm("origline", origline));
        }
        return contentType;
    }

    private String extractContentEncoding(String line) throws CMException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-encoding")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new CMException("cmIOBadContentType", new CMException.Parm("origline", origline));
            }
            contentType = line.substring(start + 1);
        } else if (line.length() != 0) {
            throw new CMException("cmIOBadDispositionLine", new CMException.Parm("origline", origline));
        }
        return contentType;
    }

    private String readLine() throws IOException {
        int result;
        StringBuffer sbuf = new StringBuffer();
        byte[] buf = new byte[8192];
        do {
            if ((result = this.in.readLine(buf, 0, buf.length)) == -1) continue;
            sbuf.append(new String(buf, 0, result, "ISO-8859-1"));
        } while (result == buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        int len = sbuf.length();
        if (len > 1 && sbuf.charAt(len - 2) == '\r') {
            sbuf.setLength(len - 2);
        } else {
            sbuf.setLength(len - 1);
        }
        return sbuf.toString();
    }

    protected boolean isWarningEnabled() {
        return this.warningEnabled;
    }

    protected void setWarningEnabled(boolean b) {
        this.warningEnabled = b;
    }
}

