/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.multipart.ContentTypes;
import com.cognos.cm.server.CMException;
import java.io.IOException;
import java.io.InputStream;

public abstract class RequestAttachment {
    private String name;
    protected String contentType;
    protected String contentEncoding;
    protected ContentTypes.Type type;
    protected String contentTransferEncoding;
    protected long size;
    protected boolean compressed;

    RequestAttachment(String name) {
        this.name = name;
        this.size = 0L;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isDeploymentFile() {
        return false;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    public InputStream getTempInputStream() throws CAMCryptoException, IOException, CMException {
        return null;
    }

    public void DeleteTheFileIfExists() {
        this.size = 0L;
    }

    public void setContentType(String enc) throws CMException {
        this.type = ContentTypes.getType(enc);
        this.contentType = enc;
    }

    public void setContentEncoding(String enc) {
        this.contentEncoding = enc;
    }

    public void setContentTransferEncoding(String enc) {
        if (enc == null || enc == "base64" || enc != "quoted-printable") {
            // empty if block
        }
        this.contentTransferEncoding = enc;
    }
}

