/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import com.cognos.cm.multipart.BufferedPartInputStream;
import com.cognos.cm.multipart.PartInputStream;
import com.cognos.cm.multipart.RequestAttachment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RequestByteArrayAttachment
extends RequestAttachment {
    private byte[] attachmentBuf;

    RequestByteArrayAttachment(String name, InputStream in, String boundary, String contenttype) throws IOException {
        super(name);
        this.contentType = contenttype;
        FilterInputStream partInput = in.markSupported() ? new BufferedPartInputStream(in, boundary) : new PartInputStream(in, boundary);
        this.size = this.Load(partInput);
    }

    @Override
    public InputStream getTempInputStream() throws FileNotFoundException {
        if (this.attachmentBuf != null) {
            return new ByteArrayInputStream(this.attachmentBuf);
        }
        return null;
    }

    @Override
    public void DeleteTheFileIfExists() {
        this.attachmentBuf = null;
        this.size = 0L;
    }

    private long Load(InputStream partInput) throws IOException {
        int read;
        ByteArrayOutputStream outBytes;
        ByteArrayOutputStream out = outBytes = new ByteArrayOutputStream();
        if (this.contentType.equals("application/x-macbinary")) {
            throw new IllegalStateException("The content type application/x-macbinary is not supported by ContentManager");
        }
        byte[] buf = new byte[8192];
        while ((read = partInput.read(buf)) != -1) {
            ((OutputStream)out).write(buf, 0, read);
            this.size += (long)read;
        }
        this.attachmentBuf = outBytes.toByteArray();
        return this.size;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public byte[] getBytes() {
        return this.attachmentBuf;
    }
}

