/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.multipart.BufferedPartInputStream;
import com.cognos.cm.multipart.PartInputStream;
import com.cognos.cm.multipart.QuotedPrintableEncoder;
import com.cognos.cm.multipart.RequestAttachment;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMTempOutputStream;
import com.cognos.perfMonitor.PerfMeasure;
import com.cognos.perfMonitor.PerfMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class RequestFileAttachment
extends RequestAttachment {
    public static final String PRESERVED_TEMP_FILE_DIR_NAME = "cm_errors";
    private static final PerfMeasure PERF_REQUESTFILEATT_SIZE = PerfMonitor.getMeasure((String)"com.cognos.cm.multipart.RequestFileAttachment.attSize", (String)"The number of request file attachments and their size", (int)6);
    private CMTempOutputStream handledFileOutputStream_;
    private boolean arrivedCompressed_;

    RequestFileAttachment(String name, InputStream in, String boundary, String contentType, String contentEncoding, String contentTransferEncoding) throws CMException, IOException {
        super(name);
        this.setContentType(contentType);
        this.setContentEncoding(contentEncoding);
        this.setContentTransferEncoding(contentTransferEncoding);
        if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
            this.arrivedCompressed_ = true;
            this.compressed = true;
        }
        FilterInputStream partInput = in.markSupported() ? new BufferedPartInputStream(in, boundary) : new PartInputStream(in, boundary);
        this.size = this.Load(partInput);
        if (this.size > AdvancedSettings.MULTIPARTREQUESTMAXLENGTH) {
            throw new CMException("cmIOContentTooLong", new CMException.Parm("length", String.valueOf(this.size)), new CMException.Parm("maxSize", String.valueOf(AdvancedSettings.MULTIPARTREQUESTMAXLENGTH)));
        }
        PERF_REQUESTFILEATT_SIZE.incr(this.size);
    }

    public RequestFileAttachment(String name) {
        super(name);
    }

    public String getFileName() {
        if (this.doesTempFileExist()) {
            File file = this.handledFileOutputStream_.getFile();
            return file.getName();
        }
        return null;
    }

    public long getCompressedSize() {
        if (this.handledFileOutputStream_ != null) {
            return this.handledFileOutputStream_.getSize();
        }
        return 0L;
    }

    @Override
    public boolean isFile() {
        if (this.handledFileOutputStream_ != null) {
            return this.handledFileOutputStream_.isFile();
        }
        return false;
    }

    protected boolean doesTempFileExist() {
        return this.handledFileOutputStream_ != null && this.handledFileOutputStream_.getFile() != null;
    }

    public String getFilePath() {
        if (this.doesTempFileExist()) {
            File file = this.handledFileOutputStream_.getFile();
            return file.getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long Load(InputStream partInput) throws CMException, IOException {
        OutputStream fileOut = null;
        long written = 0L;
        boolean deleteTempFile = true;
        boolean shouldPreserveTempFile = false;
        try {
            this.handledFileOutputStream_ = this.getTempOutputStream();
            fileOut = this.handledFileOutputStream_;
            if (!this.arrivedCompressed_ && this.type.compressable()) {
                fileOut = new GZIPOutputStream(this.handledFileOutputStream_);
                this.compressed = true;
            }
            written = this.contentTransferEncoding != null && this.contentTransferEncoding.equalsIgnoreCase("Base64") ? this.write64EncodedData(partInput, fileOut) : (this.contentTransferEncoding != null && this.contentTransferEncoding.equalsIgnoreCase("quoted-printable") ? this.writeQuotedPrintableData(partInput, fileOut) : this.write(partInput, fileOut));
            fileOut.close();
            if (this.arrivedCompressed_) {
                byte[] buf = new byte[8192];
                try (InputStream testStream = null;){
                    testStream = this.getTempInputStream();
                    testStream = new GZIPInputStream(new BufferedInputStream(testStream, 32768));
                    int bytesRead = testStream.read(buf);
                    written = 0L;
                    while (bytesRead > 0) {
                        written += (long)bytesRead;
                        bytesRead = testStream.read(buf);
                    }
                }
            }
            deleteTempFile = false;
        }
        finally {
            if (fileOut != null) {
                fileOut.close();
            }
            try {
                if (this.handledFileOutputStream_ != null) {
                    if (shouldPreserveTempFile) {
                        this.handledFileOutputStream_.close();
                        this.moveTempFileToPreservedFolder();
                        this.handledFileOutputStream_ = null;
                    } else if (deleteTempFile) {
                        this.handledFileOutputStream_.delete();
                        this.handledFileOutputStream_ = null;
                    }
                }
            }
            catch (IOException ioExec) {
                CMIndications.logException(ioExec);
            }
        }
        return written;
    }

    private void moveTempFileToPreservedFolder() {
        if (this.doesTempFileExist()) {
            File tempFile = this.handledFileOutputStream_.getFile();
            String preservedTempFolderName = tempFile.getParent() + File.separator + PRESERVED_TEMP_FILE_DIR_NAME;
            File preservedTempFolder = new File(preservedTempFolderName);
            if (!preservedTempFolder.exists()) {
                preservedTempFolder.mkdir();
            }
            File renamedFile = new File(preservedTempFolder, tempFile.getName());
            this.handledFileOutputStream_.moveTempFile(renamedFile);
        }
    }

    protected CMTempOutputStream getTempOutputStream() {
        return new CMTempOutputStream();
    }

    @Override
    public InputStream getTempInputStream() throws CAMCryptoException, IOException {
        if (this.handledFileOutputStream_ != null) {
            return this.handledFileOutputStream_.getInputStream();
        }
        return null;
    }

    @Override
    public void DeleteTheFileIfExists() {
        try {
            if (this.handledFileOutputStream_ != null) {
                this.handledFileOutputStream_.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.handledFileOutputStream_ = null;
    }

    public void flush() {
        try {
            if (this.handledFileOutputStream_ != null) {
                this.handledFileOutputStream_.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void ensureFileNameExists() {
        try {
            if (this.handledFileOutputStream_ != null) {
                this.handledFileOutputStream_.ensureFileNameExists();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    long write(InputStream partInput, OutputStream out) throws IOException {
        if (this.contentType.equals("application/x-macbinary")) {
            throw new IllegalStateException("The content type application/x-macbinary is not supported by ContentManager");
        }
        long size = 0L;
        int bytesRead = 0;
        byte[] buf = new byte[8192];
        byte[] last4Bytes = new byte[4];
        boolean bRead4Bytes = false;
        try {
            while ((bytesRead = partInput.read(buf)) > 0) {
                out.write(buf, 0, bytesRead);
                size += (long)bytesRead;
                this.copyLast4Bytes(buf, bytesRead, last4Bytes, bRead4Bytes);
                if (bRead4Bytes || bytesRead < 4) continue;
                bRead4Bytes = true;
            }
        }
        catch (IOException ex) {
            try {
                partInput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        size = !bRead4Bytes ? 0L : this.dealWithCompressed(size, last4Bytes);
        return size;
    }

    long write64EncodedData(InputStream partInput, OutputStream out) throws IOException {
        int read;
        if (this.arrivedCompressed_) {
            partInput = new GZIPInputStream(partInput);
            this.arrivedCompressed_ = false;
        }
        long size = 0L;
        byte[] buf = new byte[8192];
        while ((read = partInput.read(buf)) != -1) {
            Base64.decode(buf, 0, read, out);
            size += (long)read;
        }
        return size;
    }

    long writeQuotedPrintableData(InputStream partInput, OutputStream out) throws IOException {
        int read;
        if (this.arrivedCompressed_) {
            partInput = new GZIPInputStream(partInput);
            this.arrivedCompressed_ = false;
        }
        long size = 0L;
        byte[] buf = new byte[8192];
        byte[] last4Bytes = new byte[4];
        boolean bRead4Bytes = false;
        while ((read = partInput.read(buf)) != -1) {
            QuotedPrintableEncoder.decode(buf, 0, read, out);
            size += (long)read;
            this.copyLast4Bytes(buf, read, last4Bytes, bRead4Bytes);
            if (bRead4Bytes || read < 4) continue;
            bRead4Bytes = true;
        }
        size = this.dealWithCompressed(size, last4Bytes);
        return size;
    }

    long dealWithCompressed(long size, byte[] buf) {
        if (this.arrivedCompressed_) {
            long s = 0L;
            if (buf.length >= 4) {
                s = (long)buf[0] + ((long)buf[1] << 8) + ((long)buf[2] << 16) + ((long)buf[3] << 24);
            }
            return s;
        }
        return size;
    }

    private void copyLast4Bytes(byte[] buf, int bufSize, byte[] last4Bytes, boolean bHasLastBytes) {
        if (last4Bytes.length < 4 || buf.length < bufSize) {
            return;
        }
        if (bufSize >= 4) {
            System.arraycopy(buf, bufSize - 4, last4Bytes, 0, 4);
        } else if (bHasLastBytes) {
            for (int last4BytesIndex = 0; last4BytesIndex < 4 - bufSize; ++last4BytesIndex) {
                last4Bytes[last4BytesIndex] = last4Bytes[last4BytesIndex + bufSize];
            }
            System.arraycopy(buf, 0, last4Bytes, 4 - bufSize, bufSize);
        }
    }
}

