/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.multipart.Base64DecodeWriter;
import com.cognos.cm.multipart.RequestAttachment;
import com.cognos.cm.util.CMTempOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;

public class RequestImportAttachment
extends RequestAttachment {
    private CMTempOutputStream handledFileOutputStream_;
    private OutputStream fileOut_ = null;
    private Writer writerOut_ = null;

    public RequestImportAttachment(String name, long theSize, boolean arrivedCompressed, boolean compressIt, boolean base64DecodeIt) throws IOException, CAMCryptoException {
        super(name);
        this.size = theSize;
        this.compressed = arrivedCompressed;
        this.handledFileOutputStream_ = new CMTempOutputStream();
        this.fileOut_ = this.handledFileOutputStream_;
        if (!this.compressed && compressIt) {
            this.fileOut_ = new GZIPOutputStream(this.handledFileOutputStream_);
        }
        this.writerOut_ = base64DecodeIt ? new Base64DecodeWriter(this.fileOut_) : new OutputStreamWriter(this.fileOut_, "UTF-8");
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isDeploymentFile() {
        return true;
    }

    public String getFileName() {
        if (this.handledFileOutputStream_ != null) {
            File file = this.handledFileOutputStream_.getFile();
            return file.getName();
        }
        return null;
    }

    public long getCompressedSize() {
        if (this.handledFileOutputStream_ != null) {
            this.handledFileOutputStream_.getSize();
        }
        return 0L;
    }

    @Override
    public long getSize() {
        if (this.size > 0L) {
            return this.size;
        }
        return this.getCompressedSize();
    }

    public String getFilePath() {
        if (this.handledFileOutputStream_ != null) {
            File file = this.handledFileOutputStream_.getFile();
            return file.getAbsolutePath();
        }
        return null;
    }

    @Override
    public InputStream getTempInputStream() throws CAMCryptoException, IOException {
        if (this.handledFileOutputStream_ != null) {
            return this.handledFileOutputStream_.getInputStream();
        }
        return null;
    }

    @Override
    public void DeleteTheFileIfExists() {
        try {
            if (this.handledFileOutputStream_ != null) {
                this.handledFileOutputStream_.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.handledFileOutputStream_ = null;
    }

    public void write(char[] ch, int start, int length) throws IOException {
        this.writerOut_.write(ch, start, length);
    }

    public void write(String s) throws IOException {
        char[] buf = new char[8192];
        int offset = 0;
        int len = s.length();
        while (offset != len) {
            int end = offset + buf.length;
            if (end > len) {
                end = len;
            }
            s.getChars(offset, end, buf, 0);
            this.writerOut_.write(buf, 0, end - offset);
            offset = end;
        }
    }

    public void finishWriting() {
        try {
            this.writerOut_.flush();
            this.writerOut_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

