/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class ResponseAttachment {
    private String cid;
    private String contenttype;
    private String contentTransferEncoding;
    private boolean isGZipped = false;
    public long startByte_ = -1L;
    public long endByte_ = -1L;
    public long sizeBytes_ = -1L;
    public boolean mWriteEntire;
    protected long fullContentLength;
    private static String guid_ = "Cognos.ContentManager";

    public String getCID() {
        if (this.cid == null || this.cid.length() <= 0) {
            this.cid = ResponseAttachment.GenerateCID();
        }
        return this.cid;
    }

    public String getContentType() {
        return this.contenttype;
    }

    public void setContentType(String type) {
        this.contenttype = type;
    }

    public String getContentEncoding() {
        if (this.isGZipped()) {
            return "gzip";
        }
        return null;
    }

    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    public void setContentTransferEncoding(String encoding) {
        this.contentTransferEncoding = encoding;
    }

    public boolean isGZipped() {
        return this.isGZipped;
    }

    public void setIsGZipped(boolean isIt) {
        this.isGZipped = isIt;
    }

    public long getSize() {
        return 0L;
    }

    public void release() {
    }

    public static String GenerateCID() {
        StringBuffer s = new StringBuffer();
        s.append(s.hashCode()).append('.').append(System.currentTimeMillis()).append('@').append(guid_);
        return s.toString();
    }

    public void writeHeader(PrintStream out) {
        StringBuffer buf = new StringBuffer("Content-Type: ");
        buf.append(this.contenttype);
        out.print(buf);
        out.print("\r\n");
        if (this.isGZipped()) {
            buf.replace(0, buf.length(), "Content-Encoding: gzip");
            out.print(buf);
            out.print("\r\n");
        }
        buf.replace(0, buf.length(), "Content-Transfer-Encoding: ");
        buf.append(this.contentTransferEncoding);
        out.print(buf);
        out.print("\r\n");
        buf.replace(0, buf.length(), "Content-ID: <");
        buf.append(this.getCID());
        buf.append(">");
        out.print(buf);
        out.print("\r\n");
        buf.replace(0, buf.length(), "Content-Length: ");
        buf.append(this.getSize());
        out.print(buf);
        out.print("\r\n");
        if (this.isPDF() || !this.mWriteEntire) {
            String s = ConfigurationFactory.getConfig().getInternalProp("CMPDFAttachmentMIMELine");
            if (s != null && s.length() > 0) {
                out.print(s);
                out.print("\r\n");
            }
            if (!this.mWriteEntire && this.sizeBytes_ > 0L) {
                out.print("Content-Range: bytes ");
                out.print(this.startByte_);
                out.print("-");
                out.print(this.endByte_);
                out.print("/");
                out.print(this.fullContentLength);
                out.print("\r\n");
            }
            out.print("Accept-Ranges: bytes \r\n");
        }
        out.print("\r\n");
    }

    public void writeHeader(PrintWriter out) {
        StringBuffer buf = new StringBuffer("Content-Type: ");
        buf.append(this.contenttype);
        out.print(buf);
        out.print("\r\n");
        if (this.isGZipped()) {
            buf.replace(0, buf.length(), "Content-Encoding: gzip");
            out.print(buf);
            out.print("\r\n");
        }
        buf.replace(0, buf.length(), "Content-Transfer-Encoding: ");
        buf.append(this.contentTransferEncoding);
        out.print(buf);
        out.print("\r\n");
        buf.replace(0, buf.length(), "Content-ID: <");
        buf.append(this.getCID());
        buf.append(">");
        out.print(buf);
        out.print("\r\n");
        buf.replace(0, buf.length(), "Content-Length: ");
        buf.append(this.getSize());
        out.print(buf);
        out.print("\r\n");
        if (this.isPDF() || !this.mWriteEntire) {
            String s = ConfigurationFactory.getConfig().getInternalProp("CMPDFAttachmentMIMELine");
            if (s != null && s.length() > 0) {
                out.print(s);
                out.print("\r\n");
            }
            if (!this.mWriteEntire && this.sizeBytes_ > 0L) {
                out.print("Content-Range: bytes ");
                out.print(this.startByte_);
                out.print("-");
                out.print(this.endByte_);
                out.print("/");
                out.print(this.fullContentLength);
                out.print("\r\n");
            }
            out.print("Accept-Ranges: bytes \r\n");
        }
        out.print("\r\n");
        out.flush();
    }

    public abstract void write(OutputStream var1) throws FileNotFoundException, IOException, CAMCryptoException, CMException;

    public boolean isPDF() {
        return this.contenttype.equalsIgnoreCase("application/pdf");
    }
}

