/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multipart;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.multipart.ContentTypes;
import com.cognos.cm.multipart.ResponseAttachment;
import com.cognos.cm.properties.DataPropertyHelper;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMInputStreamWithSize;
import com.cognos.cm.util.CMTempOutputStream;
import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.perfMonitor.PerfMeasure;
import com.cognos.perfMonitor.PerfMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;

public class ResponseFileAttachment
extends ResponseAttachment {
    private long mStartPosition;
    private long mLengthToWrite;
    private int sequenceNum_;
    private boolean mDataReturnedAsCompressed;
    private String mModificationTime_;
    private String cid;
    private DataPropertyHelper helper;
    private static String guid_ = "Cognos.ContentManager";
    private static final PerfMeasure PERF_RESPONSEFILEATT_SIZE = PerfMonitor.getMeasure((String)"com.cognos.cm.multipart.ResponseFileAttachment.attSize", (String)"The number of response file attachments and their size", (int)6);

    public ResponseFileAttachment(DataPropertyHelper helper, String modificationTime, int sequenceNum, long decryptedSize, long startPosition, long lengthToWrite, boolean dataCompressed, boolean bWriteEntire) {
        this.helper = helper;
        this.mStartPosition = startPosition;
        this.mLengthToWrite = lengthToWrite;
        this.mWriteEntire = bWriteEntire;
        this.mDataReturnedAsCompressed = dataCompressed;
        this.fullContentLength = decryptedSize;
        if (modificationTime == null) {
            modificationTime = String.valueOf(System.currentTimeMillis());
        }
        this.mModificationTime_ = modificationTime;
        if (sequenceNum < 1) {
            sequenceNum = helper.getFileHashCode();
        }
        this.sequenceNum_ = sequenceNum;
        this.sizeBytes_ = decryptedSize == 0L ? helper.getTempFile().getFile().length() : decryptedSize;
        this.startByte_ = this.mStartPosition;
        if (this.startByte_ < 0L) {
            this.startByte_ = 0L;
        } else if (this.startByte_ >= this.sizeBytes_) {
            this.startByte_ = this.sizeBytes_ - 1L;
        }
        this.endByte_ = this.mStartPosition + lengthToWrite - 1L;
        if (this.endByte_ >= this.sizeBytes_) {
            this.endByte_ = this.sizeBytes_ - 1L;
        }
    }

    @Override
    public String getCID() {
        if (this.cid == null || this.cid.length() <= 0) {
            StringBuffer s = new StringBuffer();
            s.append(String.valueOf(this.sequenceNum_));
            s.append('.').append(this.helper.getObjectID());
            s.append('.').append(String.valueOf(this.mStartPosition));
            s.append('.').append(String.valueOf(this.mLengthToWrite));
            s.append('.').append(this.mModificationTime_);
            s.append('.').append('@').append(guid_);
            this.cid = s.toString();
        }
        return this.cid;
    }

    @Override
    public long getSize() {
        long len = this.sizeBytes_;
        if (!this.isGZipped() && this.mLengthToWrite > 0L && this.mLengthToWrite < len) {
            len = this.mLengthToWrite;
        }
        return len;
    }

    @Override
    public void release() {
        this.helper.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream origOutputStream) throws FileNotFoundException, IOException, CAMCryptoException, CMException {
        InputStream is;
        long lWritten;
        CMTempOutputStream tempOutputStream;
        GZIPOutputStream gzipOutputStream;
        CMInputStreamWithSize iss;
        block20: {
            ContentTypes.Type type;
            if (this.mDataReturnedAsCompressed && !(type = ContentTypes.getType(this.getContentType())).compressable()) {
                this.mDataReturnedAsCompressed = false;
                this.setIsGZipped(false);
            }
            PrintWriter outPrint = new PrintWriter(new OutputStreamWriter(origOutputStream, "UTF-8"));
            iss = null;
            gzipOutputStream = null;
            OutputStream outputStream = origOutputStream;
            tempOutputStream = null;
            byte[] buf = new byte[8192];
            lWritten = 0L;
            is = null;
            try {
                if (this.mWriteEntire) {
                    int nBytesRead;
                    CMInputStreamWithSize isWithSize = this.prepareInputStreamForWriteEntire();
                    this.sizeBytes_ = isWithSize.length();
                    is = isWithSize;
                    this.mLengthToWrite = this.sizeBytes_;
                    this.writeHeader(outPrint);
                    while ((nBytesRead = is.read(buf)) > 0) {
                        outputStream.write(buf, 0, nBytesRead);
                        lWritten += (long)nBytesRead;
                    }
                } else {
                    is = this.getBaseInputStream(true);
                    if (this.mDataReturnedAsCompressed) {
                        tempOutputStream = new CMTempOutputStream();
                        gzipOutputStream = new GZIPOutputStream(tempOutputStream);
                        outputStream = gzipOutputStream;
                    } else {
                        this.writeHeader(outPrint);
                    }
                    long numTotalBytesRead = 0L;
                    boolean bNotDone = true;
                    if (this.mStartPosition > 0L) {
                        int c = 0;
                        for (long skipped = is.skip(this.mStartPosition); c >= 0 && skipped < this.mStartPosition; ++skipped) {
                            c = is.read();
                        }
                    }
                    int nBytesRead = is.read(buf);
                    while (bNotDone && nBytesRead > 0) {
                        if (this.mLengthToWrite > 0L && numTotalBytesRead + (long)nBytesRead > this.mLengthToWrite) {
                            nBytesRead = (int)(this.mLengthToWrite - numTotalBytesRead);
                            bNotDone = false;
                        }
                        outputStream.write(buf, 0, nBytesRead);
                        lWritten += (long)nBytesRead;
                        numTotalBytesRead += (long)nBytesRead;
                        if (!bNotDone) continue;
                        nBytesRead = is.read(buf);
                    }
                    if (this.mDataReturnedAsCompressed) {
                        ((OutputStream)gzipOutputStream).close();
                        outputStream = origOutputStream;
                        iss = tempOutputStream.getInputStream();
                        this.sizeBytes_ = iss.length();
                        this.writeHeader(outPrint);
                        lWritten = 0L;
                        while ((nBytesRead = iss.read(buf)) > 0) {
                            outputStream.write(buf, 0, nBytesRead);
                            lWritten += (long)nBytesRead;
                        }
                    }
                }
                if (AdvancedSettings.SYSTEMGCATTACHMENTSIZEBYTES < 0 || this.mLengthToWrite < (long)AdvancedSettings.SYSTEMGCATTACHMENTSIZEBYTES) break block20;
                System.gc();
            }
            catch (Throwable throwable) {
                CMStreamUtils.quietClose(is);
                CMStreamUtils.quietClose(iss);
                CMStreamUtils.quietClose(gzipOutputStream);
                try {
                    if (tempOutputStream != null) {
                        tempOutputStream.delete();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                PERF_RESPONSEFILEATT_SIZE.incr(lWritten);
                throw throwable;
            }
        }
        CMStreamUtils.quietClose((InputStream)is);
        CMStreamUtils.quietClose(iss);
        CMStreamUtils.quietClose((OutputStream)gzipOutputStream);
        try {
            if (tempOutputStream != null) {
                tempOutputStream.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PERF_RESPONSEFILEATT_SIZE.incr(lWritten);
    }

    private InputStream getBaseInputStream(boolean returnDataDecompressed) throws CAMCryptoException, IOException {
        return this.helper.getInputStream(returnDataDecompressed);
    }

    private CMInputStreamWithSize prepareCompressDecompressStreamForWriteEntire(long baseSize, byte[] buf) throws IOException, CAMCryptoException {
        InputStream baseInputStream;
        InputStream is = baseInputStream = this.getBaseInputStream(!this.mDataReturnedAsCompressed);
        long sizeBytes = baseSize;
        if (this.mDataReturnedAsCompressed) {
            if (!this.helper.internalDataIsCompressed()) {
                int nBytesRead;
                CMTempOutputStream tempOutputStream = new CMTempOutputStream();
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(tempOutputStream);
                while ((nBytesRead = baseInputStream.read(buf)) > 0) {
                    gzipOutputStream.write(buf, 0, nBytesRead);
                }
                gzipOutputStream.close();
                sizeBytes = tempOutputStream.getSize();
                is = tempOutputStream.getInputStream();
            } else {
                sizeBytes = this.helper.getDataSize();
                if (sizeBytes < 0L) {
                    sizeBytes = this.helper.getTempFile().getFile().length();
                }
            }
        }
        return new CMInputStreamWithSize(is, sizeBytes);
    }

    public CMInputStreamWithSize prepareInputStreamForWriteEntire() throws FileNotFoundException, CAMCryptoException, IOException {
        byte[] buf = new byte[8192];
        return this.prepareCompressDecompressStreamForWriteEntire(this.sizeBytes_, buf);
    }
}

