/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multitenancy;

import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMStringUtils;

public class MultiTenancyUtils {
    public static final String CM_ADVANCED_PROPERTY_ignoreInvalidTenantContainmentAtStartup = "ignoreInvalidTenantContainmentAtStartup";
    private static MultiTenancyUtils INSTANCE = new MultiTenancyUtils();
    private Boolean ignoreInvalidTenantContainmentAtStartup;

    public static MultiTenancyUtils get() {
        return INSTANCE;
    }

    public static void set(MultiTenancyUtils utils) {
        INSTANCE = utils;
    }

    public static void reset() {
        INSTANCE = new MultiTenancyUtils();
    }

    public static void validateTenantId(String tenantId, CMObjectClass theObjectClass, boolean isImport, TenantRegistry registry) throws CMException {
        boolean createIfNotExist = isImport || theObjectClass == CMObjectClass.TENANT;
        registry.getTenantIdIntFromString(tenantId, createIfNotExist);
    }

    public static boolean isValidContainment(int parentTenantId, int childTenantId) {
        return parentTenantId == 0 || parentTenantId == childTenantId;
    }

    public static int determineTenantIdWithVirtualInheritance(int parentTenantId) {
        return MultiTenancyUtils.determineTenantIdWithVirtualInheritance(parentTenantId, CMExecutionContext.get().getCurrentUserTenantId());
    }

    public static int determineTenantIdWithVirtualInheritance(int parentTenantId, int userTenantId) {
        if (!MultiTenancyUtils.isValidContainment(parentTenantId, userTenantId)) {
            return parentTenantId;
        }
        return userTenantId;
    }

    public static String normalizeTenantIDString(String tenantID) {
        return CMStringUtils.collapseWhitespace(tenantID);
    }

    public boolean ignoreInvalidContainmentOnStartup() {
        if (this.ignoreInvalidTenantContainmentAtStartup == null) {
            String value = ConfigurationFactory.getConfig().getConfigAdvancedProp(CM_ADVANCED_PROPERTY_ignoreInvalidTenantContainmentAtStartup);
            this.ignoreInvalidTenantContainmentAtStartup = new Boolean(Boolean.parseBoolean(value));
        }
        return this.ignoreInvalidTenantContainmentAtStartup;
    }

    public boolean isMultiTenantInstall(CMStore store) {
        TenantRegistry tenantRegistry = store.getTenantRegistry();
        return tenantRegistry.getTenantCount() > 1;
    }
}

