/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multitenancy;

import com.cognos.cm.connectors.MDSRVConnector.MDSRVConnector;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePathFactory;
import com.cognos.cm.store.path.CMStoreXPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MyDataSetsRepositoryCleaner {
    private CMStore store_;
    private CMStorePathFactory pathFactory_;
    private ICMLockManager lockManager_;
    private List<String> connectionStrings_;
    private List<String> credentials_;
    private static final String LOB_DATASOURCE_SEARCHPATH = "//dataSource[@capabilities='http://developer.cognos.com/ceba/constants/dataSourceCapabilityEnum#lobData']";
    private static final String ENCRYPTED_VALUE = "encryptedValue";

    public MyDataSetsRepositoryCleaner(CMStore store, CMStorePathFactory pathFactory) {
        this.store_ = store;
        this.lockManager_ = store.getLockManager();
        this.pathFactory_ = pathFactory;
        this.connectionStrings_ = new ArrayList<String>();
        this.credentials_ = new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectLOBDataSources(String tenantIDStr) {
        CMStoreQueryResults dsQueryResults = null;
        ArrayList<String> dataSources = new ArrayList<String>();
        try {
            CMProperty[] props = new CMProperty[]{CMProperty.SEARCHPATH, CMProperty.TENANTID};
            CMStoreXPath path = this.pathFactory_.createCMStoreXPath(LOB_DATASOURCE_SEARCHPATH, 10);
            this.lockManager_.requestLocks(path);
            dsQueryResults = this.store_.executeQuery(path, props, null, 0, 512, null);
            while (dsQueryResults.next()) {
                String dataSourceSearchPath = this.getStringValue(dsQueryResults, 0);
                String tenantID = this.getStringValue(dsQueryResults, 1);
                if (!tenantIDStr.equals(tenantID) && !tenantID.equals("")) continue;
                dataSources.add(dataSourceSearchPath);
            }
            for (String ds : dataSources) {
                this.getDataSourceConnections(ds, tenantIDStr);
            }
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
        finally {
            if (dsQueryResults != null) {
                dsQueryResults.release();
            }
            try {
                this.lockManager_.releaseLocks();
            }
            catch (CMException ex) {
                CMIndications.logException(ex, "Failed to release lock manager locks");
            }
        }
    }

    public void cleanDataSetsRepository(List<String> deletedUserAccounts) {
        if (deletedUserAccounts == null || deletedUserAccounts.isEmpty()) {
            return;
        }
        try {
            MDSRVConnector mdsrv = MDSRVConnector.getMDSRVConnector();
            mdsrv.deleteDataSets(deletedUserAccounts, this.connectionStrings_, this.credentials_);
        }
        catch (Exception ex) {
            CMIndications.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDataSourceConnections(String dataSourceSearchPath, String tenantIDStr) {
        CMStoreQueryResults dsConnQueryResults = null;
        String searchPathDSConn = dataSourceSearchPath + "/dataSourceConnection";
        HashMap<String, String> dsConnections = new HashMap<String, String>();
        try {
            CMProperty[] props = new CMProperty[]{CMProperty.SEARCHPATH, CMProperty.TENANTID, CMProperty.CONNECTIONSTRING};
            CMStoreXPath path = this.pathFactory_.createCMStoreXPath(searchPathDSConn, 10);
            dsConnQueryResults = this.store_.executeQuery(path, props, null, 0, 512, null);
            while (dsConnQueryResults.next()) {
                String dsConnectionSearchPath = this.getStringValue(dsConnQueryResults, 0);
                String tenantID = this.getStringValue(dsConnQueryResults, 1);
                String dsConnectionString = this.getStringValue(dsConnQueryResults, 2);
                if (!tenantIDStr.equals(tenantID) && !tenantID.equals("")) continue;
                dsConnections.put(dsConnectionSearchPath, dsConnectionString);
            }
            for (String dsc : dsConnections.keySet()) {
                String sEncodedEncryptedValue = this.getDataSourceSignon(dsc);
                if (sEncodedEncryptedValue == null) continue;
                this.credentials_.add(sEncodedEncryptedValue);
                this.connectionStrings_.add((String)dsConnections.get(dsc));
            }
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
        finally {
            if (dsConnQueryResults != null) {
                dsConnQueryResults.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDataSourceSignon(String dsConnectionSearchPath) {
        String returnValue;
        block9: {
            returnValue = null;
            CMStoreQueryResults dsSignonQueryResults = null;
            String searchPathDSSignon = dsConnectionSearchPath + "/dataSourceSignon";
            try {
                Object credentialsValueObject;
                CMProperty[] props = new CMProperty[]{CMProperty.CREDENTIALS};
                CMStoreXPath path = this.pathFactory_.createCMStoreXPath(searchPathDSSignon, 10);
                dsSignonQueryResults = this.store_.executeQuery(path, props, null, 0, 512, null);
                if (!dsSignonQueryResults.next() || (credentialsValueObject = dsSignonQueryResults.getValue(0)) == null) break block9;
                String sEncodedEncryptedCredentials = RequestHandler.readAnyTypePropertyValueIntoString(credentialsValueObject);
                String sEncodedEncryptedData = null;
                try {
                    Element root = DocumentHelper.parseText((String)sEncodedEncryptedCredentials).getRootElement();
                    Element encryptedValueElem = root.element(ENCRYPTED_VALUE);
                    sEncodedEncryptedData = encryptedValueElem.getText();
                }
                catch (Exception e) {
                    throw new CMException(e, "Failed to parse credentials");
                }
                if (sEncodedEncryptedData != null) {
                    returnValue = sEncodedEncryptedData;
                }
            }
            catch (Exception e) {
                CMIndications.logException(e);
            }
            finally {
                if (dsSignonQueryResults != null) {
                    dsSignonQueryResults.release();
                }
            }
        }
        return returnValue;
    }

    private final String getStringValue(CMStoreQueryResults rs, int idx) throws CMException {
        Object value = rs.getValue(idx);
        if (value != null) {
            return value.toString();
        }
        return null;
    }
}

