/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multitenancy;

import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.UserSessionCacheEntry;
import java.util.Arrays;

public interface ReadTenantFilter {
    public int[] getReadTenantIds();

    public static class SessionBasedTenantFilter
    implements ReadTenantFilter {
        @Override
        public int[] getReadTenantIds() {
            UserSessionCacheEntry user = CMExecutionContext.get().getContext().getCurrentUserSession();
            if (user != null) {
                return user.getReadTenantIds();
            }
            return null;
        }
    }

    public static class FixedListTenantFilter
    implements ReadTenantFilter {
        private int[] readTenantIds;

        public FixedListTenantFilter(int ... ids) {
            this.readTenantIds = ids;
        }

        @Override
        public int[] getReadTenantIds() {
            return this.readTenantIds;
        }

        public boolean equals(Object o) {
            if (o instanceof FixedListTenantFilter) {
                FixedListTenantFilter other = (FixedListTenantFilter)o;
                return Arrays.equals(this.readTenantIds, other.readTenantIds);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.readTenantIds);
        }
    }

    public static class AllowAllTenantFilter
    implements ReadTenantFilter {
        @Override
        public int[] getReadTenantIds() {
            CMExecutionContext currentContext = CMExecutionContext.get();
            UserSessionCacheEntry userSessionCacheEntry = currentContext.getContext().getCurrentUserSession();
            int[] allowedTenants = null;
            if (userSessionCacheEntry != null) {
                allowedTenants = userSessionCacheEntry.getBoundedTenantIds();
            }
            return allowedTenants;
        }
    }
}

