/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multitenancy;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cmutils.path.SearchPathEncoder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TenantContainmentConsistencyCheck {
    private static final int RS_INDEX_STOREID = 1;
    private static final int RS_INDEX_CMID = 2;
    private static final int RS_INDEX_TENANTID = 3;
    private static final int RS_INDEX_PARENT_STOREID = 4;
    private static final int RS_INDEX_PARENT_CMID = 5;
    private static final int RS_INDEX_PARENT_TENANTID = 6;
    private CMDbConnection connection;
    private TenantRegistry tenantRegistry;
    private Map<String, String> childToParentInconsistentStoreIds;
    private CMStore store;

    public TenantContainmentConsistencyCheck(CMStore store, CMDbConnection connection) {
        this.connection = connection;
        this.store = store;
        this.tenantRegistry = store.getTenantRegistry();
        this.childToParentInconsistentStoreIds = new HashMap<String, String>();
    }

    public List<CMException> checkTenantContainmentConsistency(boolean provideDetails) throws CMConfigurationException {
        ArrayList<CMException> exceptions = new ArrayList<CMException>();
        try {
            if (CMDbConnection.dbms_ != 4) {
                this.connection.beginTransaction();
            }
            this.runConsistencyCheck(exceptions, provideDetails);
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
        }
        finally {
            if (CMDbConnection.dbms_ != 4) {
                try {
                    this.connection.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
        return exceptions;
    }

    protected void runConsistencyCheck(List<CMException> exceptions, boolean provideDetails) throws CMConfigurationException {
        String invalidContainmentSql = "SELECT ids.STOREID, objects.CMID, objects.TENANTID, parentIds.STOREID, parent.CMID, parent.TENANTID FROM CMOBJECTS objects INNER JOIN CMOBJECTS parent ON (objects.PCMID = parent.CMID AND parent.TENANTID != 0 AND parent.TENANTID != objects.TENANTID) INNER JOIN CMSTOREIDS ids ON objects.CMID = ids.CMID INNER JOIN CMSTOREIDS parentIds ON objects.PCMID = parentIds.CMID";
        PreparedStatement stmt = null;
        try {
            stmt = this.connection.prepareStatement(invalidContainmentSql);
            ResultSet rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
                CMException processed = this.processResult(rs);
                if (!provideDetails) continue;
                exceptions.add(processed);
            }
            if (count > 0) {
                exceptions.add(new CMException("cmFoundInvalidTenantContainment", new CMException.Parm("count", String.valueOf(count))));
            }
        }
        catch (SQLException ex) {
            try {
                throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
    }

    private CMException processResult(ResultSet rs) throws SQLException {
        String storeId = rs.getString(1);
        int tenantId = rs.getInt(3);
        int objectId = rs.getInt(2);
        String parentStoreId = rs.getString(4);
        int parentTenantId = rs.getInt(6);
        int parentObjectId = rs.getInt(5);
        String stringTenantId = this.tenantRegistry.getTenantIdStringFromInt(tenantId);
        String stringParentTenantId = this.tenantRegistry.getTenantIdStringFromInt(parentTenantId);
        this.childToParentInconsistentStoreIds.put(storeId, parentStoreId);
        String searchPath = this.getSearchPath(objectId, storeId);
        String parentSearchPath = this.getSearchPath(parentObjectId, parentStoreId);
        return new CMException("cmInvalidTenantHierarchy", new CMException.Parm("searchPath", searchPath), new CMException.Parm("parentSearchPath", parentSearchPath), new CMException.Parm("tenantID", stringTenantId), new CMException.Parm("parentTenantID", stringParentTenantId));
    }

    private String getSearchPath(int objectId, String storeId) {
        String result;
        try {
            result = this.store.getObjectSearchPath(objectId);
        }
        catch (CMException e) {
            result = CMConstants.FUNC_STOREID_DEF.getName() + "(" + SearchPathEncoder.quoteString((String)storeId) + ")";
        }
        return result;
    }

    public Map<String, String> getChildToParentInconsistentStoreIds() {
        return this.childToParentInconsistentStoreIds;
    }
}

