/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multitenancy;

import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePathFactory;
import com.cognos.cm.store.path.CMStoreXPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TenantContainmentConsistencyRepair {
    private CMStore store;
    private TenantRegistry tenantRegistry;
    private Map<String, String> childToParentStoreIds;
    private CMStorePathFactory pathFactory;
    private ICMLockManager lockManager;

    public TenantContainmentConsistencyRepair(CMStore store, Map<String, String> childToParentStoreIds) {
        this(store, childToParentStoreIds, new CMStorePathFactory());
    }

    public TenantContainmentConsistencyRepair(CMStore store, Map<String, String> childToParentStoreIds, CMStorePathFactory pathFactory) {
        this.store = store;
        this.tenantRegistry = store.getTenantRegistry();
        this.lockManager = store.getLockManager();
        this.childToParentStoreIds = childToParentStoreIds;
        this.pathFactory = pathFactory;
    }

    public List<CMException> repairInconsistencies() throws CMException {
        ArrayList<CMException> fixes = new ArrayList<CMException>();
        for (Map.Entry<String, String> entry : this.childToParentStoreIds.entrySet()) {
            this.repairSubtree(fixes, entry.getKey(), entry.getValue());
        }
        return fixes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repairSubtree(List<CMException> fixes, String childStoreId, String parentStoreId) throws CMException {
        int parentTenantId;
        CMStoreQueryResults toUpdate;
        CMStoreQueryResults childQuery;
        CMStoreQueryResults parentQuery;
        block7: {
            int parentId;
            block6: {
                CMStoreXPath childPath;
                block5: {
                    parentQuery = null;
                    childQuery = null;
                    toUpdate = null;
                    try {
                        CMStoreXPath parentPath = this.pathFactory.fromStoreID(parentStoreId);
                        childPath = this.pathFactory.fromStoreID(childStoreId);
                        childPath.setLockManagerUsageFlag(13);
                        this.lockManager.requestLocks(childPath);
                        this.store.beginTransaction();
                        parentQuery = this.store.executeQuery(parentPath, null, null, 0, 512, null);
                        if (parentQuery.next()) break block5;
                    }
                    catch (Throwable throwable) {
                        this.releaseQueryResults(parentQuery, childQuery, toUpdate);
                        this.store.rollbackOpenTransaction();
                        this.lockManager.releaseLocks();
                        throw throwable;
                    }
                    this.releaseQueryResults(parentQuery, childQuery, toUpdate);
                    this.store.rollbackOpenTransaction();
                    this.lockManager.releaseLocks();
                    return;
                }
                parentTenantId = parentQuery.getTenantID();
                parentId = parentQuery.getObjectID();
                childQuery = this.store.executeQuery(childPath, null, null, 7, 512, null);
                if (childQuery.next()) break block6;
                this.releaseQueryResults(parentQuery, childQuery, toUpdate);
                this.store.rollbackOpenTransaction();
                this.lockManager.releaseLocks();
                return;
            }
            int childTenantId = childQuery.getTenantID();
            int childParentId = childQuery.getParentObjectID();
            if (childParentId == parentId && !MultiTenancyUtils.isValidContainment(parentTenantId, childTenantId)) break block7;
            this.releaseQueryResults(parentQuery, childQuery, toUpdate);
            this.store.rollbackOpenTransaction();
            this.lockManager.releaseLocks();
            return;
        }
        String childSearchPath = childQuery.getSearchPath();
        String parentTenantIdString = this.tenantRegistry.getTenantIdStringFromInt(parentTenantId);
        CMStoreXPath queryPath = this.pathFactory.createCMStoreXPath("storeID('" + childStoreId + "')/descendant-or-self::*");
        toUpdate = this.store.executeQuery(queryPath, null, null, 7, 512, null);
        this.store.update(toUpdate, Arrays.asList(CMProperty.TENANTID), Arrays.asList(parentTenantIdString));
        this.store.commitTransaction();
        this.addRepairInfo(fixes, childSearchPath, parentTenantIdString);
        this.releaseQueryResults(parentQuery, childQuery, toUpdate);
        this.store.rollbackOpenTransaction();
        this.lockManager.releaseLocks();
    }

    protected void releaseQueryResults(CMStoreQueryResults ... results) {
        for (CMStoreQueryResults result : results) {
            if (result == null) continue;
            result.release();
        }
    }

    private void addRepairInfo(List<CMException> fixes, String searchPath, String tenantID) {
        fixes.add(new CMException("cmRepairInvalidTenantContainmentUpdate", new CMException.Parm("searchPath", searchPath), new CMException.Parm("tenantID", tenantID)));
    }
}

