/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multitenancy;

import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.server.CMExecutionContext;

public abstract class TenantIdCopyAction {
    private static TenantIdCopyAction KEEP = new Keep();
    private static TenantIdCopyAction SESSIONVIRTUALINHERITANCE = new SessionTenantIdFallbackOnInheritance();

    public static TenantIdCopyAction sessionFallbackVirtualInheritance() {
        return SESSIONVIRTUALINHERITANCE;
    }

    public static TenantIdCopyAction setTargetTenantId(int tenantId) {
        return new SetTargetTenantId(tenantId);
    }

    public static TenantIdCopyAction keep() {
        return KEEP;
    }

    public static TenantIdCopyAction setFallBackVirtualInheritance(int tenantId) {
        return new SetFallBackOnInheritance(tenantId);
    }

    public abstract int getTenantIdValue(int var1, int var2);

    public static class Keep
    extends TenantIdCopyAction {
        @Override
        public int getTenantIdValue(int parentTenantId, int sourceTenantId) {
            return sourceTenantId;
        }
    }

    public static class SetFallBackOnInheritance
    extends TenantIdCopyAction {
        private int tenantId;

        public SetFallBackOnInheritance(int tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public int getTenantIdValue(int parentTenantId, int sourceTenantId) {
            if (MultiTenancyUtils.isValidContainment(parentTenantId, sourceTenantId)) {
                return this.tenantId;
            }
            return parentTenantId;
        }
    }

    public static class SessionTenantIdFallbackOnInheritance
    extends TenantIdCopyAction {
        @Override
        public int getTenantIdValue(int parentTenantId, int sourceTenantId) {
            int result = CMExecutionContext.get().getCurrentUserTenantId();
            if (!MultiTenancyUtils.isValidContainment(parentTenantId, result)) {
                result = parentTenantId;
            }
            return result;
        }
    }

    public static class SetTargetTenantId
    extends TenantIdCopyAction {
        private int tenantId;

        public SetTargetTenantId(int tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public int getTenantIdValue(int parentTenantId, int sourceTenantId) {
            return this.tenantId;
        }

        public int getTargetTenantId() {
            return this.tenantId;
        }
    }
}

