/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.multitenancy;

import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.multitenancy.TenantIdUpdateValidatorNode;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCache;

public class TenantIdUpdateValidator {
    private CMCache cache;
    private TenantRegistry registry;
    protected TenantIdUpdateValidatorNode root;

    public TenantIdUpdateValidator(CMCache cache, TenantRegistry registry) {
        this.cache = cache;
        this.registry = registry;
    }

    public void addTenantIdUpdateNodeAndValidate(int objectId, int tenantIdUpdatingTo) throws CMException {
        this.validateTenancyOnParent(objectId, tenantIdUpdatingTo);
        int[] ancestors = this.cache.CMCacheGetAncestorObjects(objectId);
        if (ancestors.length == 0) {
            return;
        }
        if (this.root == null) {
            this.root = new TenantIdUpdateValidatorNode(ancestors[ancestors.length - 1], null);
        }
        TenantIdUpdateValidatorNode currentNode = this.root;
        for (int index = ancestors.length - 2; index >= 0; --index) {
            int currentId = ancestors[index];
            currentNode = currentNode.getChildWithIdCreateIfMissing(currentId);
            this.validateTenancy(objectId, tenantIdUpdatingTo, currentNode);
        }
        TenantIdUpdateValidatorNode node = currentNode.getChildWithIdCreateIfMissing(objectId);
        node.setTenantId(tenantIdUpdatingTo);
        if (node.hasChildren()) {
            this.validationTraversal(objectId, tenantIdUpdatingTo, node.getFirstChild());
        }
    }

    private void validateTenancyOnParent(int objectId, int tenantIdUpdatingTo) throws CMException {
        int parentTenantId;
        int parentId = this.cache.CMCacheGetParent(objectId);
        if (parentId != -1 && !MultiTenancyUtils.isValidContainment(parentTenantId = this.cache.CMCacheGetTenantID(parentId), tenantIdUpdatingTo)) {
            int[] locales = CMDbStoreCacheUtil.getCacheSearchLocales();
            String path = this.cache.CMCacheGetSearchPath(parentTenantId, locales);
            String tenantIdString = this.registry.getTenantIdStringFromInt(tenantIdUpdatingTo);
            String parentTenantString = this.registry.getTenantIdStringFromInt(parentTenantId);
            throw new CMException("cmInvalidTenantContainment", new CMException.Parm("tenant", tenantIdString), new CMException.Parm("path", path), new CMException.Parm("parentTenant", parentTenantString));
        }
    }

    private void validationTraversal(int updateOnObjectId, int tenantIdUpdatingTo, TenantIdUpdateValidatorNode node) throws CMException {
        if (node == null) {
            return;
        }
        this.validateTenancyForTraversal(updateOnObjectId, tenantIdUpdatingTo, node);
        this.validationTraversal(updateOnObjectId, tenantIdUpdatingTo, node.getSibling());
        this.validationTraversal(updateOnObjectId, tenantIdUpdatingTo, node.getFirstChild());
    }

    protected void throwContainmentException(int firstObjectId, int firstTenantId, int secondObjectId, int secondTenantId) throws CMException {
        int[] locales = CMDbStoreCacheUtil.getCacheSearchLocales();
        String firstObject = this.cache.CMCacheGetSearchPath(firstObjectId, locales);
        String firstTenantIdString = this.registry.getTenantIdStringFromInt(firstTenantId);
        String secondOebjct = this.cache.CMCacheGetSearchPath(secondObjectId, locales);
        String secondTenantIdString = this.registry.getTenantIdStringFromInt(secondTenantId);
        throw new CMException("cmConflictingUpdates", new CMException.Parm("firstObject", firstObject), new CMException.Parm("firstTenantID", firstTenantIdString), new CMException.Parm("secondObject", secondOebjct), new CMException.Parm("secondTenantID", secondTenantIdString));
    }

    private void validateTenancy(int updateOnObjectId, int tenantIdUpdatingTo, TenantIdUpdateValidatorNode currentNode) throws CMException {
        if (currentNode.isTenantIdSet() && !MultiTenancyUtils.isValidContainment(currentNode.getTenantId(), tenantIdUpdatingTo)) {
            this.throwContainmentException(updateOnObjectId, tenantIdUpdatingTo, currentNode.getObjectId(), currentNode.getTenantId());
        }
    }

    private void validateTenancyForTraversal(int updateOnObjectId, int tenantIdUpdatingTo, TenantIdUpdateValidatorNode currentNode) throws CMException {
        if (currentNode.isTenantIdSet() && !MultiTenancyUtils.isValidContainment(tenantIdUpdatingTo, currentNode.getTenantId())) {
            this.throwContainmentException(updateOnObjectId, tenantIdUpdatingTo, currentNode.getObjectId(), currentNode.getTenantId());
        }
    }
}

