/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.notification;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.notification.Notification;
import com.cognos.cm.notification.NotificationBuilder;
import com.cognos.cm.notification.Subscription;
import com.cognos.cm.notification.SubscriptionManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.InternalStoreId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotificationBuilderImpl
implements NotificationBuilder {
    private CMDbStore store_;

    public NotificationBuilderImpl(CMDbStore store) {
        this.store_ = store;
    }

    public NotificationBuilderImpl() {
        this(null);
    }

    @Override
    public List<Notification> getNotifications(CMObjectClass objClass, List<CMProperty> properties, String op, int cmid, int parentID, Map<String, Object> additionalParameters) throws CMException {
        ArrayList<Notification> parentNotifications;
        ArrayList<Notification> notifications = null;
        SubscriptionManager subscriptionManager = SubscriptionManager.getInstance();
        List<Subscription> activeSubscriptions = subscriptionManager.getSubscribedForThis(objClass, properties, op);
        if (activeSubscriptions != null) {
            for (int i = 0; i < activeSubscriptions.size(); ++i) {
                Subscription subscription = activeSubscriptions.get(i);
                Notification notification = this.createNotification(subscription, op, objClass, properties, cmid, parentID, false, additionalParameters);
                if (notifications == null) {
                    notifications = new ArrayList();
                }
                notifications.add(notification);
            }
        }
        if ((parentNotifications = this.getParentNotifications(objClass, subscriptionManager, parentID, op, additionalParameters)) != null) {
            if (notifications == null) {
                notifications = new ArrayList<Notification>();
            }
            notifications.addAll(parentNotifications);
        }
        return notifications;
    }

    protected ArrayList<Notification> getParentNotifications(CMObjectClass objClass, SubscriptionManager subscriptionManager, int parentID, String op, Map<String, Object> additionalParameters) throws CMException {
        ArrayList<Notification> notifications = null;
        ArrayList<ParentEntry> parentObjects = null;
        List<Subscription> parentSubscriptions = subscriptionManager.getSubscribedForParent(objClass);
        for (int i = 0; parentSubscriptions != null && i < parentSubscriptions.size(); ++i) {
            Subscription sub = parentSubscriptions.get(i);
            int parentSteps = sub.getParentNotificationSize(objClass);
            int currID = parentID;
            for (int currStep = 0; currStep < parentSteps && currID >= 0; ++currStep) {
                ParentEntry pObj;
                if (parentObjects == null || parentObjects.size() - 1 < currStep) {
                    pObj = this.buildParentEntry(currID);
                    if (parentObjects == null) {
                        parentObjects = new ArrayList<ParentEntry>();
                    }
                    parentObjects.add(pObj);
                } else {
                    pObj = (ParentEntry)parentObjects.get(currStep);
                }
                if (sub.containsClass(pObj.objClass_)) {
                    Notification notification = this.createNotification(sub, op, pObj.objClass_, null, pObj.cmid_, pObj.parentId_, true, additionalParameters);
                    if (notifications == null) {
                        notifications = new ArrayList<Notification>();
                    }
                    notifications.add(notification);
                }
                currID = pObj.parentId_;
            }
        }
        return notifications;
    }

    @Override
    public List<Notification> getNotifications(int[] objectIDs, int[] classIDs, List<CMProperty> properties, String op, Map<String, Object> additionalParameters) throws CMException {
        ArrayList<Notification> notifications = null;
        for (int i = 0; i < objectIDs.length && i < classIDs.length; ++i) {
            int parentID;
            CMObjectClass objectClass = this.store_.getObjectClasses().getClassByID(classIDs[i]);
            List<Notification> notificationsForOneObjClass = this.getNotifications(objectClass, properties, op, objectIDs[i], parentID = this.getParentObjectId(objectIDs[i]), additionalParameters);
            if (notificationsForOneObjClass == null || notificationsForOneObjClass.isEmpty()) continue;
            if (notifications == null) {
                notifications = new ArrayList<Notification>();
            }
            notifications.addAll(notificationsForOneObjClass);
        }
        return notifications;
    }

    protected Notification createNotification(Subscription subscription, String op, CMObjectClass oClass, List<CMProperty> properties, int cmid, int pID, boolean isParent, Map<String, Object> additionalParameters) throws CMException {
        String notifImpl = subscription.getNotificationImplementation();
        String storeID = null;
        String retPropParentStoreID = null;
        CMExecutionContext retPropExecContext = null;
        int parentClsId = -1;
        List<String> returnProps = subscription.getReturnPropertiesForOperation(op);
        for (int j = 0; j < returnProps.size(); ++j) {
            String retPropName = returnProps.get(j);
            if (retPropName.startsWith("$(parent)")) {
                CMProperty prop = oClass.getProperty(retPropName = retPropName.substring("$(parent)".length()));
                if (prop == CMProperty.STOREID) {
                    String parentStoreId = null;
                    if (pID < 0 || !InternalStoreId.validate(parentStoreId = this.store_.getCache().CMCacheGetStoreId(pID, true))) continue;
                    retPropParentStoreID = parentStoreId;
                    continue;
                }
                if (prop != CMProperty.OBJECTCLASS || pID < 0) continue;
                parentClsId = this.store_.getCache().CMCacheGetClass(pID);
                continue;
            }
            if (retPropName.startsWith("$(executioncontext)")) {
                retPropExecContext = (CMExecutionContext)CMExecutionContext.get().clone();
                continue;
            }
            if (retPropName.equals("$(internalStoreID)")) {
                storeID = this.getStoreID(cmid, true);
                continue;
            }
            if (!retPropName.equals("storeID")) continue;
            storeID = this.getStoreID(cmid, false);
        }
        if (op == "update" && properties != null) {
            String updateProperties = this.getPropertiesString(properties);
            additionalParameters.put("updateProperties", updateProperties);
        }
        Notification n = new Notification(oClass, op, storeID, retPropParentStoreID, returnProps, notifImpl, isParent, retPropExecContext, additionalParameters, parentClsId);
        n.setPassportID(CMExecutionContext.get().getAccManPassportID());
        return n;
    }

    private Notification createAuthenticationNotification(Subscription subscription, String action, String passportID) {
        String notifImpl = subscription.getNotificationImplementation();
        Notification notif = new Notification(null, action, null, null, null, notifImpl, false, null, new HashMap<String, Object>(), -1);
        notif.setPassportID(passportID);
        return notif;
    }

    private ParentEntry buildParentEntry(int parentID) throws CMException {
        int parentClassID = this.getClassId(parentID);
        CMObjectClass parentObjClass = this.getClassById(parentClassID);
        int parentsParentID = this.getParentObjectId(parentID);
        return new ParentEntry(parentObjClass, parentID, parentsParentID);
    }

    protected int getClassId(int objectID) throws CMException {
        return this.store_.getCache().CMCacheGetClass(objectID);
    }

    protected CMObjectClass getClassById(int classID) {
        return this.store_.getObjectClasses().getClassByID(classID);
    }

    protected String getStoreID(int objectId, boolean internal) throws CMException {
        return internal ? this.store_.getCache().CMCacheGetStoreId(objectId, true) : this.store_.getObjectStoreID(objectId);
    }

    protected int getParentObjectId(int objectID) throws CMException {
        return this.store_.getCache().CMCacheGetParent(objectID);
    }

    @Override
    public List<Notification> getAuthenticationNotifications(String action, String passportID) {
        ArrayList<Notification> notifications = null;
        SubscriptionManager subscriptionManager = SubscriptionManager.getInstance();
        List<Subscription> activeSubscriptions = subscriptionManager.getSubscribedForThis(action);
        if (activeSubscriptions != null) {
            for (int i = 0; i < activeSubscriptions.size(); ++i) {
                Subscription subscription = activeSubscriptions.get(i);
                Notification notification = this.createAuthenticationNotification(subscription, action, passportID);
                if (notifications == null) {
                    notifications = new ArrayList<Notification>();
                }
                notifications.add(notification);
            }
        }
        return notifications;
    }

    private String getPropertiesString(List<CMProperty> properties) {
        StringBuffer updateProperties = new StringBuffer();
        for (CMProperty prop : properties) {
            updateProperties.append(prop.getName());
            updateProperties.append(";");
        }
        return updateProperties.toString();
    }

    private static class ParentEntry {
        private CMObjectClass objClass_;
        private int cmid_;
        private int parentId_;

        private ParentEntry(CMObjectClass objClass, int cmid, int parentId) {
            this.objClass_ = objClass;
            this.cmid_ = cmid;
            this.parentId_ = parentId;
        }
    }
}

