/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.notification;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.notification.Notification;
import com.cognos.cm.notification.NotificationObserver;
import com.cognos.cm.notification.Subscription;
import com.cognos.cm.server.CMException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class NotificationManager {
    private static NotificationManager theNotificationManager = new NotificationManager();
    protected ConcurrentHashMap<String, NotificationObserver> observers = new ConcurrentHashMap();

    protected NotificationManager() {
    }

    public static NotificationManager getInstance() {
        return theNotificationManager;
    }

    public boolean addObserver(Subscription subscription) {
        String implementation = subscription.getNotificationImplementation();
        NotificationObserver observer = this.createObserver(implementation);
        if (observer != null) {
            observer.initialize(subscription);
            this.addObserver(implementation, observer);
            return true;
        }
        return false;
    }

    protected NotificationObserver createObserver(String notificationImplementation) {
        try {
            Class<?> cls = Class.forName(notificationImplementation);
            NotificationObserver observer = (NotificationObserver)cls.newInstance();
            return observer;
        }
        catch (Exception ex) {
            CMIndications.logException(new CMException(ex, "cmErrLoadingNotificationImpl", new CMException.Parm("Class", notificationImplementation)));
            return null;
        }
    }

    protected void addObserver(String notificationImplementation, NotificationObserver observer) {
        this.observers.put(notificationImplementation, observer);
        CMIndications.Audit_Info("cmNotificationObserverAdded", new CMException.Parm[]{new CMException.Parm("Observer", notificationImplementation)}, "Request");
    }

    public NotificationObserver getObserver(String notificationImplementation) {
        return this.observers.get(notificationImplementation);
    }

    public void removeObserver(String notificationImplementation) {
        if (this.observers.remove(notificationImplementation) != null) {
            CMIndications.Audit_Info("cmNotificationObserverRemoved", new CMException.Parm[]{new CMException.Parm("Observer", notificationImplementation)}, "Request");
        }
    }

    public void addNotifications(List<Notification> notifications) {
        for (NotificationObserver observer : this.observers.values()) {
            ArrayList<Notification> newNotifications = null;
            if (notifications.size() == 1) {
                Notification notif = notifications.get(0);
                if (!observer.getClass().getName().equals(notif.getNotificationImplementation())) continue;
                observer.addNotification(notif);
                continue;
            }
            for (int i = 0; i < notifications.size(); ++i) {
                Notification notif = notifications.get(i);
                if (!observer.getClass().getName().equals(notif.getNotificationImplementation())) continue;
                if (newNotifications == null) {
                    newNotifications = new ArrayList<Notification>();
                }
                newNotifications.add(notif);
            }
            if (newNotifications == null || newNotifications.size() <= 0) continue;
            observer.addNotifications(newNotifications);
        }
    }
}

