/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.notification;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ObjectClassObservable {
    private CMObjectClass objectClass;
    private Set<CMProperty> properties;
    private boolean includeSubclasses;
    private Set<CMObjectClass> cacheOfSubclasses = new HashSet<CMObjectClass>();

    public ObjectClassObservable(CMObjectClass objectClass) {
        this(objectClass, new HashSet<CMProperty>());
    }

    public ObjectClassObservable(CMObjectClass objectClass, Set<CMProperty> properties) {
        this.setObjectClass(objectClass);
        this.setProperties(properties);
    }

    public boolean isSatisfied(CMObjectClass objClass, List<CMProperty> properties) {
        if (this.checkObjectClass(objClass)) {
            return this.checkProperties(properties);
        }
        return false;
    }

    public boolean isObjectClassObserved(CMObjectClass objClass) {
        return this.checkObjectClass(objClass);
    }

    private boolean checkObjectClass(CMObjectClass objClass) {
        if (objClass == this.getObjectClass()) {
            return true;
        }
        return this.areSubclassesIncluded() && this.cacheOfSubclasses.contains(objClass);
    }

    private boolean checkProperties(List<CMProperty> properties) {
        if (this.hasProperties()) {
            if (properties == null) {
                return false;
            }
            if (!this.anyMatch(properties)) {
                return false;
            }
        }
        return true;
    }

    protected boolean anyMatch(List<CMProperty> properties) {
        for (CMProperty property : properties) {
            if (!this.containsProperty(property)) continue;
            return true;
        }
        return false;
    }

    public CMObjectClass getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(CMObjectClass objectClass) {
        this.objectClass = objectClass;
    }

    public boolean hasProperties() {
        return !this.getProperties().isEmpty();
    }

    protected void setProperties(Set<CMProperty> properties) {
        this.properties = properties;
    }

    public Set<CMProperty> getProperties() {
        if (this.properties == null) {
            return Collections.emptySet();
        }
        return this.properties;
    }

    public boolean containsProperty(CMProperty property) {
        return this.getProperties().contains(property);
    }

    public boolean areSubclassesIncluded() {
        return this.includeSubclasses;
    }

    public void setIncludeSubclasses(boolean includeSubclasses) {
        this.includeSubclasses = includeSubclasses;
        if (includeSubclasses) {
            this.cacheOfSubclasses.addAll(this.getObjectClass().getDerivedClasses());
        }
    }
}

