/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.notification;

import com.cognos.cm.notification.ObjectClassObservable;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class Subscription {
    private String name;
    private String notificationImplementation;
    protected HashMap<CMObjectClass, ObjectClassObservable> observedClasses;
    protected HashMap<String, List<String>> operationsMap;
    protected HashMap<CMObjectClass, Integer> parentNotificationSteps = null;
    protected int parentNotificationDefaultStep = 0;
    private String uri;
    private String soapAction;
    private List<String> serviceIds;
    private boolean enabled = false;

    public Subscription(String name, String notificationImplementation) {
        this.name = name;
        this.notificationImplementation = notificationImplementation;
        this.observedClasses = new HashMap();
        this.operationsMap = new HashMap();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable(boolean enable) {
        this.enabled = enable;
    }

    public boolean isSatisfied(CMObjectClass objClass, List<CMProperty> properties, String operation) {
        return this.containsOperation(operation) && this.checkObservablesSatisfied(objClass, properties, this.isOperationPropertySpecific(operation));
    }

    protected boolean containsOperation(String operation) {
        return this.operationsMap.containsKey(operation);
    }

    protected boolean checkObservablesSatisfied(CMObjectClass objClass, List<CMProperty> properties, boolean operationIsPropertySpecific) {
        for (ObjectClassObservable observable : this.observedClasses.values()) {
            if (!(operationIsPropertySpecific ? observable.isSatisfied(objClass, properties) : observable.isObjectClassObserved(objClass))) continue;
            return true;
        }
        return false;
    }

    protected boolean isOperationPropertySpecific(String operation) {
        return operation == "update";
    }

    public void addClass(CMObjectClass oClass) {
        this.addClassAndProperties(oClass, null, false);
    }

    public void addClassAndProperties(CMObjectClass oClass, Set<CMProperty> properties) {
        this.addClassAndProperties(oClass, properties, false);
    }

    public void addClassAndProperties(CMObjectClass oClass, Set<CMProperty> properties, boolean includeSubclasses) {
        ObjectClassObservable observable = new ObjectClassObservable(oClass, properties);
        observable.setIncludeSubclasses(includeSubclasses);
        this.observedClasses.put(oClass, observable);
    }

    public void addOperationAndReturnProperties(String operation, List<String> returnProperties) {
        if (returnProperties == null) {
            returnProperties = Collections.emptyList();
        }
        this.operationsMap.put(operation, returnProperties);
    }

    public List<String> getReturnPropertiesForOperation(String operation) {
        return this.operationsMap.get(operation);
    }

    public boolean containsClass(CMObjectClass oClass) {
        return this.observedClasses.containsKey(oClass);
    }

    public String getName() {
        return this.name;
    }

    public String getNotificationImplementation() {
        return this.notificationImplementation;
    }

    public void setNotificationImplementation(String notificationImplementation) {
        this.notificationImplementation = notificationImplementation;
    }

    public List<String> getServiceIds() {
        return this.serviceIds;
    }

    public void setServiceIds(List<String> serviceIds) {
        this.serviceIds = serviceIds;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public void setDefaultParentNotificationStep(int size) {
        this.parentNotificationDefaultStep = size;
    }

    public void setParentNotificationSteps(HashMap<CMObjectClass, Integer> levels) {
        this.parentNotificationSteps = levels;
    }

    public int getParentNotificationSize(CMObjectClass objectClass) {
        if (this.parentNotificationSteps != null && this.parentNotificationSteps.containsKey(objectClass)) {
            Integer level = this.parentNotificationSteps.get(objectClass);
            return level;
        }
        return this.parentNotificationDefaultStep;
    }
}

