/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.notification;

import com.cognos.cm.notification.NotificationManager;
import com.cognos.cm.notification.Operation;
import com.cognos.cm.notification.Subscription;
import com.cognos.cm.notification.SubscriptionParser;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SubscriptionManager {
    private static SubscriptionManager theSubscriptionManager = new SubscriptionManager();
    protected HashMap<String, Subscription> subscriptions = new HashMap();
    private final NotificationManager notificationManager;

    protected SubscriptionManager() {
        this(NotificationManager.getInstance());
    }

    protected SubscriptionManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public static SubscriptionManager getInstance() {
        return theSubscriptionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(CMResourceLoader resourceLoader, CMStore store) throws CMException {
        SubscriptionParser parser = new SubscriptionParser(resourceLoader, store);
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            this.subscriptions = parser.loadSubscriptions();
            if (!this.subscriptions.isEmpty()) {
                this.initializeObservers();
            }
        }
    }

    protected void initializeObservers() {
        ArrayList<String> invalidSubscriptionNames = null;
        for (Subscription subscription : this.subscriptions.values()) {
            if (this.notificationManager.addObserver(subscription)) continue;
            if (invalidSubscriptionNames == null) {
                invalidSubscriptionNames = new ArrayList<String>();
            }
            invalidSubscriptionNames.add(subscription.getName());
        }
        if (invalidSubscriptionNames != null) {
            this.removeSubscriptions(invalidSubscriptionNames);
        }
    }

    private void removeSubscriptions(ArrayList<String> invalidSubscriptionNames) {
        for (String name : invalidSubscriptionNames) {
            this.removeSubscription(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAllSubscritions(boolean enable) {
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            for (Subscription subscription : this.subscriptions.values()) {
                subscription.enable(enable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(Subscription subscription) {
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            if (this.notificationManager.getObserver(subscription.getNotificationImplementation()) == null && !this.notificationManager.addObserver(subscription)) {
                return;
            }
            this.subscriptions.put(subscription.getName(), subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription getSubscription(String name) {
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            return this.subscriptions.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(String name) {
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            Subscription subscription = this.subscriptions.get(name);
            if (subscription == null) {
                return;
            }
            String notificationImplementation = subscription.getNotificationImplementation();
            if (this.notificationManager.getObserver(notificationImplementation) != null) {
                this.notificationManager.removeObserver(notificationImplementation);
            }
            this.subscriptions.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Subscription> getSubscribedForThis(CMObjectClass objectClass, List<CMProperty> properties, String op) {
        ArrayList<Subscription> retSubscriptions = null;
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            for (Subscription subscription : this.subscriptions.values()) {
                if (!subscription.isEnabled() || !subscription.isSatisfied(objectClass, properties, op)) continue;
                if (retSubscriptions == null) {
                    retSubscriptions = new ArrayList<Subscription>();
                }
                retSubscriptions.add(subscription);
            }
        }
        return retSubscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Subscription> getSubscribedForThis(String operation) {
        ArrayList<Subscription> retSubscriptions = null;
        if (Operation.hasNoAssociatedClasses(operation)) {
            SubscriptionManager subscriptionManager = this;
            synchronized (subscriptionManager) {
                for (Subscription subscription : this.subscriptions.values()) {
                    if (!subscription.isEnabled() || !subscription.containsOperation(operation)) continue;
                    if (retSubscriptions == null) {
                        retSubscriptions = new ArrayList<Subscription>();
                    }
                    retSubscriptions.add(subscription);
                }
            }
        }
        return retSubscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Subscription> getSubscribedForParent(CMObjectClass objectClass) {
        ArrayList<Subscription> subs = null;
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            for (Subscription sub : this.subscriptions.values()) {
                if (!sub.isEnabled() || sub.getParentNotificationSize(objectClass) <= 0) continue;
                if (subs == null) {
                    subs = new ArrayList<Subscription>();
                }
                subs.add(sub);
            }
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubcribedTo(String name, CMObjectClass objClass) {
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            if (!this.subscriptions.containsKey(name)) {
                return false;
            }
            Subscription subscription = this.subscriptions.get(name);
            if (!subscription.isEnabled()) {
                return false;
            }
            return subscription.containsClass(objClass);
        }
    }
}

