/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.notification;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.notification.Operation;
import com.cognos.cm.notification.Subscription;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SubscriptionParser {
    private CMResourceLoader resourceLoader;
    private CMStore store;

    public SubscriptionParser(CMResourceLoader resLoader, CMStore store) {
        this.resourceLoader = resLoader;
        this.store = store;
    }

    public HashMap<String, Subscription> loadSubscriptions() throws CMException {
        HashMap<String, Subscription> subscriptions = new HashMap<String, Subscription>();
        String[] files = this.resourceLoader.listResourceNames("/WEB-INF/cm/subscriptions/");
        if (files == null) {
            CMIndications.Audit_Info("cmNoSubscriptions", null, "Request");
            return subscriptions;
        }
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (fileName == null || !fileName.endsWith(".xml")) continue;
            try {
                subscriptions.putAll(this.parseDescriptorFile("/WEB-INF/cm/subscriptions/" + fileName, true));
                continue;
            }
            catch (Throwable ex) {
                throw new CMException("cmErrParsingSubscriptionDesc", new CMException.Parm("Message", ex.getMessage()), new CMException.Parm("File", fileName));
            }
        }
        if (subscriptions.isEmpty()) {
            CMIndications.Audit_Info("cmNoSubscriptions", null, "Request");
        }
        return subscriptions;
    }

    public HashMap<String, Subscription> parseDescriptorFile(String fileName, boolean startup) throws CMException {
        Element rootNode = this.parseDocument(fileName);
        if (!rootNode.getName().equals("subscriptions")) {
            throw new CMException("cmBadConfigFile", new CMException.Parm("File", fileName));
        }
        return this.parseSubscriptionsElement(rootNode, startup);
    }

    public Subscription parseOneSubscriptionFromDescriptorFile(String subscriptionName, String fileName) throws CMException {
        Element rootNode = this.parseDocument(fileName);
        if (!rootNode.getName().equals("subscriptions")) {
            throw new CMException("cmBadConfigFile", new CMException.Parm("File", fileName));
        }
        Subscription subscription = this.parseOneSubscriptionFromSubscriptionsElement(rootNode, subscriptionName);
        if (subscription == null) {
            throw new CMException("cmBadConfigFile", new CMException.Parm("File", fileName));
        }
        return subscription;
    }

    protected Element parseDocument(String fileName) throws CMException {
        if (fileName == null) {
            throw new CMException("cmNoConfigFile", new CMException.Parm("File", fileName));
        }
        CMIndications.Audit_Info("cmLoadingSubscriptionFile", new CMException.Parm[]{new CMException.Parm("File", fileName)}, "Request");
        InputStream descriptorStream = this.resourceLoader.getResourceInputStream(fileName);
        if (descriptorStream == null) {
            throw new CMException("cmNoConfigFile", new CMException.Parm("File", fileName));
        }
        try {
            SAXReader reader = new SAXReader();
            Document descDoc = reader.read(descriptorStream);
            descriptorStream.close();
            return descDoc.getRootElement();
        }
        catch (Exception ex) {
            throw new CMException("cmBadConfigFile", new CMException.Parm("File", fileName));
        }
    }

    protected Subscription parseOneSubscriptionFromSubscriptionsElement(Element subscriptionsEl, String subscriptionName) throws CMException {
        Subscription subscription = null;
        List subscriptionList = subscriptionsEl.elements("subscription");
        for (int i = 0; i < subscriptionList.size(); ++i) {
            Element subscriptionEl = (Element)subscriptionList.get(i);
            String name = subscriptionEl.attributeValue("name");
            if (name == null || !name.equals(subscriptionName)) continue;
            subscription = this.parseSubscriptionElement(subscriptionEl, false);
            break;
        }
        return subscription;
    }

    protected HashMap<String, Subscription> parseSubscriptionsElement(Element subscriptionsEl, boolean startup) throws CMException {
        HashMap<String, Subscription> subscriptions = new HashMap<String, Subscription>();
        List subscriptionList = subscriptionsEl.elements("subscription");
        for (int i = 0; i < subscriptionList.size(); ++i) {
            Element subscriptionEl = (Element)subscriptionList.get(i);
            Subscription subscription = this.parseSubscriptionElement(subscriptionEl, startup);
            if (subscription == null) continue;
            subscriptions.put(subscription.getName(), subscription);
        }
        return subscriptions;
    }

    protected Subscription parseSubscriptionElement(Element subscrEl, boolean startup) throws CMException {
        if (subscrEl == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "subscription"), new CMException.Parm("Parent", "subscriptions"));
        }
        String name = subscrEl.attributeValue("name");
        if (name == null || name.length() <= 0) {
            throw new CMException("cmExpectedAttributeMissing", new CMException.Parm("Name", "name"), new CMException.Parm("Element", "subscription"));
        }
        if (startup) {
            boolean loadOnStartup = true;
            String loadOnStartupString = subscrEl.attributeValue("loadOnStartup");
            if (loadOnStartupString != null && !(loadOnStartup = Boolean.parseBoolean(loadOnStartupString))) {
                return null;
            }
        }
        Subscription subscription = new Subscription(name, "");
        Element observableEl = subscrEl.element("observable");
        this.parseObservableElement(observableEl, subscription);
        Element observerEl = subscrEl.element("observer");
        this.parseObserverElement(observerEl, subscription);
        return subscription;
    }

    private void parseObservableElement(Element observableEl, Subscription subscription) throws CMException {
        if (observableEl == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "observable"), new CMException.Parm("Parent", "subscription"));
        }
        Element classesEl = observableEl.element("classes");
        this.parseClassesElement(classesEl, subscription);
        Element parentNotifiedClasses = observableEl.element("parentNotifiedClasses");
        this.parseParentNotifiedClassesElement(parentNotifiedClasses, subscription);
        Element defaultParentNotifEl = observableEl.element("defaultParentNotification");
        this.parseDefaultParentNotificationElement(defaultParentNotifEl, subscription);
        Element operationsEl = observableEl.element("operations");
        this.parseOperationsElement(operationsEl, subscription);
    }

    private void parseClassesElement(Element classesEl, Subscription subscription) throws CMException {
        if (classesEl == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "classes"), new CMException.Parm("Parent", "observable"));
        }
        List classes = classesEl.elements("class");
        if (classes.size() <= 0) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "class"), new CMException.Parm("Parent", "classes"));
        }
        CMPropertySet propSet = this.store.getPropertySets().getPropertySet();
        for (int i = 0; i < classes.size(); ++i) {
            Element classEl = (Element)classes.get(i);
            String className = classEl.elementText("name");
            if (className == null || className.length() <= 0) {
                throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "name"), new CMException.Parm("Parent", "class"));
            }
            CMObjectClass oClass = this.store.getObjectClasses().getClassByName(className);
            if (oClass == null) {
                throw new CMException("cmInvalidObjectClass", new CMException.Parm("Class", className));
            }
            HashSet<CMProperty> properties = null;
            Element propsEl = classEl.element("properties");
            if (propsEl != null) {
                properties = new HashSet<CMProperty>();
                List propElList = propsEl.elements("property");
                for (int j = 0; j < propElList.size(); ++j) {
                    Element propertyEl = (Element)propElList.get(j);
                    properties.add(propSet.getProperty(propertyEl.getText(), oClass));
                }
            }
            String includeSubclassesString = classEl.elementText("includeSubclasses");
            boolean includeSubclasses = Boolean.parseBoolean(includeSubclassesString);
            subscription.addClassAndProperties(oClass, properties, includeSubclasses);
        }
    }

    private void parseParentNotifiedClassesElement(Element parentNotifiedClasses, Subscription subscription) throws CMException {
        if (parentNotifiedClasses == null) {
            return;
        }
        HashMap<CMObjectClass, Integer> parentNotifiedLevels = new HashMap<CMObjectClass, Integer>();
        List pNotifiedClasses = parentNotifiedClasses.elements("class");
        for (int i = 0; i < pNotifiedClasses.size(); ++i) {
            Element classEl = (Element)pNotifiedClasses.get(i);
            String className = classEl.elementText("name");
            if (className == null || className.length() <= 0) {
                throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "name"), new CMException.Parm("Parent", "parentNotifiedClasses"));
            }
            CMObjectClass oClass = this.store.getObjectClasses().getClassByName(className);
            String parentLevel = classEl.elementText("steps");
            if (parentLevel == null || parentLevel.length() <= 0) {
                throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "steps"), new CMException.Parm("Parent", "parentNotifiedClasses"));
            }
            parentNotifiedLevels.put(oClass, Integer.valueOf(parentLevel));
        }
        subscription.setParentNotificationSteps(parentNotifiedLevels);
    }

    private void parseDefaultParentNotificationElement(Element defaultParentNotifEl, Subscription subscription) {
        if (defaultParentNotifEl == null) {
            return;
        }
        String parentNotificationLevel = defaultParentNotifEl.getText();
        int pNotifLevel = Integer.valueOf(parentNotificationLevel);
        subscription.setDefaultParentNotificationStep(pNotifLevel);
    }

    private void parseOperationsElement(Element operationsEl, Subscription subscription) throws CMException {
        if (operationsEl == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "operations"), new CMException.Parm("Parent", "observable"));
        }
        List operations = operationsEl.elements("operation");
        if (operations.size() <= 0) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "operation"), new CMException.Parm("Parent", "operations"));
        }
        for (int i = 0; i < operations.size(); ++i) {
            Element opEl = (Element)operations.get(i);
            String opName = opEl.elementText("name");
            String operation = Operation.get(opName);
            if (operation == null) {
                throw new CMException("cmInvalidOperation", new CMException.Parm("Operation", opName));
            }
            ArrayList<String> returnProperties = new ArrayList<String>();
            Element retPropsEl = opEl.element("returnProperties");
            if (retPropsEl != null) {
                List retPropsList = retPropsEl.elements("returnProperty");
                for (int j = 0; j < retPropsList.size(); ++j) {
                    Element retPropEl = (Element)retPropsList.get(j);
                    returnProperties.add(retPropEl.getText());
                }
            }
            subscription.addOperationAndReturnProperties(operation, returnProperties);
        }
    }

    private void parseObserverElement(Element observerEl, Subscription subscription) throws CMException {
        if (observerEl == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "observer"), new CMException.Parm("Parent", "subscription"));
        }
        this.parseServicesElement(observerEl.element("services"), subscription);
        subscription.setUri(observerEl.elementText("URI"));
        subscription.setSoapAction(observerEl.elementText("SoapAction"));
        this.parseNotificationImplementationElement(observerEl, subscription);
    }

    private void parseServicesElement(Element servicesEl, Subscription subscription) {
        if (servicesEl == null) {
            return;
        }
        ArrayList<String> serviceIds = new ArrayList<String>();
        List serviceIdsList = servicesEl.elements("serviceId");
        for (int i = 0; i < serviceIdsList.size(); ++i) {
            Element serviceId = (Element)serviceIdsList.get(i);
            serviceIds.add(serviceId.getText());
        }
        subscription.setServiceIds(serviceIds);
    }

    private void parseNotificationImplementationElement(Element observerEl, Subscription subscription) throws CMException {
        String notificationImpl = observerEl.elementText("notificationImplementation");
        if (notificationImpl == null || notificationImpl.length() <= 0) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", "notificationImplementation"), new CMException.Parm("Parent", "observer"));
        }
        subscription.setNotificationImplementation(notificationImpl);
    }
}

