/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.notification.observers;

import com.cognos.cm.notification.Notification;
import com.cognos.cm.notification.NotificationObserver;
import com.cognos.cm.notification.Subscription;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AsyncNotificationObserver
implements NotificationObserver {
    private LinkedBlockingQueue<Notification> queue = new LinkedBlockingQueue();
    private AsynchNotificationThread thread = new AsynchNotificationThread();

    public AsyncNotificationObserver() {
        this.thread.start();
    }

    @Override
    public abstract void initialize(Subscription var1);

    @Override
    public abstract void enable(boolean var1);

    @Override
    public void addNotification(Notification notification) {
        this.put(notification);
    }

    @Override
    public void addNotifications(ArrayList<Notification> notifications) {
        for (int i = 0; i < notifications.size(); ++i) {
            Notification notification = notifications.get(i);
            this.put(notification);
        }
    }

    protected abstract void sendNotification(Notification var1);

    private void put(Notification notification) {
        try {
            this.queue.put(notification);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void send() {
        try {
            Notification notification = this.queue.take();
            this.sendNotification(notification);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private class AsynchNotificationThread
    extends Thread {
        private volatile boolean bRun = true;

        @Override
        public void run() {
            while (this.bRun) {
                AsyncNotificationObserver.this.send();
            }
        }

        public void terminate() {
            this.bRun = false;
            this.interrupt();
        }
    }
}

