/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.JNI;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMXMLUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class FMUpgradePluginJNI
implements CMUpgradePlugin {
    private static boolean bLibraryLoaded_;
    public static final String UPGRADE_ERROR_IN_JNI = "UPGRADE_ERROR";
    private static final Map<String, List<String>> optionsMap;
    private static List<String> supportedStudios;
    private static final String ROOT_OPTIONS = "upgradeOptions";

    public native boolean initializeImpl();

    public native boolean terminateImpl();

    public native int[] upgradeDataImpl(Map<String, String> var1);

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        if (!bLibraryLoaded_ && desc != null) {
            try {
                String libName = desc.getCLibName();
                if (libName != null && libName.length() > 0) {
                    System.loadLibrary(libName);
                    if (!this.initializeImpl()) {
                        throw new Exception("Failed to initialize in FM Upgrade plugin");
                    }
                    bLibraryLoaded_ = true;
                }
            }
            catch (UnsatisfiedLinkError exLink) {
                throw exLink;
            }
            catch (SecurityException exLink) {
                throw exLink;
            }
        }
    }

    public void terminate() throws Exception {
        if (!this.terminateImpl()) {
            throw new Exception("Failed to terminate in FM Upgrade plugin");
        }
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        CMUpgradeMessage msg;
        CMUpgradeResult result = null;
        if (!bLibraryLoaded_) {
            return null;
        }
        if (data == null) {
            return null;
        }
        Map theData = data.getData();
        if (theData == null) {
            return null;
        }
        Object[] options = optionsMap.keySet().toArray();
        String optionsXML = this.buildOptionsXML(options);
        theData.put("FMUpgrade_Options", optionsXML);
        int[] upgradeResult = this.upgradeDataImpl(theData);
        int severity = 40000;
        String errorMessage = null;
        String modelSearchPath = this.getPropertyValue(data, "searchPath");
        String packageSearchPath = null;
        CMException cmEX = null;
        if (modelSearchPath != null) {
            try {
                CMStoreXPath modelPath = new CMStoreXPath(modelSearchPath);
                packageSearchPath = modelPath.getSubpath(modelPath.size() - 1);
                this.upgradePackage(data, packageSearchPath);
            }
            catch (Exception e) {
                cmEX = new CMException(e, "cmUpgradePackageFailed", new CMException.Parm("studio", "powerPlayStudio"), new CMException.Parm("name", "userInterfaces"), new CMException.Parm("PATH", packageSearchPath));
            }
            catch (Throwable t) {
                cmEX = new CMException(t, "cmUpgradePackageFailed", new CMException.Parm("studio", "powerPlayStudio"), new CMException.Parm("name", "userInterfaces"), new CMException.Parm("PATH", packageSearchPath));
            }
        } else {
            errorMessage = "Missing searchPath in Plugin Descriptor";
        }
        if (cmEX != null) {
            errorMessage = cmEX.getFullMessage();
        }
        theData.remove("FMUpgrade_Options");
        result = new CMUpgradeResult();
        result.setData(theData);
        ArrayList<CMUpgradeMessage> errorMsgs = new ArrayList<CMUpgradeMessage>();
        if (errorMessage != null) {
            msg = new CMUpgradeMessage(errorMessage, severity);
            errorMsgs.add(msg);
        }
        if (theData.get(UPGRADE_ERROR_IN_JNI) != null) {
            msg = new CMUpgradeMessage((String)theData.get(UPGRADE_ERROR_IN_JNI), severity);
            errorMsgs.add(msg);
            theData.remove(UPGRADE_ERROR_IN_JNI);
        }
        if (errorMsgs.size() > 0) {
            result.setMessages(errorMsgs);
        }
        if (upgradeResult != null) {
            result.setUpgradeStatus(upgradeResult[0]);
            result.setNextAction(upgradeResult[1]);
        }
        return result;
    }

    private void upgradePackage(CMUpgradeData data, String searchPath) throws CMException, Exception {
        boolean bDoPackageUpgrade;
        String errorMessage = null;
        Map theData = data.getData();
        List<String> userInterfacesToAdd = this.getUserInterfacesToAdd((String)theData.get("FMUpgrade_Options"));
        boolean bl = bDoPackageUpgrade = userInterfacesToAdd != null && userInterfacesToAdd.size() > 0;
        if (bDoPackageUpgrade) {
            boolean abortUpgrade = false;
            boolean stopCurUpgrade = false;
            String query2 = this.buildQuery(searchPath, new String[]{"userInterfaces"});
            String response = ContentManager.getInstance().ExecuteStaticRequest(query2, false, true);
            if (response == null) {
                abortUpgrade = true;
                stopCurUpgrade = true;
                errorMessage = "CM has been shutdown. Abort data upgrade!";
            } else if (response.indexOf("<SOAP-ENV:Fault") != -1) {
                stopCurUpgrade = true;
                errorMessage = response;
            }
            if (!abortUpgrade && !stopCurUpgrade) {
                List<String> userInterfaces = this.extractUserInterfacesFromResponseXML(response);
                for (int i = 0; i < userInterfacesToAdd.size(); ++i) {
                    String userInterface = userInterfacesToAdd.get(i);
                    if (userInterfaces.contains(userInterface)) continue;
                    List<String> studiosToAdd = optionsMap.get(userInterface);
                    for (String studioEnum : studiosToAdd) {
                        userInterfaces.add(studioEnum);
                    }
                }
                String update2 = this.buildUpdatePackageUserInterfaces(searchPath, userInterfaces);
                response = ContentManager.getInstance().ExecuteStaticRequest(update2, false, true);
                if (response == null) {
                    abortUpgrade = true;
                    errorMessage = "CM has been shutdown. Abort data upgrade!";
                } else if (response.indexOf("<SOAP-ENV:Fault") != -1) {
                    errorMessage = response;
                }
            }
        }
        if (errorMessage != null) {
            throw new Exception(errorMessage);
        }
    }

    private String buildQuery(String searchPath, String[] properties) {
        StringBuffer gather = new StringBuffer();
        gather.append("<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n").append("\t<search xsi:type=\"xsd:string\">").append(searchPath).append("</search>\n\t<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[").append(properties.length).append("]\">\n");
        for (int i = 0; i < properties.length; ++i) {
            gather.append("\t\t<item xsi:type=\"cm:propEnum\">").append(properties[i]).append("</item>\n");
        }
        gather.append("\t</properties>\n</cm:query>");
        return gather.toString();
    }

    private String buildUpdatePackageUserInterfaces(String searchPath, List<String> userInterfaces) {
        StringBuffer gather = new StringBuffer();
        gather.append("<cm:update xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n").append("\t<objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:baseClass[1]\">\n\t\t<item xsi:type=\"cm:package\">\n\t\t\t<searchPath xsi:type=\"cm:stringProp\">\n\t\t\t\t<value xsi:type=\"xsi:string\">").append(searchPath).append("</value>\n\t\t\t</searchPath>\n\t\t\t<userInterfaces xsi:type=\"cm:uiComponentEnumArrayProp\">\n\t\t\t\t<value xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:uiComponentEnum[").append(userInterfaces.size()).append("]\">\n");
        for (int i = 0; i < userInterfaces.size(); ++i) {
            gather.append("\t\t\t\t\t<item xsi:type=\"cm:uiComponentEnum\">").append(userInterfaces.get(i)).append("</item>\n");
        }
        gather.append("\t\t\t\t</value>\n\t\t\t</userInterfaces>\n\t\t</item>\n\t</objects>\n</cm:update>");
        return gather.toString();
    }

    private String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }

    private List<String> extractUserInterfacesFromResponseXML(String response) throws Exception {
        Document document;
        ArrayList<String> toReturn = new ArrayList<String>();
        SAXReader reader = new SAXReader();
        try {
            document = reader.read((Reader)new StringReader(response));
        }
        catch (DocumentException e) {
            throw new Exception("Response is not valid XML");
        }
        try {
            Element soapBodyEle = document.getRootElement().element("Body");
            Element queryResponseEle = soapBodyEle.element("queryResponse");
            Element queryResultEle = queryResponseEle.element("queryResult");
            Element queryResultItemEle = queryResultEle.element("item");
            Element userInterfacesEle = queryResultItemEle.element("userInterfaces");
            Element valueEle = userInterfacesEle.element("value");
            if (valueEle == null) {
                return toReturn;
            }
            List userIterfaceItems = valueEle.elements("item");
            for (int i = 0; i < userIterfaceItems.size(); ++i) {
                toReturn.add(((Node)userIterfaceItems.get(i)).getText().trim());
            }
            return toReturn;
        }
        catch (NullPointerException e) {
            throw new Exception("Unable to parse XML");
        }
    }

    private String buildOptionsXML(Object[] options) {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(ROOT_OPTIONS);
        buf.append(">");
        for (int i = 0; i < options.length; ++i) {
            buf.append("<");
            buf.append((String)options[i]);
            buf.append("/>");
        }
        buf.append("</");
        buf.append(ROOT_OPTIONS);
        buf.append(">");
        return buf.toString();
    }

    private List<String> getUserInterfacesToAdd(String optionsXML) throws CMException {
        ArrayList<String> ret = new ArrayList<String>();
        XMLDocParser parser = new XMLDocParser();
        XMLDoc xmlDoc = null;
        try {
            xmlDoc = parser.readXML(optionsXML);
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedToParseXMLString", new CMException.Parm("String", optionsXML));
        }
        XMLElement rootEl = null;
        if (xmlDoc != null && xmlDoc.baseElement_ != null) {
            rootEl = xmlDoc.getRootXMLElement();
        }
        if (rootEl != null) {
            String[] optionsArray = optionsMap.keySet().toArray(new String[0]);
            for (int i = 0; i < optionsArray.length; ++i) {
                String value;
                XMLElement option = rootEl.getChildWithName(optionsArray[i]);
                if (option == null || !CMXMLUtils.isBooleanAttrTrue(value = option.value_)) continue;
                ret.add(optionsArray[i]);
            }
        }
        return ret;
    }

    static {
        optionsMap = new HashMap<String, List<String>>();
        supportedStudios = new ArrayList<String>();
        supportedStudios.add("powerPlayStudio");
        optionsMap.put("isPowercube", supportedStudios);
    }
}

