/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.ans;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.qfw.V4toV5.IntraBeringMunConversion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ANSUpgrade
implements CMUpgradePlugin {
    private static final String PROP_SPECIFICATION = "specification";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static String UPGRADE_TEMPLATE = "ANSUpgrade.xsl";
    private static String COLLECTUPGRADEMUNS_TEMPLATE = "ANSCollectUpgradeMuns.xsl";
    private static String MERGEUPGRADEMUNS_TEMPLATE = "ANSMergeUpgradeMuns.xsl";
    private static TransformerFactory tFactory = null;
    private static Templates upgradeTemplate = null;
    private static Templates collectUpgradeMunsTemplate = null;
    private static Templates mergeUpgradeMunsTemplate = null;

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration cfg) throws Exception {
        if (tFactory == null || upgradeTemplate == null) {
            String str;
            String sUpgradeTemplate = UPGRADE_TEMPLATE;
            if (desc != null && (str = desc.getCLibName()) != null) {
                sUpgradeTemplate = str;
            }
            try {
                tFactory = TransformerFactory.newInstance();
                if (cfg != null) {
                    String folder = cfg.resolveEffectivePath(".." + File.separator + "bin");
                    File libFile = new File(folder, sUpgradeTemplate);
                    if (!libFile.exists()) {
                        throw new Exception("Upgrade template \"" + sUpgradeTemplate + "\" is missing");
                    }
                    upgradeTemplate = tFactory.newTemplates(new StreamSource(libFile));
                } else {
                    upgradeTemplate = tFactory.newTemplates(new StreamSource(new File(sUpgradeTemplate)));
                }
            }
            catch (TransformerConfigurationException e) {
                throw new Exception("Failed to parse upgrade template \"" + sUpgradeTemplate + "\".");
            }
            collectUpgradeMunsTemplate = this.initializeTemplate(cfg, COLLECTUPGRADEMUNS_TEMPLATE);
            mergeUpgradeMunsTemplate = this.initializeTemplate(cfg, MERGEUPGRADEMUNS_TEMPLATE);
        }
    }

    public void terminate() throws Exception {
    }

    public Templates initializeTemplate(ICCLConfiguration cfg, String sTemplate) throws Exception {
        Templates template;
        try {
            if (tFactory == null) {
                tFactory = TransformerFactory.newInstance();
            }
            if (cfg != null) {
                String folder = cfg.resolveEffectivePath(".." + File.separator + "bin");
                File libFile = new File(folder, sTemplate);
                if (!libFile.exists()) {
                    throw new Exception("template \"" + sTemplate + "\" is missing");
                }
                template = tFactory.newTemplates(new StreamSource(libFile));
            } else {
                template = tFactory.newTemplates(new StreamSource(new File(sTemplate)));
            }
        }
        catch (TransformerConfigurationException e) {
            throw new Exception("Failed to parse template \"" + sTemplate + "\".");
        }
        return template;
    }

    public static String upgradeHLS(String sCMAnalysisHLS) throws Exception {
        float fSchema = ANSUpgrade.getHlsSchemaVersion(sCMAnalysisHLS);
        String sUpgradeHLS = ANSUpgrade.migrate(sCMAnalysisHLS);
        if (fSchema < 0.105f) {
            Element resMembersElem;
            String sUpgradeMunsReq = ANSUpgrade.collectUpgradeMuns(sUpgradeHLS);
            Document upgradeMunsRequestDoc = DocumentHelper.parseText((String)sUpgradeMunsReq);
            Element reqRootElem = upgradeMunsRequestDoc.getRootElement();
            Element reqMembersElem = (Element)reqRootElem.elements("members").get(0);
            Element resRootElem = null;
            if (reqMembersElem != null && !reqMembersElem.elements().isEmpty()) {
                IntraBeringMunConversion theConverter = new IntraBeringMunConversion();
                String sResponse = theConverter.doMUNListConversion(sUpgradeMunsReq);
                Document upgradeMunsResponseDoc = DocumentHelper.parseText((String)sResponse);
                resRootElem = upgradeMunsResponseDoc.getRootElement();
            }
            if (resRootElem != null && (resMembersElem = (Element)resRootElem.elements("members").get(0)) != null && !resMembersElem.elements().isEmpty()) {
                Document upgradeHlsDoc = DocumentHelper.parseText((String)sUpgradeHLS);
                Element upgradeHlsRootElem = upgradeHlsDoc.getRootElement();
                upgradeHlsRootElem.add(resRootElem);
                sUpgradeHLS = upgradeHlsRootElem.asXML();
                sUpgradeHLS = ANSUpgrade.mergeUpgradeMuns(sUpgradeHLS);
            }
        }
        return sUpgradeHLS;
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String sCMAnalysisHLS = (String)data.getPropertyValue(PROP_SPECIFICATION);
        if (sCMAnalysisHLS == null) {
            return null;
        }
        CMUpgradeResult result = new CMUpgradeResult();
        String sUpgradeHLS = ANSUpgrade.upgradeHLS(sCMAnalysisHLS);
        HashMap<String, String> mapV5Spec = new HashMap<String, String>();
        mapV5Spec.put(PROP_SPECIFICATION, sUpgradeHLS);
        result.setData(mapV5Spec);
        result.setUpgradeStatus(1);
        result.setNextAction(1);
        return result;
    }

    private static float getHlsSchemaVersion(String sCMAnalysisHLS) throws Exception {
        String schemaVersion = "";
        Document hlsDoc = DocumentHelper.parseText((String)sCMAnalysisHLS);
        Element hlsRootElem = hlsDoc.getRootElement();
        if (hlsRootElem.getQualifiedName() == "analysisReport") {
            schemaVersion = hlsRootElem.attributeValue("schemaVersion");
        } else if (hlsRootElem.getQualifiedName() == "PersistHLS") {
            Element analysisElem = (Element)hlsRootElem.elements("analysisReport").get(0);
            schemaVersion = analysisElem.attributeValue("schemaVersion");
        }
        return Float.parseFloat(schemaVersion);
    }

    private static String transform(String sSrc, Templates template) throws Exception {
        Transformer transformer = template.newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(sSrc)), new StreamResult(writer));
        return writer.toString();
    }

    private static String migrate(String sHLS) throws Exception {
        return ANSUpgrade.transform(sHLS, upgradeTemplate);
    }

    private static String collectUpgradeMuns(String sHLS) throws Exception {
        return ANSUpgrade.transform(sHLS, collectUpgradeMunsTemplate);
    }

    private static String mergeUpgradeMuns(String sHLS) throws Exception {
        return ANSUpgrade.transform(sHLS, mergeUpgradeMunsTemplate);
    }

    public static String readWithStringBuffer(Reader fr) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(fr);
        StringBuffer result = new StringBuffer();
        while ((line = br.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        try {
            String[] fileNames;
            if (args.length < 2 || args[0].equals("-h")) {
                System.out.println("\nUsage:\n\tjava com.cognos.cm.plugin.ans.ANSUpgrade SOURCEDIR DESTDIR [FILE]\n");
                System.out.println("SOURCEDIR: directory where the analysis exists");
                System.out.println("DESTDIR: directory to write out upgraded analysis. It should be different from the SOURCEDIR");
                System.out.println("FILE: input analysis specification file name, otherwise all xml files under SOURCEDIR will be upgraded");
                System.exit(1);
            }
            String sSrcDir = args[0];
            String sDestDir = args[1];
            String sFile = null;
            if (args.length > 2) {
                sFile = args[2];
            }
            ANSUpgrade ansupgrade = new ANSUpgrade();
            ansupgrade.initialize(null, null);
            if (sFile != null) {
                fileNames = new String[]{sFile};
            } else {
                File srcDir = new File(sSrcDir);
                fileNames = srcDir.list();
            }
            File desDir = new File(sDestDir);
            if (!desDir.exists()) {
                desDir.mkdirs();
            }
            for (int i = 0; i < fileNames.length; ++i) {
                if (!fileNames[i].endsWith(".xml")) continue;
                StringBuffer sbSrc = new StringBuffer(sSrcDir);
                String sSrcFile = sbSrc.append(FILE_SEPARATOR).append(fileNames[i]).toString();
                StringBuffer sbDest = new StringBuffer(sDestDir);
                String sDestFile = sbDest.append(FILE_SEPARATOR).append(fileNames[i]).toString();
                String sOldHLS = ANSUpgrade.readWithStringBuffer(new FileReader(sSrcFile));
                String sResult = ANSUpgrade.upgradeHLS(sOldHLS);
                BufferedWriter bw = new BufferedWriter(new FileWriter(sDestFile));
                bw.write(sResult);
                bw.flush();
                bw.close();
                System.out.println("Migration successful!\nResult in " + sDestFile);
                System.out.println("---------------------------------------------");
            }
            ansupgrade.terminate();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

