/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.baltic;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;

public class AddInclusiveToParameterValues
implements CMUpgradePlugin {
    static final String hierarchicalParmValueItemType = "hierarchicalParmValueItem";
    private static final String[] PARAMETER_TYPES = new String[]{"boundRangeParmValueItem", "hierarchicalParmValueItem", "simpleParmValueItem", "unboundedEndRangeParmValueItem", "unboundedStartRangeParmValueItem"};
    static final String INCLUSIVE_ELEMENT_NAME = "inclusive";
    static final String START_ELEMENT_NAME = "start";
    static final String END_ELEMENT_NAME = "end";

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String errorMessage = null;
        if (data == null) {
            return null;
        }
        String parameters = (String)data.getPropertyValue("parameters");
        if (parameters == null || parameters.length() == 0) {
            return null;
        }
        String upgradedParameters = null;
        try {
            XMLElement parametersValueEl;
            XMLElement parametersEl;
            XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(parameters);
            if (rootEl != null && (parametersEl = rootEl.getChild(0)) != null && (parametersValueEl = parametersEl.getOptionalChildWithName("value")) != null && parametersValueEl.children_ != null) {
                if (!this.upgradeParametersValue(parametersValueEl.children_)) {
                    return null;
                }
                upgradedParameters = parametersEl.makeXML("", true, false, false);
            }
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else {
            if (upgradedParameters != null) {
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put("parameters", upgradedParameters);
                result.setData(upgradedData);
            }
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }

    private boolean upgradeParametersValue(List<XMLElement> parameterValues) {
        if (parameterValues == null) {
            return false;
        }
        boolean upgraded = false;
        for (XMLElement parameterValueItemEl : parameterValues) {
            upgraded |= this.upgradeOneParameter(parameterValueItemEl);
        }
        return upgraded;
    }

    private boolean upgradeOneParameter(XMLElement parameterValue) {
        if (parameterValue == null) {
            return false;
        }
        boolean upgraded = false;
        XMLElement valueEl = parameterValue.getOptionalChildWithName("value");
        if (valueEl != null && valueEl.children_ != null) {
            upgraded = this.upgradeParameterItemValues(valueEl.children_);
        }
        return upgraded;
    }

    private boolean upgradeParameterItemValues(List<XMLElement> parameterValueItems) {
        if (parameterValueItems == null) {
            return false;
        }
        boolean upgraded = false;
        for (XMLElement parameterValueItemEl : parameterValueItems) {
            upgraded |= this.AddInclusiveToParameterValueItem(parameterValueItemEl);
        }
        return upgraded;
    }

    private boolean AddInclusiveToParameterValueItem(XMLElement parameterValueItem) {
        if (parameterValueItem == null) {
            return false;
        }
        boolean upgraded = false;
        String parameterType = parameterValueItem.xsiType_;
        if (parameterType == null) {
            return false;
        }
        if (!this.shouldUpgradeParameterType(parameterType)) {
            return false;
        }
        XMLElement inclusiveEl = parameterValueItem.getOptionalChildWithNameEvenIfNil(INCLUSIVE_ELEMENT_NAME);
        if (inclusiveEl != null && inclusiveEl.isNil_) {
            inclusiveEl.value_ = "true";
            inclusiveEl.isNil_ = false;
            upgraded = true;
        } else if (inclusiveEl == null) {
            inclusiveEl = parameterValueItem.addChild(0, null, INCLUSIVE_ELEMENT_NAME, CMSOAPConstants.NS_XMLSCHEMA, "boolean", "true");
            inclusiveEl.isNil_ = false;
            upgraded = true;
        }
        if (parameterType.equals(hierarchicalParmValueItemType)) {
            XMLElement valueEl;
            XMLElement subNodesEl = parameterValueItem.getOptionalChildWithName("subNodes");
            if (subNodesEl != null && subNodesEl.children_ != null) {
                upgraded |= this.upgradeParameterItemValues(subNodesEl.children_);
            }
            if ((valueEl = parameterValueItem.getOptionalChildWithName("value")) != null) {
                upgraded |= this.AddInclusiveToParameterValueItem(valueEl);
            }
        } else {
            XMLElement endEl;
            XMLElement startEl = parameterValueItem.getOptionalChildWithName(START_ELEMENT_NAME);
            if (startEl != null) {
                upgraded |= this.AddInclusiveToParameterValueItem(startEl);
            }
            if ((endEl = parameterValueItem.getOptionalChildWithName(END_ELEMENT_NAME)) != null) {
                upgraded |= this.AddInclusiveToParameterValueItem(endEl);
            }
        }
        return upgraded;
    }

    public boolean shouldUpgradeParameterType(String parameterType) {
        for (int i = 0; i < PARAMETER_TYPES.length; ++i) {
            if (!PARAMETER_TYPES[i].equals(parameterType)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        File scriptFolder = new File(".");
        File scriptFile = new File(scriptFolder, "parametersInput.xml");
        boolean eof = false;
        String currentLine = null;
        String parametersInput = new String();
        try {
            String parameters;
            BufferedReader script = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFile)));
            while (!eof) {
                currentLine = script.readLine();
                if (currentLine == null) {
                    eof = true;
                    currentLine = "";
                } else {
                    currentLine = currentLine.trim();
                }
                if (currentLine.length() <= 0) continue;
                parametersInput = parametersInput + currentLine;
            }
            HashMap<String, String> inputData = new HashMap<String, String>();
            inputData.put("parameters", parametersInput);
            CMUpgradeData data = new CMUpgradeData();
            data.setData(inputData);
            AddInclusiveToParameterValues plugin = new AddInclusiveToParameterValues();
            CMUpgradeResult results = plugin.upgrade(data);
            if (results == null) {
                System.out.println("results is NULL");
                System.exit(0);
            }
            if ((parameters = results.getPropertyValue("parameters")) != null) {
                System.out.println(parameters.toString());
            } else {
                System.out.println("NULL");
            }
        }
        catch (Exception ex) {
            System.out.println("Exception thrown:");
            ex.printStackTrace();
        }
    }
}

