/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.baltic;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.constants.PortalOptionEnum;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringNameValuePair;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMTypedNameValuePairArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MigratePortalPreferences
implements CMUpgradePlugin {
    private static Map<String, XMLElement> portalPreferencesMap_;
    private static String PROP_PORTALPREFS;
    private static String PROP_OPTIONS;
    private static String PROP_FORMAT;
    private static String defaultFormat_;
    private List<String> oldOptionsNameList_;
    private static Map<String, XMLElement> defaultOptionsMap_;
    private static boolean bDefaultValuesSet_;
    private static XMLElement defaultOptionsEl_;
    private static Map<String, String> prefsNOptsMap_;

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (!bDefaultValuesSet_) {
            try {
                this.setDefaultValues();
            }
            catch (Exception e) {
                CMIndications.logException(e, "cmFailedSetAccountDefault");
            }
        }
        String errorMessage = null;
        String portalPreferencesXML = null;
        String optionsXML = null;
        String formatXML = null;
        if (data != null) {
            portalPreferencesXML = (String)data.getPropertyValue(PROP_PORTALPREFS);
            optionsXML = (String)data.getPropertyValue(PROP_OPTIONS);
            formatXML = (String)data.getPropertyValue(PROP_FORMAT);
        }
        boolean bFormatSet = false;
        if (formatXML == null || formatXML.length() == 0) {
            formatXML = defaultFormat_;
            bFormatSet = true;
        }
        XMLElement optionsEl = null;
        if (portalPreferencesXML == null || portalPreferencesXML.length() == 0) {
            if (optionsXML == null || optionsXML.length() == 0) {
                optionsEl = defaultOptionsEl_;
            } else {
                try {
                    XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(optionsXML);
                    if (rootEl == null) {
                        optionsEl = defaultOptionsEl_;
                    } else {
                        optionsEl = rootEl.getChild(0);
                        if (optionsEl == null) {
                            optionsEl = defaultOptionsEl_;
                        } else {
                            boolean bOptionsChanged = this.mergeOptionsWithDefault(optionsEl);
                            if (!bOptionsChanged && !bFormatSet) {
                                return null;
                            }
                        }
                    }
                }
                catch (CMException e) {
                    errorMessage = e.getMessage();
                }
            }
        } else {
            XMLElement portalPreferencesEl = null;
            try {
                XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(portalPreferencesXML);
                if (rootEl != null) {
                    portalPreferencesEl = rootEl.getChild(0);
                }
                if (portalPreferencesEl == null) {
                    optionsEl = defaultOptionsEl_;
                } else {
                    optionsEl = new XMLElement("options", CMSOAPConstants.NS_BIBUS, "options");
                    this.migratePortalPreferences(portalPreferencesEl, optionsEl);
                }
            }
            catch (CMException e) {
                errorMessage = e.getMessage();
            }
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            if (optionsEl != null) {
                upgradedData.put(PROP_PORTALPREFS, null);
                String upgradedOptionsXML = optionsEl.makeXML(null, true, false);
                upgradedData.put(PROP_OPTIONS, upgradedOptionsXML);
            }
            if (bFormatSet) {
                upgradedData.put(PROP_FORMAT, formatXML);
            }
            result.setData(upgradedData);
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }

    private void migratePortalPreferences(XMLElement portalPreferencesEl, XMLElement optionsEl) throws CMException {
        XMLElement portalPreferencesValueEl;
        XMLElement optionsValueEl = optionsEl.getOptionalChildWithName("value");
        if (optionsValueEl == null) {
            optionsValueEl = optionsEl.addChild(null, "value", CMSOAPConstants.NS_BIBUS, CMPropertyTypes.BIBUS_OPTIONARRAY.getName());
            optionsValueEl.children_ = new ArrayList();
        }
        XMLElement encodedPreferencesvalueEl = portalPreferencesEl.getOptionalChildWithName("value");
        ArrayList<String> convertedOptList = new ArrayList<String>();
        if (encodedPreferencesvalueEl != null && encodedPreferencesvalueEl.value_ != null && (portalPreferencesValueEl = CMXMLUtils.convertXMLString2XMLElement(encodedPreferencesvalueEl.value_)) != null && portalPreferencesValueEl.children_ != null) {
            for (XMLElement prefEl : portalPreferencesValueEl.children_) {
                XMLElement optionEl;
                String prefName = prefEl.getAttribute("name");
                if (prefName == null || (optionEl = this.getMappedOption(prefName, prefEl.value_)) == null) continue;
                optionsValueEl.children_.add(optionEl);
                convertedOptList.add(prefsNOptsMap_.get(prefName));
            }
        }
        if (defaultOptionsMap_ != null) {
            Set<String> defaultOptKeys = defaultOptionsMap_.keySet();
            for (String sOptName : defaultOptKeys) {
                if (convertedOptList.contains(sOptName)) continue;
                optionsValueEl.children_.add(defaultOptionsMap_.get(sOptName));
            }
        }
    }

    private boolean mergeOptionsWithDefault(XMLElement optionsEl) {
        if (defaultOptionsEl_ == null) {
            return false;
        }
        XMLElement optionsValueEl = optionsEl.getOptionalChildWithName("value");
        if (optionsValueEl == null) {
            optionsValueEl = optionsEl.addChild(null, "value", CMSOAPConstants.NS_BIBUS, CMPropertyTypes.BIBUS_OPTIONARRAY.getName());
            optionsValueEl.children_ = new ArrayList();
        }
        boolean bChanged = false;
        this.setOldOptionsNameList(optionsEl);
        Set<String> defaultOptKeys = defaultOptionsMap_.keySet();
        for (String sName : defaultOptKeys) {
            if (this.oldOptionsNameList_.contains(sName)) continue;
            bChanged = true;
            optionsValueEl.children_.add(defaultOptionsMap_.get(sName));
        }
        return bChanged;
    }

    private void setOldOptionsNameList(XMLElement oldOptions) {
        this.oldOptionsNameList_ = new ArrayList<String>();
        ArrayList<XMLElement> items = oldOptions.getChild((int)0).children_;
        for (int i = 0; i < items.size(); ++i) {
            XMLElement item = (XMLElement)items.get(i);
            String sOptionName = item.getOptionalChildValueWithName("name");
            if (sOptionName == null || sOptionName.length() <= 0) continue;
            this.oldOptionsNameList_.add(sOptionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultValues() throws CMException {
        bDefaultValuesSet_ = true;
        CMStoreQueryResults results = null;
        CMTypedNameValuePairArray defaultOptionsPairArray = null;
        CMDbStoreString format = null;
        try {
            CMStoreXPath templateSrcPath = new CMStoreXPath("/configuration/account", 10);
            CMProperty[] properties = new CMProperty[]{CMProperty.OPTIONS, CMProperty.FORMAT};
            CMStore store = CMExecutionContext.get().getStore();
            results = store.executeQuery(templateSrcPath, properties, null, 0, 512, null);
            if (results == null || !results.next()) {
                throw new CMException("cmExportObjectNotFound", new CMException.Parm("Path", templateSrcPath.getFullPath()));
            }
            defaultOptionsPairArray = (CMTypedNameValuePairArray)results.getValue(0);
            format = (CMDbStoreString)results.getValue(1);
        }
        finally {
            results.release();
        }
        if (defaultOptionsPairArray != null) {
            defaultOptionsEl_ = new XMLElement("options", CMSOAPConstants.NS_BIBUS, "options");
            XMLElement optionsValueEl = defaultOptionsEl_.addChild(null, "value", CMSOAPConstants.NS_BIBUS, CMPropertyTypes.BIBUS_OPTIONARRAY.getName());
            optionsValueEl.children_ = new ArrayList();
            for (int i = 0; i < defaultOptionsPairArray.getSize(); ++i) {
                CMDbStoreStringNameValuePair pair = (CMDbStoreStringNameValuePair)defaultOptionsPairArray.getItem(i);
                if (pair == null) continue;
                if (defaultOptionsMap_ == null) {
                    defaultOptionsMap_ = new HashMap<String, XMLElement>();
                }
                defaultOptionsMap_.put(pair.getName(), this.getOptionElemFromDefaultOptions(pair));
                optionsValueEl.children_.add(this.getOptionElemFromDefaultOptions(pair));
            }
        }
        if (format != null) {
            XMLElement defaultFormatEl = new XMLElement(PROP_FORMAT, CMSOAPConstants.NS_XMLSCHEMAINSTANCE, CMProperty.FORMAT.getType().getPropertyTypeName());
            XMLElement formatValueEl = defaultFormatEl.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMAINSTANCE, CMPropertyTypes.XML_STRING.getName());
            formatValueEl.value_ = format.getValue();
            defaultFormat_ = defaultFormatEl.makeXML(null, true, false);
        }
    }

    private XMLElement getMappedOption(String name, String value) throws CMException {
        XMLElement optionEl = null;
        if (portalPreferencesMap_ == null) {
            portalPreferencesMap_ = new HashMap<String, XMLElement>();
            portalPreferencesMap_.put("view", this.getPortalOptionTemplateEl(PortalOptionEnum.DISPLAY_MODE));
            portalPreferencesMap_.put("liststyle", this.getPortalOptionTemplateEl(PortalOptionEnum.LIST_VIEW_SEPARATOR));
            portalPreferencesMap_.put("refresh", this.getPortalOptionTemplateEl(PortalOptionEnum.AUTOMATIC_PAGE_REFRESH));
            portalPreferencesMap_.put("lines", this.getPortalOptionTemplateEl(PortalOptionEnum.LINES_PER_PAGE));
            portalPreferencesMap_.put("runoptions", this.getPortalOptionTemplateEl(PortalOptionEnum.SHOW_OPTION_SUMMARY));
            portalPreferencesMap_.put("columns", this.getPortalOptionTemplateEl(PortalOptionEnum.COLUMNS_PER_PAGE));
        }
        if ((optionEl = portalPreferencesMap_.get(name)) != null) {
            XMLElement valueEl = optionEl.getChildWithName("value");
            valueEl.value_ = name.equals("liststyle") ? this.getMappedListStyleValue(value) : (name.equals("runoptions") ? this.getMappedRunOptionsValue(value) : value);
        }
        return optionEl;
    }

    private XMLElement getOptionElemFromDefaultOptions(CMDbStoreStringNameValuePair pair) {
        String xmlEncodedNameValue;
        if (pair == null) {
            return null;
        }
        XMLElement optionEl = new XMLElement("item", CMSOAPConstants.NS_BIBUS, pair.getTypeName());
        optionEl.doXMLEncodeOnValue_ = false;
        optionEl.value_ = xmlEncodedNameValue = pair.getXMLContentWithoutNSPrefix(CMProperty.OPTIONS);
        return optionEl;
    }

    private XMLElement getPortalOptionTemplateEl(PortalOptionEnum option) {
        XMLElement optionEl = new XMLElement("item", CMSOAPConstants.NS_BIBUS, option.type());
        XMLElement nameEl = optionEl.addChild(null, "name", CMSOAPConstants.NS_BIBUS, "portalOptionEnum");
        nameEl.value_ = option.name();
        optionEl.addChild(null, "value", option.valueNamespace(), option.valueType());
        return optionEl;
    }

    private String getMappedListStyleValue(String liststyle) {
        if (liststyle.equals("0")) {
            return "none";
        }
        if (liststyle.equals("1")) {
            return "line";
        }
        if (liststyle.equals("2")) {
            return "background";
        }
        return null;
    }

    private String getMappedRunOptionsValue(String runoptions) {
        if (runoptions.equals("y")) {
            return "true";
        }
        if (runoptions.equals("n")) {
            return "false";
        }
        return null;
    }

    static {
        PROP_PORTALPREFS = "portalPreferences";
        PROP_OPTIONS = "options";
        PROP_FORMAT = "format";
        if (prefsNOptsMap_ == null) {
            prefsNOptsMap_ = new HashMap<String, String>();
            prefsNOptsMap_.put("view", PortalOptionEnum.DISPLAY_MODE.name());
            prefsNOptsMap_.put("liststyle", PortalOptionEnum.LIST_VIEW_SEPARATOR.name());
            prefsNOptsMap_.put("refresh", PortalOptionEnum.AUTOMATIC_PAGE_REFRESH.name());
            prefsNOptsMap_.put("lines", PortalOptionEnum.LINES_PER_PAGE.name());
            prefsNOptsMap_.put("runoptions", PortalOptionEnum.SHOW_OPTION_SUMMARY.name());
            prefsNOptsMap_.put("columns", PortalOptionEnum.COLUMNS_PER_PAGE.name());
        }
    }
}

